/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.authorization;

import de.justsoftware.drive.common.authorization.model.Role;
import de.justsoftware.drive.common.person.model.PersonId;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.session.ResultHandler;

@ParametersAreNonnullByDefault
@Mapper
public interface PersonRoleMapper {
    @Insert(value={"<script>", "INSERT INTO person_role(person_id, role, static_role)", "SELECT #{personId}, #{role}, #{static_role}", "<if test=\"_databaseId == 'ORACLE'\">FROM dual</if>", "WHERE NOT EXISTS (SELECT 1 FROM person_role WHERE person_id = #{personId} AND role = #{role})", "</script>"})
    public void insert(@Param(value="personId") PersonId var1, @Param(value="role") Role var2, @Param(value="static_role") boolean var3);

    @Delete(value={"<script>", "DELETE FROM person_role", "WHERE (person_id, role) IN (<foreach collection='rolesToDelete' index='key' item='value' separator=','>(#{key},#{value})</foreach>)", "</script>"})
    public void delete(@Param(value="rolesToDelete") List<Map.Entry<PersonId, Role>> var1);

    @Select(value={"<script>", "SELECT person_id, role FROM person_role", "WHERE (person_id, role) IN (<foreach collection='entries' index='key' item='value' separator=','>(#{key}, #{value})</foreach>)", "</script>"})
    @Results(value={@Result(column="person_id", property="key", javaType=PersonId.class), @Result(column="role", property="value", javaType=Role.class)})
    @ResultType(value=Map.class)
    public void hasRoles(ResultHandler<Map<String, Object>> var1, @Param(value="entries") List<Map.Entry<PersonId, Role>> var2);

    @Select(value={"<script>", "SELECT person_id, role FROM person_role", "WHERE role IN (<foreach collection='roles' item='r' separator=','>#{r}</foreach>)", "</script>"})
    @Results(value={@Result(column="role", property="key", javaType=Role.class), @Result(column="person_id", property="value", javaType=PersonId.class)})
    @ResultType(value=Map.class)
    public void getPersonWithRoles(ResultHandler<Map<String, Object>> var1, @Param(value="roles") List<Role> var2);
}

