/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.common;

import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.jwtfilter.generator.JwtClaimsBuilder;
import de.justsoftware.jwtfilter.generator.JwtGenerator;
import de.justsoftware.jwtfilter.keys.JwtKeyLoadingException;
import de.justsoftware.jwtfilter.verifier.JwtVerificationConstraintBuilder;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.jose4j.jwt.GeneralJwtException;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.lang.JoseException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class PreviewAccessTokenService {
    private static final String FILE_VERSION_ID_CLAIM = "fileVersionId";
    private final JwtGenerator _jwtGenerator;
    private final JwtVerifier _jwtVerifier;
    private final int _lifeTimeInMinutes;

    public PreviewAccessTokenService(@Qualifier(value="signedJwtGenerator") JwtGenerator jwtGenerator, @Qualifier(value="signedJwtVerifier") JwtVerifier jwtVerifier, @Value(value="${just.drive.previews.videoPreviewLink.lifetimeMinutes:60}") int lifeTimeInMinutes) {
        this._jwtGenerator = jwtGenerator;
        this._jwtVerifier = jwtVerifier;
        this._lifeTimeInMinutes = lifeTimeInMinutes;
    }

    @Nonnull
    public String encodeFileVersionId(DocumentVersionId id) {
        JwtClaimsBuilder claimsBuilder = new JwtClaimsBuilder();
        claimsBuilder.withLifetime((long)this._lifeTimeInMinutes).withCustomClaim(FILE_VERSION_ID_CLAIM, id.toUUIDString());
        try {
            return this._jwtGenerator.generateJWT(claimsBuilder);
        }
        catch (JwtKeyLoadingException | JoseException e) {
            throw new IllegalStateException("Could not generate JWT for video preview", e);
        }
    }

    @Nonnull
    public DocumentVersionId extractFileVersionId(String jwt) {
        try {
            JwtClaims verify = this._jwtVerifier.verify(new JwtVerificationConstraintBuilder(), jwt);
            String stringClaimValue = verify.getStringClaimValue(FILE_VERSION_ID_CLAIM);
            return new DocumentVersionId(stringClaimValue);
        }
        catch (JwtKeyLoadingException | GeneralJwtException | InvalidJwtException e) {
            throw new IllegalArgumentException("Could not extract DocumentVersionId from JWT", e);
        }
    }
}

