/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.change.impl;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import de.justsoftware.drive.business.change.ChangeModificationService;
import de.justsoftware.drive.business.document.DocumentPublicity;
import de.justsoftware.drive.business.document.DocumentPublisher;
import de.justsoftware.drive.business.document.DocumentTreeModificationService;
import de.justsoftware.drive.business.document.ItemLockService;
import de.justsoftware.drive.business.event.DocumentPublicityUpdated;
import de.justsoftware.drive.business.exception.PermissionDeniedException;
import de.justsoftware.drive.business.exception.UnknownResourceBusinessException;
import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.change.model.ChangeVersionUpdateModel;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.persistence.change.ChangeDAO;
import de.justsoftware.drive.persistence.document.DocumentDAO;
import de.justsoftware.drive.persistence.document.DocumentVersionDAO;
import de.justsoftware.drive.persistence.folder.SubFolderDAO;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class ChangeModificationServiceImpl
implements ChangeModificationService {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeModificationServiceImpl.class);
    private final ChangeDAO _changeDAO;
    private final SubFolderDAO _subFolderDAO;
    private final DocumentVersionDAO _documentVersionDAO;
    private final DocumentDAO _documentDAO;
    private final EventBus _eventBus;
    private final ItemLockService _itemLockService;
    private final DocumentTreeModificationService _documentTreeModificationService;
    private final DocumentPublisher _documentPublisher;

    @Autowired
    public ChangeModificationServiceImpl(DocumentTreeModificationService documentTreeModificationService, ChangeDAO changeDAO, SubFolderDAO subFolderDAO, DocumentVersionDAO documentVersionDAO, DocumentDAO documentDAO, DocumentPublisher documentPublisher, EventBus eventBus, ItemLockService itemLockService) {
        this._documentTreeModificationService = documentTreeModificationService;
        this._changeDAO = changeDAO;
        this._subFolderDAO = subFolderDAO;
        this._documentVersionDAO = documentVersionDAO;
        this._documentDAO = documentDAO;
        this._documentPublisher = documentPublisher;
        this._eventBus = eventBus;
        this._itemLockService = itemLockService;
    }

    public ChangeBO getOrCreateNewestChange(ItemId itemId, PersonId owner, PublishedFilter publishedFilter, String purpose) {
        ChangeBO newestPrivateChange;
        Function loadNewestChange = filter -> (ChangeBO)this._changeDAO.getNewestChangePerItem((Set)ImmutableSet.of((Object)itemId), filter).get((Object)itemId);
        ChangeBO newestChange = (ChangeBO)loadNewestChange.apply((Object)publishedFilter);
        if (newestChange != null) {
            return newestChange;
        }
        if (publishedFilter != PublishedFilter.PUBLISHED_OR_PRIVATE && (newestPrivateChange = (ChangeBO)loadNewestChange.apply((Object)PublishedFilter.PUBLISHED_OR_PRIVATE)) != null) {
            throw new PermissionDeniedException("can't create a public change because a private version exists");
        }
        this._documentTreeModificationService.createRootFolders((Map)ImmutableMap.of((Object)itemId, (Object)owner), purpose);
        return (ChangeBO)UnknownResourceBusinessException.checkNotNull((Object)((ChangeBO)loadNewestChange.apply((Object)publishedFilter)), (String)("Created a new change but it can't be loaded or is private " + String.valueOf(itemId)));
    }

    public void createRootFoldersIfNecessary(Map<ItemId, PersonId> owners) {
        ImmutableMap existing = this._changeDAO.getNewestChangePerItem(owners.keySet(), PublishedFilter.PUBLISHED_OR_PRIVATE);
        Map ownersOfMissing = Maps.filterKeys(owners, (Predicate)Predicates.not(arg_0 -> ((ImmutableSet)existing.keySet()).contains(arg_0)));
        this._documentTreeModificationService.createRootFolders(ownersOfMissing, null);
    }

    public void updateChangeVersions(Map<DocumentVersionId, ChangeVersionUpdateModel> changeVersions, Consumer<Runnable> afterCommitCallbackConsumer) {
        ImmutableMap changes = this._changeDAO.getChangesByIds(changeVersions.keySet());
        ImmutableSet items = (ImmutableSet)changes.values().stream().map(ChangeBO::getItemId).collect(ImmutableSet.toImmutableSet());
        this._itemLockService.acquireAndExecute((Set)items, () -> {
            ImmutableMap newestPublicChangesBefore = this._changeDAO.getNewestChangePerItem((Set)items, PublishedFilter.ONLY_PUBLISHED);
            this._changeDAO.updateChangeVersions(changeVersions);
            ImmutableMap newestPublicChangesAfter = this._changeDAO.getNewestChangePerItem((Set)items, PublishedFilter.ONLY_PUBLISHED);
            ImmutableSet expirationDateUpdates = ChangeModificationServiceImpl.updatedItems((Map)newestPublicChangesBefore, (Map)newestPublicChangesAfter, ChangeBO::getExpirationDate);
            ImmutableMap updatedDocuments = this.updateDocumentsAndVersions(changeVersions.keySet());
            this._eventBus.post((Object)new DocumentPublicityUpdated(updatedDocuments, expirationDateUpdates));
            afterCommitCallbackConsumer.accept(() -> this.publishPublicVersions(newestPublicChangesBefore, newestPublicChangesAfter));
            return this;
        });
    }

    private void publishPublicVersions(ImmutableMap<ItemId, ChangeBO> newestPublicChangesBefore, ImmutableMap<ItemId, ChangeBO> newestPublicChangesAfter) {
        ImmutableSet changedItems = ChangeModificationServiceImpl.updatedItems(newestPublicChangesBefore, newestPublicChangesAfter, ChangeBO::getId);
        this._documentPublisher.publishItems((Set)changedItems, newestPublicChangesAfter, (Set)ImmutableSet.of((Object)DocumentPublicity.PUBLIC));
    }

    @Nonnull
    private static ImmutableSet<ItemId> updatedItems(Map<ItemId, ChangeBO> newestPublicChangesBefore, Map<ItemId, ChangeBO> newestPublicChangesAfter, Function<? super ChangeBO, ?> func) {
        Sets.SetView symmetricDifference = Sets.symmetricDifference(Maps.transformValues(newestPublicChangesBefore, func).entrySet(), Maps.transformValues(newestPublicChangesAfter, func).entrySet());
        return FluentIterable.from((Iterable)symmetricDifference).transform(Map.Entry::getKey).toSet();
    }

    @Nonnull
    private ImmutableMap<DocumentId, DocumentVersionId> updateDocumentsAndVersions(Set<DocumentVersionId> changeIds) {
        ImmutableMap changes = this._changeDAO.getChangesByIds(changeIds);
        ImmutableSet privateDocuments = this.markDocumentsPrivate(changes);
        Set allNewPublicVersions = this.markDocumentsPublic(changes);
        ImmutableMap documents = this._documentVersionDAO.getDocumentIdsOfVersions((Set)Sets.union((Set)allNewPublicVersions, (Set)privateDocuments));
        ImmutableSet documentsWithPossiblyChangedPublicVersion = ImmutableSet.copyOf((Collection)documents.values());
        this._documentDAO.updateLastPublicVersions((Set)documentsWithPossiblyChangedPublicVersion);
        ImmutableBiMap lastPublicVersions = this._documentDAO.getLastVersions((Set)documentsWithPossiblyChangedPublicVersion, PublishedFilter.ONLY_PUBLISHED);
        Sets.SetView missing = Sets.difference((Set)documentsWithPossiblyChangedPublicVersion, (Set)lastPublicVersions.keySet());
        ImmutableBiMap lastPrivateVersions = this._documentDAO.getLastVersions((Set)missing, PublishedFilter.PUBLISHED_OR_PRIVATE);
        return ImmutableMap.builder().putAll((Map)lastPublicVersions).putAll((Map)lastPrivateVersions).build();
    }

    @Nonnull
    private ImmutableSet<DocumentVersionId> markDocumentsPrivate(ImmutableMap<DocumentVersionId, ChangeBO> changes) {
        Set privateChanges = Maps.filterValues(changes, c -> !c.isPublic()).keySet();
        ImmutableSetMultimap nowPossiblePrivateDocumentVersions = this._documentVersionDAO.getPublishedDocumentsForChange(privateChanges);
        ImmutableSet affectedDocumentVersions = nowPossiblePrivateDocumentVersions.inverse().keySet();
        ImmutableMap newPublicChanges = this._documentVersionDAO.getFirstPublishedChangesForDocumentsVersionsRecursive((Set)affectedDocumentVersions);
        this._documentVersionDAO.deletePublishedChange((Set)Sets.difference((Set)affectedDocumentVersions, (Set)newPublicChanges.keySet()));
        this._documentVersionDAO.setFirstPublishedChange((Map)newPublicChanges);
        return affectedDocumentVersions;
    }

    @Nonnull
    private Set<DocumentVersionId> markDocumentsPublic(ImmutableMap<DocumentVersionId, ChangeBO> changes) {
        HashMap<DocumentVersionId, ChangeBO> queue = new HashMap<DocumentVersionId, ChangeBO>(Maps.filterValues(changes, ChangeBO::isPublic));
        HashMap knownPublicVersions = new HashMap();
        HashMap allNewPublicVersions = new HashMap();
        while (!queue.isEmpty()) {
            ImmutableMap docs = this._documentVersionDAO.getFirstPublishedChangesForDocumentVersions((Set)Sets.difference(queue.keySet(), knownPublicVersions.keySet()));
            ImmutableMap changesByIds = this._changeDAO.getChangesByIds((Set)ImmutableSet.copyOf((Collection)docs.values()));
            HashMap<DocumentVersionId, ChangeBO> newPublicVersions = new HashMap<DocumentVersionId, ChangeBO>();
            queue.forEach((documentVersionId, change) -> {
                Optional current;
                if (!change.isPublic()) {
                    LOG.warn("non public change found and skipped, this should not happen: {}: {}", documentVersionId, change);
                }
                if (!(current = knownPublicVersions.computeIfAbsent(documentVersionId, d -> Optional.fromNullable((Object)((ChangeBO)changesByIds.get(docs.get(d)))))).isPresent() || !((ChangeBO)current.get()).isPublic() || change.getVersion() < ((ChangeBO)current.get()).getVersion()) {
                    newPublicVersions.put((DocumentVersionId)documentVersionId, (ChangeBO)change);
                    knownPublicVersions.put(documentVersionId, Optional.of((Object)change));
                }
            });
            allNewPublicVersions.putAll(newPublicVersions);
            ImmutableSetMultimap children = this._subFolderDAO.getSubFoldersByIds(newPublicVersions.keySet());
            queue.clear();
            newPublicVersions.forEach((documentVersionId, change) -> children.get(documentVersionId).forEach(childDocumentVersionId -> {
                ChangeBO existing = (ChangeBO)queue.get(childDocumentVersionId);
                if (existing == null || existing.getVersion() > change.getVersion()) {
                    queue.put((DocumentVersionId)childDocumentVersionId, (ChangeBO)change);
                }
            }));
        }
        this._documentVersionDAO.setFirstPublishedChange(Maps.transformValues(allNewPublicVersions, ChangeBO::getId));
        return allNewPublicVersions.keySet();
    }
}

