/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.services.tasks.processes.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.jdoc.services.tasks.processes.model.WatchedProcessId;
import javax.annotation.Nonnull;

public class CommandlineCallToWatch {
    private final WatchedProcessId _id;
    private final ImmutableSet<String> _identifiers;
    private final long _creationDate;
    private final long _maxRuntimeInMillis;
    private boolean _survivor;

    public CommandlineCallToWatch(@Nonnull WatchedProcessId id, @Nonnull ImmutableSet<String> identifiers, long maxRuntimeInMillis) {
        this._id = id;
        this._identifiers = identifiers;
        this._creationDate = System.currentTimeMillis();
        this._maxRuntimeInMillis = maxRuntimeInMillis;
        this._survivor = false;
    }

    @Nonnull
    public WatchedProcessId getId() {
        return this._id;
    }

    @Nonnull
    public ImmutableSet<String> getIdentifiers() {
        return this._identifiers;
    }

    public long getCreationDate() {
        return this._creationDate;
    }

    public long getMaxRuntimeInMillis() {
        return this._maxRuntimeInMillis;
    }

    public boolean isSurvivor() {
        return this._survivor;
    }

    public void setSurvivor(boolean survivor) {
        this._survivor = survivor;
    }

    public void markAsSurvivor() {
        this.setSurvivor(true);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("identifiers", (Object)this.getIdentifiers()).add("creationDate", this.getCreationDate()).add("maxRuntimeInMillis", this.getMaxRuntimeInMillis()).add("survivor", this.isSurvivor()).toString();
    }
}

