/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.search;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.model.Chat;
import de.justsoftware.chat.business.model.ChatMessage;
import de.justsoftware.chat.business.model.ChatParticipant;
import de.justsoftware.chat.business.model.OneOnOneChat;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.business.model.UserMessage;
import de.justsoftware.chat.kafka.KafkaObjectMapper;
import de.justsoftware.chat.kafka.search.ChatCoreSearchUpdateIndexProducer;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatMessageId;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.SearchId;
import de.justsoftware.chat.search.SolrIndexService;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.KafkaUtilsKt;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 C2\u00020\u0001:\u0002BCBA\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010\u001a\u001a\u00020\u001bH\u0016J!\u0010\u001c\u001a\u00020\u001b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001eH\u0011\u00a2\u0006\u0002\b J\u0016\u0010!\u001a\u00020\u001b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0012J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020&0#2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0012J\"\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020)0+2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020,0.H\u0012JH\u0010/\u001a\u0014\u0012\u0004\u0012\u000200\u0012\n\u0012\b\u0012\u0004\u0012\u0002010#0+2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002030+2\u0018\u00104\u001a\u0014\u0012\u0004\u0012\u000200\u0012\n\u0012\b\u0012\u0004\u0012\u0002050#0+H\u0012J\u001a\u00106\u001a\u00020\u001b*\u00020\u00132\f\u00107\u001a\b\u0012\u0004\u0012\u00020&0#H\u0012J\u001a\u00108\u001a\u00020\u001b*\u00020\u00132\f\u00107\u001a\b\u0012\u0004\u0012\u00020&0#H\u0012J\u001a\u00109\u001a\u00020\u001b*\u00020\u00132\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001f0#H\u0012J\u001a\u0010;\u001a\u00020\u001b*\u00020\u00132\f\u0010<\u001a\b\u0012\u0004\u0012\u0002000.H\u0012J\u001a\u0010=\u001a\u00020\u001b*\u00020\u00132\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001f0#H\u0012J\b\u0010>\u001a\u00020?H\u0012J\u001e\u0010@\u001a\b\u0012\u0004\u0012\u00020$0#*\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0AH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u00020\u00138\u0010X\u0091\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0092\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lde/justsoftware/chat/search/SolrIndexService;", "", "chatCoreLeaderSolrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "chatService", "Lde/justsoftware/chat/business/ChatService;", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "chatMessageService", "Lde/justsoftware/chat/business/ChatMessageService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "chatCoreSearchUpdateIndexProducer", "Lde/justsoftware/chat/kafka/search/ChatCoreSearchUpdateIndexProducer;", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "<init>", "(Lorg/apache/solr/client/solrj/SolrClient;Lde/justsoftware/chat/business/ChatService;Lde/justsoftware/chat/business/ChatParticipantService;Lde/justsoftware/chat/business/ChatMessageService;Lde/justsoftware/chat/business/ProfileService;Lde/justsoftware/chat/kafka/search/ChatCoreSearchUpdateIndexProducer;Lio/micrometer/core/instrument/MeterRegistry;)V", "chatSolrCore", "Lde/justsoftware/chat/search/SolrIndexService$SolrCore;", "getChatSolrCore$chat_service$annotations", "()V", "getChatSolrCore$chat_service", "()Lde/justsoftware/chat/search/SolrIndexService$SolrCore;", "chatCoreReindexThread", "Ljava/lang/Thread;", "reindexChatCore", "", "onIndexChatCore", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "", "onIndexChatCore$chat_service", "indexChatCore", "searchIds", "", "Lde/justsoftware/chat/model/SearchId;", "toSolrInputDocuments", "Lorg/apache/solr/common/SolrInputDocument;", "userMessages", "", "Lde/justsoftware/chat/business/model/UserMessage;", "loadUserMessages", "", "Lde/justsoftware/chat/model/ChatMessageId;", "chatMessageIds", "", "loadOneOnOneChatPartners", "Lde/justsoftware/chat/model/ChatId;", "Lde/justsoftware/chat/business/model/Profile;", "chats", "Lde/justsoftware/chat/business/model/Chat;", "chatParticipants", "Lde/justsoftware/chat/business/model/ChatParticipant;", "addSolrDocuments", "documents", "addSolrDocumentsIndividually", "deleteSolrDocuments", "ids", "deleteByChatIds", "chatIds", "deleteSolrDocumentsIndividually", "isReindexingChatCore", "", "toSearchIds", "Lorg/apache/kafka/clients/consumer/ConsumerRecord;", "SolrCore", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nSolrIndexService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolrIndexService.kt\nde/justsoftware/chat/search/SolrIndexService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 5 ChatParticipant.kt\nde/justsoftware/chat/business/model/ChatParticipant$Companion\n+ 6 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 7 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,324:1\n1611#2,9:325\n1863#2:334\n1864#2:336\n1620#2:337\n817#2,2:339\n817#2,2:342\n1557#2:344\n1628#2,3:345\n1557#2:348\n1628#2,3:349\n1557#2:352\n1628#2,3:353\n1557#2:356\n1628#2,3:357\n1611#2,9:362\n1863#2:371\n1864#2:373\n1620#2:374\n1187#2,2:376\n1261#2,4:378\n808#2,11:382\n1628#2,3:394\n1611#2,9:397\n1863#2:406\n1864#2:408\n1620#2:409\n1557#2:411\n1628#2,3:412\n817#2,2:417\n1279#2,2:419\n1293#2,2:421\n1611#2,9:423\n1863#2:432\n1864#2:434\n1620#2:435\n1296#2:436\n1863#2,2:437\n1557#2:439\n1628#2,3:440\n1863#2,2:443\n1863#2,2:445\n1#3:335\n1#3:372\n1#3:407\n1#3:433\n22#4:338\n22#4:341\n80#4,2:360\n82#4:375\n7#4:393\n22#4:416\n41#5:410\n42#5:415\n58#6:447\n51#6:448\n9#7:449\n8#7,3:450\n*S KotlinDebug\n*F\n+ 1 SolrIndexService.kt\nde/justsoftware/chat/search/SolrIndexService\n*L\n115#1:325,9\n115#1:334\n115#1:336\n115#1:337\n122#1:339,2\n123#1:342,2\n132#1:344\n132#1:345,3\n142#1:348\n142#1:349,3\n142#1:352\n142#1:353,3\n158#1:356\n158#1:357,3\n162#1:362,9\n162#1:371\n162#1:373\n162#1:374\n162#1:376,2\n162#1:378,4\n170#1:382,11\n171#1:394,3\n173#1:397,9\n173#1:406\n173#1:408\n173#1:409\n175#1:411\n175#1:412,3\n175#1:417,2\n177#1:419,2\n177#1:421,2\n180#1:423,9\n180#1:432\n180#1:434\n180#1:435\n177#1:436\n200#1:437,2\n229#1:439\n229#1:440,3\n231#1:443,2\n246#1:445,2\n115#1:335\n162#1:372\n173#1:407\n180#1:433\n122#1:338\n123#1:341\n162#1:360,2\n162#1:375\n171#1:393\n175#1:416\n175#1:410\n175#1:415\n261#1:447\n261#1:448\n271#1:449\n271#1:450,3\n*E\n"})
public class SolrIndexService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SolrClient chatCoreLeaderSolrClient;
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    private final ChatMessageService chatMessageService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final ChatCoreSearchUpdateIndexProducer chatCoreSearchUpdateIndexProducer;
    @NotNull
    private final SolrCore chatSolrCore;
    @Nullable
    private Thread chatCoreReindexThread;
    @NotNull
    private static final Logger LOG;

    public SolrIndexService(@Qualifier(value="chatCoreLeaderSolrClient") @NotNull SolrClient chatCoreLeaderSolrClient, @NotNull ChatService chatService, @NotNull ChatParticipantService chatParticipantService, @NotNull ChatMessageService chatMessageService, @NotNull ProfileService profileService, @NotNull ChatCoreSearchUpdateIndexProducer chatCoreSearchUpdateIndexProducer, @NotNull MeterRegistry meterRegistry) {
        Intrinsics.checkNotNullParameter((Object)chatCoreLeaderSolrClient, (String)"chatCoreLeaderSolrClient");
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        Intrinsics.checkNotNullParameter((Object)chatMessageService, (String)"chatMessageService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)chatCoreSearchUpdateIndexProducer, (String)"chatCoreSearchUpdateIndexProducer");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        this.chatCoreLeaderSolrClient = chatCoreLeaderSolrClient;
        this.chatService = chatService;
        this.chatParticipantService = chatParticipantService;
        this.chatMessageService = chatMessageService;
        this.profileService = profileService;
        this.chatCoreSearchUpdateIndexProducer = chatCoreSearchUpdateIndexProducer;
        this.chatSolrCore = new SolrCore("chat", this.chatCoreLeaderSolrClient, meterRegistry);
    }

    @NotNull
    public SolrCore getChatSolrCore$chat_service() {
        return this.chatSolrCore;
    }

    @VisibleForTesting
    public static /* synthetic */ void getChatSolrCore$chat_service$annotations() {
    }

    public void reindexChatCore() {
        if (this.isReindexingChatCore()) {
            LOG.info("Skip reindexing chat core, since a reindexing process is still alive...");
            return;
        }
        this.chatCoreReindexThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, () -> SolrIndexService.reindexChatCore$lambda$0(this), (int)31, null);
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="chatCoreSearchUpdateIndexConsumer", containerFactory="chatCoreSearchUpdateIndexConsumerFactory", topics={"just.chat-service.search.chat.updateIndex"}, idIsGroup=false)
    public void onIndexChatCore$chat_service(@NotNull ConsumerRecords<String, String> records) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable iterable = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        SolrIndexService solrIndexService = this;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            List it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ConsumerRecord it = (ConsumerRecord)element$iv$iv;
            boolean bl2 = false;
            if (this.toSearchIds(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        solrIndexService.indexChatCore(CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    private void indexChatCore(List<? extends SearchId> searchIds) {
        Collection<String> collection;
        Collection<String> collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Collection collection3;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        if (searchIds.isEmpty()) {
            return;
        }
        Iterable $this$filterIsInstanceToSet$iv = searchIds;
        boolean $i$f$filterIsInstanceToSet = false;
        Iterable iterable = $this$filterIsInstanceToSet$iv;
        Iterable destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv));
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof ChatId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set chatIds = (Set)destination$iv$iv;
        Iterable $this$filterIsInstanceToSet$iv2 = searchIds;
        boolean $i$f$filterIsInstanceToSet2 = false;
        destination$iv$iv = $this$filterIsInstanceToSet$iv2;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv2));
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ChatMessageId)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set chatMessageIds = (Set)destination$iv$iv2;
        Map chats2 = this.chatService.findByIds(chatIds);
        Map chatParticipants = this.chatParticipantService.findByChatIds((Iterable)chats2.keySet());
        Map chatPartners = this.loadOneOnOneChatPartners(chats2, chatParticipants);
        Set chatIdsToDeleted = SetsKt.minus((Set)chatIds, (Iterable)chats2.keySet());
        Map userMessages = this.loadUserMessages(chatMessageIds);
        Set messageIdsToDeleted = SetsKt.minus((Set)chatMessageIds, (Iterable)userMessages.keySet());
        Iterable iterable2 = chats2.values();
        boolean $i$f$map22 = false;
        void var13_20 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void chat;
            Chat chat2 = (Chat)item$iv$iv;
            collection3 = destination$iv$iv3;
            boolean bl = false;
            collection3.add(Companion.access$toChatCoreSolrDocument((Companion)Companion, (Chat)chat, (List)((List)chatPartners.get(chat.getId())), (List)chatParticipants.getOrDefault(chat.getId(), CollectionsKt.emptyList())));
        }
        List chatSolrInputDocs = (List)destination$iv$iv3;
        List messageSolrInputDocs = this.toSolrInputDocuments((Iterable)userMessages.values());
        Iterable $i$f$map22 = chatIdsToDeleted;
        SolrCore solrCore = this.getChatSolrCore$chat_service();
        collection3 = this;
        boolean $i$f$map = false;
        destination$iv$iv3 = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatId bl = (ChatId)item$iv$iv;
            collection2 = destination$iv$iv4;
            boolean $i$f$indexChatCore$stub_for_inlining = false;
            boolean bl2 = false;
            collection2.add(p0.toCanonicalId());
        }
        collection2 = (List)destination$iv$iv4;
        $this$map$iv = messageIdsToDeleted;
        collection2 = collection2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChatMessageId p0 = (ChatMessageId)item$iv$iv;
            collection = destination$iv$iv4;
            boolean $i$f$indexChatCore$stub_for_inlining$3 = false;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        collection = (List)destination$iv$iv4;
        super.deleteSolrDocuments(solrCore, CollectionsKt.plus(collection2, (Iterable)collection));
        this.deleteByChatIds(this.getChatSolrCore$chat_service(), chatIdsToDeleted);
        this.addSolrDocuments(this.getChatSolrCore$chat_service(), CollectionsKt.plus((Collection)chatSolrInputDocs, (Iterable)messageSolrInputDocs));
        LOG.debug("Index Summary: \nIndexed documents: " + (chatSolrInputDocs.size() + messageSolrInputDocs.size()) + "\nChats documents: " + chatSolrInputDocs.size() + "\nmessages documents: " + messageSolrInputDocs.size() + "\ndeleted documents: " + chatIdsToDeleted.size());
    }

    /*
     * WARNING - void declaration
     */
    private List<SolrInputDocument> toSolrInputDocuments(Iterable<UserMessage> userMessages) {
        void $this$mapTo$iv$iv;
        Iterable<UserMessage> $this$map$iv = userMessages;
        boolean $i$f$map = false;
        Iterable<UserMessage> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void userMessage;
            UserMessage userMessage2 = (UserMessage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Companion.access$toChatCoreSolrDocument((Companion)Companion, (UserMessage)userMessage));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ChatMessageId, UserMessage> loadUserMessages(Set<ChatMessageId> chatMessageIds) {
        void $this$associateTo$iv$iv$iv;
        void $this$associate$iv$iv;
        void $this$mapNotNullTo$iv$iv$iv;
        Iterable $this$mapNotNull$iv$iv;
        Map $this$mapValuesNotNull$iv = this.chatMessageService.findByIds(chatMessageIds);
        boolean $i$f$mapValuesNotNull = false;
        Iterable iterable = $this$mapValuesNotNull$iv.entrySet();
        boolean $i$f$mapNotNull = false;
        void var6_6 = $this$mapNotNull$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv$iv;
            Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry$iv = (Map.Entry)element$iv$iv$iv;
            boolean bl2 = false;
            Map.Entry entry = entry$iv;
            boolean bl3 = false;
            ChatMessage message = (ChatMessage)entry.getValue();
            if ((message instanceof UserMessage ? (UserMessage)message : null) != null) {
                UserMessage it$iv;
                it$iv = it$iv;
                boolean bl4 = false;
                pair = TuplesKt.to(entry$iv.getKey(), (Object)it$iv);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        $this$mapNotNull$iv$iv = (List)destination$iv$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv$iv, (int)10)), (int)16);
        destination$iv$iv$iv = $this$associate$iv$iv;
        Map destination$iv$iv$iv2 = new LinkedHashMap(capacity$iv$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv$iv : $this$associateTo$iv$iv$iv) {
            Map map = destination$iv$iv$iv2;
            Pair it$iv = (Pair)element$iv$iv$iv;
            boolean bl = false;
            Pair pair = it$iv;
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ChatId, List<Profile>> loadOneOnOneChatPartners(Map<ChatId, ? extends Chat> chats2, Map<ChatId, ? extends List<ChatParticipant>> chatParticipants) {
        void $this$filterIsInstanceTo$iv$iv$iv;
        void $this$filterIsInstanceToSet$iv$iv;
        Iterable p0$iv;
        void $this$mapTo$iv$iv$iv;
        void $this$filterParticipantIds$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Iterable iterable = chats2.values();
        boolean $i$f$filterIsInstance = false;
        void var6_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv2 instanceof OneOnOneChat)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$mapToSet22 = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Chat chat = (Chat)item$iv$iv;
            object = destination$iv$iv;
            boolean $i$f$loadOneOnOneChatPartners$stub_for_inlining$6 = false;
            boolean bl = false;
            object.add(p0.getId());
        }
        Set oneOnOneChatIds = (Set)destination$iv$iv;
        ChatParticipant.Companion $i$f$mapToSet22 = ChatParticipant.Companion;
        $this$mapTo$iv$iv = oneOnOneChatIds;
        boolean $i$f$mapNotNull = false;
        void $i$f$mapTo22 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        ChatId bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            List<ChatParticipant> it$iv$iv;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl2 = false;
            ChatId p0 = (ChatId)element$iv$iv;
            boolean $i$f$loadOneOnOneChatPartners$stub_for_inlining$7 = false;
            boolean bl3 = false;
            if (chatParticipants.get(p0) == null) continue;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
        boolean $i$f$filterParticipantIds = false;
        Iterable $this$map$iv$iv = $this$filterParticipantIds$iv;
        boolean $i$f$map = false;
        void $i$f$mapNotNullTo22 = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
            element$iv$iv = (ChatParticipant)item$iv$iv$iv;
            Collection bl2 = destination$iv$iv$iv;
            boolean $i$f$filterParticipantIds$stub_for_inlining = false;
            boolean bl5 = false;
            bl2.add(p0$iv.getParticipantId());
        }
        $this$map$iv$iv = (List)destination$iv$iv$iv;
        boolean $i$f$filterIsInstanceToSet = false;
        $this$mapTo$iv$iv$iv = $this$filterIsInstanceToSet$iv$iv;
        destination$iv$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv$iv));
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof ProfileId)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        Set oneOnOneChatPartnerIds = (Set)destination$iv$iv$iv;
        Map profilesById = this.profileService.findByIds(oneOnOneChatPartnerIds);
        Iterable $this$associateWith$iv = oneOnOneChatIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv3 : $this$associateWithTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv2;
            void $this$mapNotNull$iv2;
            void chatId;
            bl = (ChatId)element$iv$iv3;
            Object e = element$iv$iv3;
            object = result$iv;
            boolean bl6 = false;
            p0$iv = chatParticipants.getOrDefault(chatId, CollectionsKt.emptyList());
            boolean $i$f$mapNotNull2 = false;
            void $i$f$filterParticipantIds$stub_for_inlining = $this$mapNotNull$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv2.iterator();
            while (iterator.hasNext()) {
                Profile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv4 = element$iv$iv$iv = iterator.next();
                boolean bl7 = false;
                ChatParticipant participant = (ChatParticipant)element$iv$iv4;
                boolean bl8 = false;
                if ((Profile)profilesById.get(participant.getParticipantId()) == null) continue;
                boolean bl9 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv3;
            object.put(e, list);
        }
        return result$iv;
    }

    private void addSolrDocuments(SolrCore $this$addSolrDocuments, List<? extends SolrInputDocument> documents2) {
        if (documents2.isEmpty()) {
            return;
        }
        try {
            $this$addSolrDocuments.getClient().add((Collection)documents2);
            $this$addSolrDocuments.getSuccessfulIndexedDocumentCount().addAndGet(documents2.size());
        }
        catch (SolrServerException e) {
            if (e.getCause() instanceof IOException) {
                throw e;
            }
            LOG.warn("Batch adding of " + documents2.size() + " documents for solr core " + $this$addSolrDocuments.getCoreName() + " failed. Try to add documents individually.", (Throwable)e);
            this.addSolrDocumentsIndividually($this$addSolrDocuments, documents2);
        }
    }

    private void addSolrDocumentsIndividually(SolrCore $this$addSolrDocumentsIndividually, List<? extends SolrInputDocument> documents2) {
        Iterable $this$forEach$iv = documents2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SolrInputDocument document = (SolrInputDocument)element$iv;
            boolean bl = false;
            try {
                $this$addSolrDocumentsIndividually.getClient().add(document);
                $this$addSolrDocumentsIndividually.getSuccessfulIndexedDocumentCount().incrementAndGet();
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                SolrInputField solrInputField = (SolrInputField)document.get((Object)"id");
                LOG.error("Failed to index solr document for " + (solrInputField != null ? solrInputField.getValue() : null) + " in solr core " + $this$addSolrDocumentsIndividually.getCoreName(), (Throwable)e);
                $this$addSolrDocumentsIndividually.getFailedIndexedDocumentCount().incrementAndGet();
            }
        }
    }

    private void deleteSolrDocuments(SolrCore $this$deleteSolrDocuments, List<String> ids) {
        if (ids.isEmpty()) {
            return;
        }
        try {
            $this$deleteSolrDocuments.getClient().deleteById(ids);
            $this$deleteSolrDocuments.getSuccessfulIndexedDocumentCount().addAndGet(ids.size());
        }
        catch (SolrServerException e) {
            if (e.getCause() instanceof IOException) {
                throw e;
            }
            LOG.warn("Batch deletion of " + ids.size() + " documents for solr core " + $this$deleteSolrDocuments.getCoreName() + " failed. Try to delete documents individually.", (Throwable)e);
            this.deleteSolrDocumentsIndividually($this$deleteSolrDocuments, ids);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void deleteByChatIds(SolrCore $this$deleteByChatIds, Set<ChatId> chatIds) {
        void $this$mapTo$iv$iv;
        if (chatIds.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = chatIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatId chatId = (ChatId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean $i$f$deleteByChatIds$stub_for_inlining$11 = false;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)20);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List chunk = (List)element$iv;
            boolean bl = false;
            try {
                LOG.info("Delete from " + $this$deleteByChatIds.getCoreName() + " core by chat_id = " + chunk);
                $this$deleteByChatIds.getClient().deleteByQuery(CollectionsKt.joinToString$default((Iterable)chunk, (CharSequence)" OR ", null, null, (int)0, null, SolrIndexService::deleteByChatIds$lambda$13$lambda$12, (int)30, null));
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                LOG.warn("Failed to delete by chatIds = " + chunk + " for for solr core " + $this$deleteByChatIds.getCoreName() + ". Deletion will be skipped!", (Throwable)e);
            }
        }
    }

    private void deleteSolrDocumentsIndividually(SolrCore $this$deleteSolrDocumentsIndividually, List<String> ids) {
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String id = (String)element$iv;
            boolean bl = false;
            try {
                $this$deleteSolrDocumentsIndividually.getClient().deleteById(id);
                $this$deleteSolrDocumentsIndividually.getSuccessfulIndexedDocumentCount().incrementAndGet();
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                LOG.error("Failed to delete solr document " + id + " from solr core " + $this$deleteSolrDocumentsIndividually.getCoreName(), (Throwable)e);
                $this$deleteSolrDocumentsIndividually.getFailedIndexedDocumentCount().incrementAndGet();
            }
        }
    }

    private boolean isReindexingChatCore() {
        Thread thread = this.chatCoreReindexThread;
        return thread != null ? thread.isAlive() : false;
    }

    /*
     * WARNING - void declaration
     */
    private List<SearchId> toSearchIds(ConsumerRecord<String, String> $this$toSearchIds) {
        Object object;
        try {
            void $this$readValue$iv;
            object = (ObjectMapper)KafkaObjectMapper.INSTANCE;
            Object object2 = $this$toSearchIds.value();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"value(...)");
            String content$iv = (String)object2;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            object = (List)$this$readValue$iv.readValue(content$iv, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Throwable e) {
            LOG.warn("Failed to parse record[key=" + $this$toSearchIds.key() + ", value=" + $this$toSearchIds.value() + "] to search id. We will skip this record.", e);
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final Unit reindexChatCore$lambda$0(SolrIndexService this$0) {
        LOG.info("Start reindexing chat core...");
        this$0.chatCoreLeaderSolrClient.deleteByQuery("*:*");
        LOG.info("All Solr documents in chat core deleted. Start to fill the index kafka topic...");
        this$0.chatCoreSearchUpdateIndexProducer.reindexChatCore();
        LOG.info("Filling chat core index kafka topic finished...");
        LOG.info("Reindexing chat core action done. All reindexing task was written to solr index kafka topic...");
        return Unit.INSTANCE;
    }

    private static final CharSequence deleteByChatIds$lambda$13$lambda$12(String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return "chat_id:" + id;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

