/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.persistence;

import de.justsoftware.chat.model.ChatType;
import de.justsoftware.chat.persistence.model.DbChat;
import de.justsoftware.chat.persistence.model.DbChatDto;
import jakarta.persistence.QueryHint;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.stereotype.Repository;

@Repository
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\"\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001J,\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH'J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH'J\u001e\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\u0006\u0010\u0013\u001a\u00020\u0014H'J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00162\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00162\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0013\u001a\u00020\u0014H'J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u00162\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u00162\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u0014H'J\u0016\u0010\u001d\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\bH'J\u0016\u0010\u001e\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00162\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0003H'J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H'J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\rH'J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\rH'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006$\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/chat/persistence/ChatRepository;", "Lorg/springframework/data/jpa/repository/JpaRepository;", "Lde/justsoftware/chat/persistence/model/DbChat;", "Ljava/util/UUID;", "findChatHavingMessagesByTenantIdAndParticipantIdIn", "Lorg/springframework/data/domain/Page;", "tenantId", "participantIds", "", "", "pageable", "Lorg/springframework/data/domain/Pageable;", "findAllChatIdsByType", "Ljava/util/stream/Stream;", "type", "Lde/justsoftware/chat/model/ChatType;", "updateSyncDateByChatIdIn", "", "chatIds", "syncDate", "Ljava/time/Instant;", "updateSyncDateByChatIds", "", "", "findChatsBySyncDateGreaterThanAndParticipantIdsIn", "findChatsBySyncDateGreaterThanAndParticipantIds", "findOneOnOneChatsByOtherUserUpdatedAtGreaterThan", "profileId", "updatedSince", "deleteLastMessageIdForChatIdsRaw", "deleteLastMessageIdForChatIds", "findChatIdsOfProfile", "updateSyncDateForMultiUserChatsWithManagerOrWriterParticipant", "streamAll", "Lde/justsoftware/chat/persistence/model/DbChatDto;", "streamAllIds", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatRepository.kt\nde/justsoftware/chat/persistence/ChatRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n1557#2:213\n1628#2,3:214\n1368#2:217\n1454#2,5:218\n1863#2,2:223\n*S KotlinDebug\n*F\n+ 1 ChatRepository.kt\nde/justsoftware/chat/persistence/ChatRepository\n*L\n75#1:213\n75#1:214,3\n107#1:217\n107#1:218,5\n146#1:223,2\n*E\n"})
public interface ChatRepository
extends JpaRepository<DbChat, UUID> {
    @Query(value="SELECT c  FROM DbChat c WHERE c.tenantId = :tenantId AND (c.type = 'MULTI_USER_CHAT' OR c.lastMessageId IS NOT NULL) AND EXISTS (    SELECT 1     FROM DbChatParticipant cp    WHERE cp.chatId = c.id    AND cp.participantId IN :participantIds)")
    @NotNull
    public Page<DbChat> findChatHavingMessagesByTenantIdAndParticipantIdIn(@NotNull UUID var1, @NotNull Iterable<String> var2, @NotNull Pageable var3);

    @Query(value="\n        SELECT c.id\n        FROM DbChat c\n        WHERE c.type = :type\n        ")
    @QueryHints(value={@QueryHint(value="1000", name="org.hibernate.fetchSize"), @QueryHint(value="false", name="org.hibernate.cacheable"), @QueryHint(value="true", name="org.hibernate.readOnly")})
    @NotNull
    public Stream<UUID> findAllChatIdsByType(@NotNull ChatType var1);

    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="updateSyncDateByChatIds(chatIds, syncDate)", imports={}))
    @Query(value="UPDATE DbChat c SET c.syncDate = :syncDate WHERE c.id IN :chatIds")
    @Modifying
    public void updateSyncDateByChatIdIn(@NotNull Iterable<UUID> var1, @NotNull Instant var2);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public List<Unit> updateSyncDateByChatIds(@NotNull Set<UUID> chatIds, @NotNull Instant syncDate) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        Intrinsics.checkNotNullParameter((Object)syncDate, (String)"syncDate");
        Iterable $this$map$iv = CollectionsKt.chunked((Iterable)chatIds, (int)1000);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void chatIdsChunk;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.updateSyncDateByChatIdIn((Iterable)chatIdsChunk, syncDate);
            collection.add(Unit.INSTANCE);
        }
        return (List)destination$iv$iv;
    }

    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="findChatsBySyncDateGreaterThanAndParticipantIds(participantIds, syncDate)", imports={}))
    @Query(value="\n        SELECT c.id\n        FROM DbChat c\n        WHERE c.syncDate > :syncDate\n        AND (c.type = 'MULTI_USER_CHAT' OR c.lastMessageId IS NOT NULL)\n        AND EXISTS (\n            SELECT 1\n            FROM DbChatParticipant cp\n            WHERE cp.chatId = c.id\n            AND cp.participantId IN :participantIds\n        )\n        ")
    @NotNull
    public List<UUID> findChatsBySyncDateGreaterThanAndParticipantIdsIn(@NotNull Iterable<String> var1, @NotNull Instant var2);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public List<UUID> findChatsBySyncDateGreaterThanAndParticipantIds(@NotNull Iterable<String> participantIds, @NotNull Instant syncDate) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)syncDate, (String)"syncDate");
        Iterable $this$flatMap$iv = CollectionsKt.chunked(participantIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.findChatsBySyncDateGreaterThanAndParticipantIdsIn((Iterable)it, syncDate);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Query(value="\n        SELECT c.id\n        FROM DbChat c\n        JOIN DbChatParticipant cp1 ON c.id = cp1.chatId\n        JOIN DbChatParticipant cp2 ON c.id = cp2.chatId\n        JOIN DbProfile p ON cp2.participantId = p.id\n        WHERE cp1.participantId = :profileId\n        AND cp2.participantId <> :profileId\n        AND c.type = 'ONE_ON_ONE'\n        AND c.lastMessageId IS NOT NULL\n        AND p.updatedAt > :updatedSince\n        ")
    @NotNull
    public List<UUID> findOneOnOneChatsByOtherUserUpdatedAtGreaterThan(@NotNull String var1, @NotNull Instant var2);

    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="deleteLastMessageIdForChatIds(chatIds)", imports={}))
    @Query(value="\n        UPDATE DbChat c\n        SET c.lastMessageId = NULL\n        WHERE c.id IN :chatIds\n        ")
    @Modifying
    public void deleteLastMessageIdForChatIdsRaw(@NotNull Iterable<UUID> var1);

    default public void deleteLastMessageIdForChatIds(@NotNull Iterable<UUID> chatIds) {
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        Iterable $this$forEach$iv = CollectionsKt.chunked(chatIds, (int)1000);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Iterable p0 = (Iterable)element$iv;
            boolean $i$f$deleteLastMessageIdForChatIds$stub_for_inlining = false;
            boolean bl = false;
            this.deleteLastMessageIdForChatIdsRaw(p0);
        }
    }

    @Query(value="\n        SELECT cp.chatId\n        FROM DbChatParticipant cp\n        LEFT JOIN DbUserGroupMember ugm ON cp.participantId = ugm.groupId\n        LEFT JOIN DbChat c ON cp.chatId = c.id\n        WHERE (cp.participantId = :profileId OR ugm.profileId = :profileId)\n        AND c.tenantId = :tenantId\n        ")
    @NotNull
    public List<UUID> findChatIdsOfProfile(@NotNull String var1, @NotNull UUID var2);

    @Query(value="\n        UPDATE DbChat c\n        SET c.syncDate = :syncDate\n        WHERE c.type = 'MULTI_USER_CHAT'\n        AND c.id IN (\n            SELECT cp.chatId\n            FROM DbChatParticipant cp\n            WHERE cp.participantId = :profileId\n            AND cp.permissionType IN ('MANAGER', 'WRITER')\n        )\n        ")
    @Modifying
    public void updateSyncDateForMultiUserChatsWithManagerOrWriterParticipant(@NotNull String var1, @NotNull Instant var2);

    @Query(value="\n        SELECT new de.justsoftware.chat.persistence.model.DbChatDto(\n            c.id,\n            c.title,\n            c.type,\n            c.tenantId,\n            c.lastMessageId,\n            c.sortDate,\n            c.syncDate,\n            c.createdAt,\n            c.updatedAt\n        ) FROM DbChat c\n        ")
    @QueryHints(value={@QueryHint(value="1000", name="org.hibernate.fetchSize"), @QueryHint(value="false", name="org.hibernate.cacheable"), @QueryHint(value="true", name="org.hibernate.readOnly")})
    @NotNull
    public Stream<DbChatDto> streamAll();

    @Query(value="SELECT c.id FROM DbChat c")
    @QueryHints(value={@QueryHint(value="1000", name="org.hibernate.fetchSize"), @QueryHint(value="false", name="org.hibernate.cacheable"), @QueryHint(value="true", name="org.hibernate.readOnly")})
    @NotNull
    public Stream<UUID> streamAllIds();
}

