/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.config;

import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.authorization.AuthorizationService;
import de.justsoftware.chat.config.ApplicationConfiguration;
import de.justsoftware.chat.config.AuthorizationContextResolver;
import de.justsoftware.chat.exception.UnauthorizedException;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.LocaleResolver;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J,\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u001c\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/justsoftware/chat/config/AuthorizationContextResolver;", "Lorg/springframework/web/method/support/HandlerMethodArgumentResolver;", "authorizationService", "Lde/justsoftware/chat/authorization/AuthorizationService;", "localeResolver", "Lorg/springframework/web/servlet/LocaleResolver;", "<init>", "(Lde/justsoftware/chat/authorization/AuthorizationService;Lorg/springframework/web/servlet/LocaleResolver;)V", "supportsParameter", "", "parameter", "Lorg/springframework/core/MethodParameter;", "resolveArgument", "Lde/justsoftware/chat/authorization/AuthorizationContext;", "mavContainer", "Lorg/springframework/web/method/support/ModelAndViewContainer;", "webRequest", "Lorg/springframework/web/context/request/NativeWebRequest;", "binderFactory", "Lorg/springframework/web/bind/support/WebDataBinderFactory;", "profileId", "Lde/justsoftware/chat/model/ProfileId;", "authentication", "Lde/justsoftware/jwtfilter/JwtAuthenticationToken;", "currentPersonInfo", "", "", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "locale", "Ljava/util/Locale;", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nAuthorizationContextResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizationContextResolver.kt\nde/justsoftware/chat/config/AuthorizationContextResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,125:1\n1#2:126\n9#3:127\n8#3,3:128\n*S KotlinDebug\n*F\n+ 1 AuthorizationContextResolver.kt\nde/justsoftware/chat/config/AuthorizationContextResolver\n*L\n122#1:127\n122#1:128,3\n*E\n"})
public final class AuthorizationContextResolver
implements HandlerMethodArgumentResolver {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private final LocaleResolver localeResolver;
    @NotNull
    private static final Logger LOG;

    public AuthorizationContextResolver(@NotNull AuthorizationService authorizationService, @NotNull LocaleResolver localeResolver) {
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        Intrinsics.checkNotNullParameter((Object)localeResolver, (String)"localeResolver");
        this.authorizationService = authorizationService;
        this.localeResolver = localeResolver;
    }

    public boolean supportsParameter(@NotNull MethodParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return Intrinsics.areEqual(AuthorizationContext.class, (Object)parameter.getParameterType());
    }

    @NotNull
    public AuthorizationContext resolveArgument(@NotNull MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, @NotNull NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws UnauthorizedException {
        Object object;
        Authentication authentication;
        block5: {
            block3: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                    Intrinsics.checkNotNullParameter((Object)webRequest, (String)"webRequest");
                    Authentication authentication2 = SecurityContextHolder.getContext().getAuthentication();
                    if (authentication2 == null) {
                        throw new UnauthorizedException("You must be logged in to perform this request");
                    }
                    authentication = authentication2;
                    if (!(authentication instanceof JwtAuthenticationToken)) break block3;
                    HttpServletRequest httpServletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
                    object = httpServletRequest;
                    if (object == null) break block4;
                    HttpServletRequest httpServletRequest2 = object;
                    LocaleResolver localeResolver = this.localeResolver;
                    HttpServletRequest p0 = httpServletRequest2;
                    boolean $i$f$resolveArgument$stub_for_inlining = false;
                    boolean bl = false;
                    Locale locale = localeResolver.resolveLocale(p0);
                    object = locale;
                    if (locale != null) break block5;
                }
                object = ApplicationConfiguration.Companion.getDEFAULT_LOCALE();
                break block5;
            }
            LOG.warn("We received an unknown type of authentication: " + authentication.getClass().getName());
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        Object locale = object;
        return new AuthorizationContext(this.profileId((JwtAuthenticationToken)authentication), this.tenantId((JwtAuthenticationToken)authentication), (Locale)locale, this.authorizationService);
    }

    private final ProfileId profileId(JwtAuthenticationToken authentication) {
        ProfileId profileId;
        String principal = authentication.getPrincipal().toString();
        try {
            profileId = ProfileId.Companion.fromCanonicalId(principal);
        }
        catch (IllegalStateException ex) {
            LOG.warn("We received an unparsable profile ID: '" + principal + "'");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return profileId;
    }

    private final ProfileId profileId(Map<String, String> currentPersonInfo) {
        ProfileId profileId;
        String profileIdString = currentPersonInfo.get("id");
        if (profileIdString == null) {
            LOG.warn("Failed to extract profile id from internal toro API response");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        try {
            profileId = ProfileId.Companion.fromCanonicalId(profileIdString);
        }
        catch (IllegalStateException ex) {
            LOG.warn("Received an unparsable profile ID from toro: '" + profileIdString + "'");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return profileId;
    }

    private final TenantId tenantId(JwtAuthenticationToken authentication) {
        TenantId tenantId;
        Object object = authentication.getCustomJwtClaims().get((Object)"tenantId");
        if (object == null) {
            throw new UnauthorizedException("You must be logged in a valid tenant");
        }
        Object tenantId2 = object;
        try {
            tenantId = TenantId.Companion.fromCanonicalId(tenantId2.toString());
        }
        catch (IllegalStateException ex) {
            LOG.warn("We received an unparsable tenant ID: '" + tenantId2 + "'");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return tenantId;
    }

    private final TenantId tenantId(Map<String, String> currentPersonInfo) {
        TenantId tenantId;
        String tenantIdString = currentPersonInfo.get("tenantId");
        if (tenantIdString == null) {
            LOG.warn("Failed to extract tenant id from internal toro API response");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        try {
            tenantId = TenantId.Companion.fromCanonicalId(tenantIdString);
        }
        catch (IllegalStateException ex) {
            LOG.warn("Received an unparsable tenant ID from toro: '" + tenantIdString + "'");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return tenantId;
    }

    private final Locale locale(Map<String, String> currentPersonInfo) {
        Locale locale;
        String string = currentPersonInfo.get("language");
        if (string != null) {
            String p0 = string;
            boolean $i$f$locale$stub_for_inlining$0 = false;
            boolean bl = false;
            locale = new Locale(p0);
        } else {
            locale = ApplicationConfiguration.Companion.getDEFAULT_LOCALE();
        }
        return locale;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

