/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.application;

import de.justsoftware.chat.application.SearchApplicationService;
import de.justsoftware.chat.application.model.AllowedActions;
import de.justsoftware.chat.application.model.ChatSearchResultDto;
import de.justsoftware.chat.application.model.ChatSettingsDto;
import de.justsoftware.chat.application.model.MessageSearchResultDto;
import de.justsoftware.chat.application.model.MultiUserChatDto;
import de.justsoftware.chat.application.model.ProfileDto;
import de.justsoftware.chat.application.model.ProfileSearchResultDto;
import de.justsoftware.chat.application.model.SearchResultDto;
import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.business.ChatCoreSearchService;
import de.justsoftware.chat.business.ChatLocalizationService;
import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.SearchService;
import de.justsoftware.chat.business.model.Chat;
import de.justsoftware.chat.business.model.ChatSettings;
import de.justsoftware.chat.business.model.MultiUserChat;
import de.justsoftware.chat.business.model.OneOnOneChat;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.model.ChatCoreSearchResult;
import de.justsoftware.chat.model.ChatCoreSearchSortType;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatType;
import de.justsoftware.chat.model.DriveDocumentId;
import de.justsoftware.chat.model.Offset;
import de.justsoftware.chat.model.PageOffset;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.SearchResult;
import de.justsoftware.chat.model.SearchSortType;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.search.shared.model.SearchType;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 )2\u00020\u0001:\u0001)B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJN\u0010\u0010\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u00010\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J0\u0010\u001e\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u00010\u00120\u001f*\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0012J@\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0015\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010'\u001a\b\u0012\u0004\u0012\u00020#0\u001f*\b\u0012\u0004\u0012\u00020(0 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lde/justsoftware/chat/application/SearchApplicationService;", "", "searchService", "Lde/justsoftware/chat/business/SearchService;", "chatCoreSearchService", "Lde/justsoftware/chat/business/ChatCoreSearchService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "chatService", "Lde/justsoftware/chat/business/ChatService;", "chatLocalizationService", "Lde/justsoftware/chat/business/ChatLocalizationService;", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "<init>", "(Lde/justsoftware/chat/business/SearchService;Lde/justsoftware/chat/business/ChatCoreSearchService;Lde/justsoftware/chat/business/ProfileService;Lde/justsoftware/chat/business/ChatService;Lde/justsoftware/chat/business/ChatLocalizationService;Lde/justsoftware/chat/business/ChatParticipantService;)V", "suggestChat", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/chat/application/model/SearchResultDto;", "query", "", "sortType", "Lde/justsoftware/chat/model/SearchSortType;", "page", "", "pageSize", "authContext", "Lde/justsoftware/chat/authorization/AuthorizationContext;", "onlyPersonResults", "", "toCommonCoreSearchResultDtos", "", "", "Lde/justsoftware/chat/model/SearchResult;", "searchMessages", "Lde/justsoftware/chat/application/model/MessageSearchResultDto;", "chatId", "Lde/justsoftware/chat/model/ChatId;", "Lde/justsoftware/chat/model/ChatCoreSearchSortType;", "toChatCoreSearchResultDtos", "Lde/justsoftware/chat/model/ChatCoreSearchResult;", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nSearchApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchApplicationService.kt\nde/justsoftware/chat/application/SearchApplicationService\n+ 2 PagingUtils.kt\nde/justsoftware/chat/util/PagingUtilsKt\n+ 3 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 8 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,180:1\n11#2:181\n11#2:234\n10#3:182\n10#3:188\n10#3:235\n7#3:241\n22#3:245\n7#3:248\n1619#4:183\n1863#4:184\n1864#4:186\n1620#4:187\n1619#4:189\n1863#4:190\n1864#4:192\n1620#4:193\n1246#4,4:196\n808#4,11:204\n1202#4,2:215\n1230#4,4:217\n1611#4,9:221\n1863#4:230\n1864#4:232\n1620#4:233\n1619#4:236\n1863#4:237\n1864#4:239\n1620#4:240\n1628#4,3:242\n817#4,2:246\n1628#4,3:249\n1611#4,9:252\n1863#4:261\n1864#4:263\n1620#4:264\n1#5:185\n1#5:191\n1#5:231\n1#5:238\n1#5:262\n462#6:194\n412#6:195\n126#7:200\n153#7,3:201\n9#8:265\n8#8,3:266\n*S KotlinDebug\n*F\n+ 1 SearchApplicationService.kt\nde/justsoftware/chat/application/SearchApplicationService\n*L\n72#1:181\n151#1:234\n77#1:182\n78#1:188\n154#1:235\n155#1:241\n156#1:245\n158#1:248\n77#1:183\n77#1:184\n77#1:186\n77#1:187\n78#1:189\n78#1:190\n78#1:192\n78#1:193\n82#1:196,4\n85#1:204,11\n85#1:215,2\n85#1:217,4\n89#1:221,9\n89#1:230\n89#1:232\n89#1:233\n154#1:236\n154#1:237\n154#1:239\n154#1:240\n155#1:242,3\n156#1:246,2\n158#1:249,3\n161#1:252,9\n161#1:261\n161#1:263\n161#1:264\n77#1:185\n78#1:191\n89#1:231\n154#1:238\n161#1:262\n82#1:194\n82#1:195\n85#1:200\n85#1:201,3\n177#1:265\n177#1:266,3\n*E\n"})
public class SearchApplicationService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SearchService searchService;
    @NotNull
    private final ChatCoreSearchService chatCoreSearchService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final ChatLocalizationService chatLocalizationService;
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    private static final Logger LOG;

    public SearchApplicationService(@NotNull SearchService searchService, @NotNull ChatCoreSearchService chatCoreSearchService, @NotNull ProfileService profileService, @NotNull ChatService chatService, @NotNull ChatLocalizationService chatLocalizationService, @NotNull ChatParticipantService chatParticipantService) {
        Intrinsics.checkNotNullParameter((Object)searchService, (String)"searchService");
        Intrinsics.checkNotNullParameter((Object)chatCoreSearchService, (String)"chatCoreSearchService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)chatLocalizationService, (String)"chatLocalizationService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        this.searchService = searchService;
        this.chatCoreSearchService = chatCoreSearchService;
        this.profileService = profileService;
        this.chatService = chatService;
        this.chatLocalizationService = chatLocalizationService;
        this.chatParticipantService = chatParticipantService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<SearchResultDto<? extends Object, ? extends Object>> suggestChat(@NotNull String query, @NotNull SearchSortType sortType, int page, int pageSize, @NotNull AuthorizationContext authContext, boolean onlyPersonResults) {
        void $this$mapContent$iv;
        SearchType[] searchTypeArray;
        Set set;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)sortType, (String)"sortType");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (onlyPersonResults) {
            set = SetsKt.setOf((Object)SearchType.PROFILE);
        } else {
            searchTypeArray = new SearchType[]{SearchType.CHAT, SearchType.PROFILE};
            set = SetsKt.setOf((Object[])searchTypeArray);
        }
        searchTypeArray = this.searchService.suggestChat(query, set, sortType, authContext.getProfileId(), authContext.getTenantId(), (Offset)new PageOffset(page, pageSize));
        boolean $i$f$mapContent = false;
        Iterable it = (Iterable)$this$mapContent$iv;
        boolean bl = false;
        long l = $this$mapContent$iv.getTotalElements();
        Pageable pageable = $this$mapContent$iv.getPageable();
        List list = this.toCommonCoreSearchResultDtos(it, authContext);
        return (Page)new PageImpl(list, pageable, l);
    }

    /*
     * WARNING - void declaration
     */
    private List<SearchResultDto<? extends Object, ? extends Object>> toCommonCoreSearchResultDtos(Iterable<SearchResult> $this$toCommonCoreSearchResultDtos, AuthorizationContext authContext) {
        void $this$mapNotNullTo$iv$iv;
        Iterable<SearchResult> $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        void $this$mapTo$iv$iv;
        Object object;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object element$iv$iv$iv32;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNullTo$iv$iv3;
        Iterable<SearchResult> $this$mapNotNullToSet$iv = $this$toCommonCoreSearchResultDtos;
        boolean $i$f$mapNotNullToSet = false;
        Iterable<SearchResult> iterable = $this$mapNotNullToSet$iv;
        Iterable<Object> destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize($this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv3;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
            ProfileId it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv2;
            boolean bl = false;
            SearchResult searchResult = (SearchResult)element$iv$iv;
            boolean $i$f$toCommonCoreSearchResultDtos$stub_for_inlining = false;
            boolean bl2 = false;
            if (searchResult.getProfileId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set profileIds = (Set)destination$iv$iv;
        Iterable<SearchResult> $this$mapNotNullToSet$iv2 = $this$toCommonCoreSearchResultDtos;
        boolean $i$f$mapNotNullToSet232 = false;
        destination$iv$iv = $this$mapNotNullToSet$iv2;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize($this$mapNotNullToSet$iv2));
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv$iv$iv32 : $this$forEach$iv$iv$iv2) {
            ChatId it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv32;
            boolean bl = false;
            SearchResult p0 = (SearchResult)element$iv$iv;
            boolean $i$f$toCommonCoreSearchResultDtos$stub_for_inlining$1 = false;
            boolean bl4 = false;
            if (p0.getChatId() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Set chatIds = (Set)destination$iv$iv2;
        Map $i$f$mapNotNullToSet232 = this.profileService.findByIds(profileIds);
        boolean $i$f$mapValues = false;
        destination$iv$iv2 = $this$mapValues$iv;
        Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo232 = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv4 : $this$associateByTo$iv$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv$iv4;
            Map p0 = destination$iv$iv3;
            boolean bl6 = false;
            Map.Entry bl4 = (Map.Entry)element$iv$iv$iv4;
            Object k = entry.getKey();
            object = p0;
            boolean bl7 = false;
            Profile profile = (Profile)bl4.getValue();
            ProfileDto profileDto = ProfileDto.Companion.toProfileDto(profile);
            object.put(k, profileDto);
        }
        Map profileDtos = destination$iv$iv3;
        Map allowedActions = authContext.toMultiUserChatsAllowedActionsWithoutTemporaryPermissions(chatIds);
        Object $this$map$iv = this.chatService.findByIds(chatIds);
        boolean $i$f$map = false;
        Map $i$f$mapValuesTo232 = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        element$iv$iv$iv32 = $this$mapTo$iv$iv.entrySet().iterator();
        while (element$iv$iv$iv32.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)element$iv$iv$iv32.next();
            object = destination$iv$iv4;
            boolean bl = false;
            object.add((Chat)entry.getValue());
        }
        $this$map$iv = (List)destination$iv$iv4;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MultiUserChat)) continue;
            destination$iv$iv5.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv5;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv5 = $this$associateBy$iv;
        Map destination$iv$iv52 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo2 = false;
        for (Object t : $this$associateByTo$iv$iv) {
            void it;
            MultiUserChat bl = (MultiUserChat)t;
            object = destination$iv$iv52;
            boolean bl8 = false;
            object.put(it.getId(), t);
        }
        Map multiUserChats = destination$iv$iv52;
        Map oneOnOneChatIdByChatPartnerIds = this.chatParticipantService.getOneOnOneChatIdByChatPartnerIds(profileIds, authContext.getProfileId());
        Iterable<SearchResult> $this$mapNotNull$iv = $this$toCommonCoreSearchResultDtos;
        boolean $i$f$mapNotNull = false;
        $this$associateByTo$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv6 = new ArrayList();
        boolean $i$f$mapNotNullTo3 = false;
        void $this$forEach$iv$iv$iv3 = $this$mapNotNullTo$iv$iv;
        boolean bl = false;
        Iterator iterator = $this$forEach$iv$iv$iv3.iterator();
        while (iterator.hasNext()) {
            SearchResultDto searchResultDto;
            Object element$iv$iv$iv5;
            Object element$iv$iv = element$iv$iv$iv5 = iterator.next();
            boolean bl2 = false;
            SearchResult searchResult = (SearchResult)element$iv$iv;
            boolean bl9 = false;
            switch (WhenMappings.$EnumSwitchMapping$0[searchResult.getType().ordinal()]) {
                case 1: {
                    ProfileId profileId = ProfileId.Companion.fromCanonicalId(searchResult.getId());
                    ProfileSearchResultDto.Companion companion = ProfileSearchResultDto.Companion;
                    SearchResult searchResult2 = searchResult;
                    Object v = profileDtos.get(profileId);
                    if (v == null) {
                        SearchResult searchResult3 = searchResult2;
                        ProfileSearchResultDto.Companion companion2 = companion;
                        boolean bl10 = false;
                        String string = "Could not load Profile with id " + profileId;
                        ProfileSearchResultDto.Companion companion3 = companion2;
                        SearchResult searchResult4 = searchResult3;
                        String string2 = string;
                        throw new IllegalStateException(string2.toString());
                    }
                    searchResultDto = (SearchResultDto)companion.toProfileSearchResultDto(searchResult2, (ProfileDto)v, (ChatId)oneOnOneChatIdByChatPartnerIds.get(profileId));
                    break;
                }
                case 2: {
                    Instant instant;
                    String string;
                    ChatId chatId = ChatId.Companion.fromCanonicalId(searchResult.getId());
                    String string2 = searchResult.getChatType();
                    if (string2 == null) {
                        boolean $i$a$-checkNotNull-SearchApplicationService$toCommonCoreSearchResultDtos$1$chatType$232 = false;
                        String $i$a$-checkNotNull-SearchApplicationService$toCommonCoreSearchResultDtos$1$chatType$232 = "ChatType is null for a chat searchResult";
                        throw new IllegalStateException($i$a$-checkNotNull-SearchApplicationService$toCommonCoreSearchResultDtos$1$chatType$232.toString());
                    }
                    ChatType chatType = ChatType.valueOf((String)string2);
                    if (!(chatType == ChatType.MULTI_USER_CHAT)) {
                        boolean bl11 = false;
                        String string4 = "OneOnOne Chats should be filtered by search queries, since oneOnOne chats should be handled as a person (chat partner)";
                        throw new IllegalStateException(string4.toString());
                    }
                    String string5 = searchResult.getName();
                    Object v = allowedActions.get(chatId);
                    if (v == null) {
                        string = "Required value was null.";
                        throw new IllegalStateException(string.toString());
                    }
                    AllowedActions allowedActions2 = (AllowedActions)v;
                    Intrinsics.checkNotNullExpressionValue((Object)searchResult.getModifyDate().toInstant(), (String)"toInstant(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)searchResult.getModifyDate().toInstant(), (String)"toInstant(...)");
                    MultiUserChat multiUserChat = (MultiUserChat)multiUserChats.get(chatId);
                    DriveDocumentId driveDocumentId = multiUserChat != null ? multiUserChat.getIconId() : null;
                    ChatSettingsDto chatSettingsDto = ChatSettingsDto.Companion.toChatSettingsDto(new ChatSettings(chatId, authContext.getProfileId(), false, null, 12, null));
                    searchResultDto = (SearchResultDto)ChatSearchResultDto.Companion.toChatSearchResultDto(searchResult, new MultiUserChatDto(chatId, string5, allowedActions2, null, 0L, false, false, driveDocumentId, instant, (Instant)((Object)string), chatSettingsDto));
                    break;
                }
                default: {
                    LOG.warn("Unsupported Search Type {} returned. Will be ignored.", (Object)searchResult.getType());
                    searchResultDto = null;
                }
            }
            if (searchResultDto == null) continue;
            SearchResultDto it$iv$iv = searchResultDto;
            boolean bl12 = false;
            destination$iv$iv6.add(it$iv$iv);
        }
        return (List)destination$iv$iv6;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<MessageSearchResultDto> searchMessages(@NotNull String query, @Nullable ChatId chatId, @NotNull ChatCoreSearchSortType sortType, int page, int pageSize, @NotNull AuthorizationContext authContext) {
        void $this$mapContent$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)sortType, (String)"sortType");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ChatCoreSearchService chatCoreSearchService = this.chatCoreSearchService;
        ProfileId profileId = authContext.getProfileId();
        PageOffset pageOffset = new PageOffset(page, pageSize);
        chatCoreSearchService = chatCoreSearchService.searchMessages(query, chatId, profileId, (Offset)pageOffset, sortType);
        boolean $i$f$mapContent = false;
        Iterable it = (Iterable)$this$mapContent$iv;
        boolean bl = false;
        long l = $this$mapContent$iv.getTotalElements();
        Pageable pageable = $this$mapContent$iv.getPageable();
        List list = this.toChatCoreSearchResultDtos(it, authContext);
        return (Page)new PageImpl(list, pageable, l);
    }

    /*
     * WARNING - void declaration
     */
    private List<MessageSearchResultDto> toChatCoreSearchResultDtos(Iterable<ChatCoreSearchResult> $this$toChatCoreSearchResultDtos, AuthorizationContext authContext) {
        void $this$mapNotNullTo$iv$iv;
        Iterable<ChatCoreSearchResult> $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$mapToSet$iv2;
        boolean bl;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNullToSet$iv;
        Iterable<ChatCoreSearchResult> iterable = $this$toChatCoreSearchResultDtos;
        ProfileService profileService = this.profileService;
        boolean $i$f$mapNotNullToSet232 = false;
        void var6_7 = $this$mapNotNullToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ProfileId it$iv$iv;
            Object t = element$iv$iv$iv = iterator.next();
            bl = false;
            ChatCoreSearchResult p0 = (ChatCoreSearchResult)t;
            boolean $i$f$toChatCoreSearchResultDtos$stub_for_inlining$10 = false;
            boolean bl2 = false;
            if (p0.getAuthorId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map authors = profileService.findByIds((Set)destination$iv$iv);
        Iterable<ChatCoreSearchResult> $i$f$mapNotNullToSet232 = $this$toChatCoreSearchResultDtos;
        profileService = this.chatService;
        boolean $i$f$mapToSet = false;
        destination$iv$iv = $this$mapToSet$iv2;
        Iterable destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            element$iv$iv$iv = (ChatCoreSearchResult)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            bl = false;
            collection.add(p0.getChatId());
        }
        Map chats2 = profileService.findByIds((Set)destination$iv$iv2);
        Iterable $this$filterIsInstanceToSet$iv = chats2.values();
        boolean $i$f$filterIsInstanceToSet232 = false;
        destination$iv$iv2 = $this$filterIsInstanceToSet$iv;
        Collection destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv));
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof OneOnOneChat)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        Set oneOnOneChats = (Set)destination$iv$iv3;
        Iterable $i$f$filterIsInstanceToSet232 = oneOnOneChats;
        profileService = this.chatParticipantService;
        boolean $i$f$mapToSet2 = false;
        destination$iv$iv3 = $this$mapToSet$iv;
        Collection destination$iv$iv4 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo2 = false;
        for (Object e : $this$mapTo$iv$iv) {
            void p0;
            Chat bl3 = (Chat)e;
            collection = destination$iv$iv4;
            boolean $i$f$toChatCoreSearchResultDtos$stub_for_inlining$12 = false;
            boolean bl4 = false;
            collection.add(p0.getId());
        }
        Map oneOnOneChatPartnerByChatId = profileService.getDirectChatPartnersForProfile((Set)destination$iv$iv4, authContext.getProfileId());
        Iterable<ChatCoreSearchResult> $this$mapNotNull$iv = $this$toChatCoreSearchResultDtos;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean bl4 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            MessageSearchResultDto messageSearchResultDto;
            Object element$iv$iv$iv2;
            Object element$iv$iv = element$iv$iv$iv2 = iterator2.next();
            boolean bl5 = false;
            ChatCoreSearchResult searchResult = (ChatCoreSearchResult)element$iv$iv;
            boolean bl52 = false;
            if ((Chat)chats2.get(searchResult.getChatId()) == null) {
                messageSearchResultDto = null;
            } else if ((Profile)authors.get(searchResult.getAuthorId()) == null) {
                messageSearchResultDto = null;
            } else {
                Profile author;
                String string;
                Chat chat;
                Chat chat2 = chat;
                if (chat2 instanceof OneOnOneChat) {
                    string = this.chatLocalizationService.localizeOneOnOneChatTitleWithPrefix((Profile)oneOnOneChatPartnerByChatId.get(((OneOnOneChat)chat).getId()), authContext);
                } else if (chat2 instanceof MultiUserChat) {
                    string = ((MultiUserChat)chat).getTitle();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                String chatTitle = string;
                messageSearchResultDto = MessageSearchResultDto.Companion.toMessageSearchResultDto(searchResult, chatTitle, ProfileDto.Companion.toProfileDto(author));
            }
            if (messageSearchResultDto == null) continue;
            MessageSearchResultDto it$iv$iv = messageSearchResultDto;
            boolean bl6 = false;
            destination$iv$iv5.add(it$iv$iv);
        }
        return (List)destination$iv$iv5;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

