/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.totp;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.authorization.oauth2.JustUserDetailService;
import de.justsoftware.authorization.token.RememberMeTokenRepository;
import de.justsoftware.authorization.totp.TOTPAuthentication;
import de.justsoftware.authorization.totp.TOTPAwareRememberMeService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.rememberme.CookieTheftException;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;
import org.springframework.security.web.authentication.rememberme.PersistentTokenBasedRememberMeServices;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J/\u0010\u0017\u001a\u0004\u0018\u00010\f2\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u001d\u001a\u00020\u0010H\u0007R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lde/justsoftware/authorization/totp/TOTPAwareRememberMeService;", "Lorg/springframework/security/web/authentication/rememberme/PersistentTokenBasedRememberMeServices;", "key", "", "userDetailService", "Lde/justsoftware/authorization/oauth2/JustUserDetailService;", "rememberMeTokenRepository", "Lde/justsoftware/authorization/token/RememberMeTokenRepository;", "<init>", "(Ljava/lang/String;Lde/justsoftware/authorization/oauth2/JustUserDetailService;Lde/justsoftware/authorization/token/RememberMeTokenRepository;)V", "cookieCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lorg/springframework/security/core/userdetails/UserDetails;", "getCookieCache", "()Lcom/github/benmanes/caffeine/cache/Cache;", "loginSuccess", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "successfulAuthentication", "Lorg/springframework/security/core/Authentication;", "processAutoLoginCookie", "cookieTokens", "", "([Ljava/lang/String;Ljakarta/servlet/http/HttpServletRequest;Ljakarta/servlet/http/HttpServletResponse;)Lorg/springframework/security/core/userdetails/UserDetails;", "rememberMeRequested", "", "invalidateCache", "Companion", "just-authorization-server"})
public final class TOTPAwareRememberMeService
extends PersistentTokenBasedRememberMeServices {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cache<String, UserDetails> cookieCache;
    @NotNull
    private static final Logger LOG;

    public TOTPAwareRememberMeService(@NotNull String key, @NotNull JustUserDetailService userDetailService, @NotNull RememberMeTokenRepository rememberMeTokenRepository) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)userDetailService, (String)"userDetailService");
        Intrinsics.checkNotNullParameter((Object)rememberMeTokenRepository, (String)"rememberMeTokenRepository");
        super(key, (UserDetailsService)userDetailService, (PersistentTokenRepository)rememberMeTokenRepository);
        Cache cache = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(10L)).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cookieCache = cache;
    }

    @NotNull
    public final Cache<String, UserDetails> getCookieCache() {
        return this.cookieCache;
    }

    public void loginSuccess(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Authentication successfulAuthentication) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)successfulAuthentication, (String)"successfulAuthentication");
        if (successfulAuthentication instanceof TOTPAuthentication) {
            if (((TOTPAuthentication)successfulAuthentication).getRemember() && ((TOTPAuthentication)successfulAuthentication).getAuthenticated()) {
                super.onLoginSuccess(request, response, successfulAuthentication);
            }
        } else {
            super.loginSuccess(request, response, successfulAuthentication);
        }
    }

    @Nullable
    protected synchronized UserDetails processAutoLoginCookie(@NotNull String[] cookieTokens, @NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)cookieTokens, (String)"cookieTokens");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String cacheKey = cookieTokens[0] + cookieTokens[1];
        UserDetails cached = (UserDetails)this.cookieCache.getIfPresent((Object)cacheKey);
        if (cached != null) {
            return cached;
        }
        try {
            UserDetails fresh = super.processAutoLoginCookie(cookieTokens, request, response);
            if (fresh != null) {
                this.cookieCache.put((Object)cacheKey, (Object)fresh);
            }
            return fresh;
        }
        catch (CookieTheftException cookieTheftException) {
            LOG.error("caught CookieTheftException - throwing invalid cookie exception to redirect to login page");
            throw new InvalidCookieException("caught CookieTheftException");
        }
    }

    public final boolean rememberMeRequested(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return super.rememberMeRequested(request, this.getParameter());
    }

    @VisibleForTesting
    public final void invalidateCache() {
        this.cookieCache.invalidateAll();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Logger logger = LoggerFactory.getLogger(TOTPAwareRememberMeService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

