/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.totp;

import com.atlassian.onetime.core.TOTP;
import com.atlassian.onetime.model.EmailAddress;
import com.atlassian.onetime.model.Issuer;
import com.atlassian.onetime.model.TOTPSecret;
import com.atlassian.onetime.service.DefaultTOTPService;
import com.atlassian.onetime.service.RandomSecretProvider;
import com.atlassian.onetime.service.TOTPVerificationResult;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import de.justsoftware.authorization.config.JustAuthorizationContext;
import de.justsoftware.authorization.connector.PermissionConnector;
import de.justsoftware.authorization.controller.TOTPDeviceDto;
import de.justsoftware.authorization.controller.TOTPSecretDto;
import de.justsoftware.authorization.controller.UnauthorizedException;
import de.justsoftware.authorization.id.ItemId;
import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.oauth2.JustUserDetailService;
import de.justsoftware.authorization.settings.SettingsService;
import de.justsoftware.authorization.settings.TenantSettings;
import de.justsoftware.authorization.totp.TOTPAuthentication;
import de.justsoftware.authorization.totp.TOTPAuthenticationException;
import de.justsoftware.authorization.totp.TOTPAuthenticationService;
import de.justsoftware.authorization.totp.TOTPCheckResult;
import de.justsoftware.authorization.totp.TOTPDevice;
import de.justsoftware.authorization.totp.TOTPDeviceRepository;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 02\u00020\u0001:\u00010B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u0012\b\b\u0001\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u000b2\b\b\u0002\u0010\u001b\u001a\u00020\u0014H\u0016J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u0014H\u0012J\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010\u001f\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010\u001f\u001a\u00020&2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0015\u001a\u00020\u000bH\u0012J\u0018\u0010-\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,2\u0006\u0010 \u001a\u00020\u000bH\u0016J\u0010\u0010.\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010/\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00061"}, d2={"Lde/justsoftware/authorization/totp/TOTPAuthenticationService;", "", "userService", "Lde/justsoftware/authorization/oauth2/JustUserDetailService;", "settingsService", "Lde/justsoftware/authorization/settings/SettingsService;", "totpDeviceRepository", "Lde/justsoftware/authorization/totp/TOTPDeviceRepository;", "permissionConnector", "Lde/justsoftware/authorization/connector/PermissionConnector;", "mfaEncryptionPassword", "", "systemDomainPrefix", "<init>", "(Lde/justsoftware/authorization/oauth2/JustUserDetailService;Lde/justsoftware/authorization/settings/SettingsService;Lde/justsoftware/authorization/totp/TOTPDeviceRepository;Lde/justsoftware/authorization/connector/PermissionConnector;Ljava/lang/String;Ljava/lang/String;)V", "textEncryptor", "Lorg/springframework/security/crypto/encrypt/TextEncryptor;", "getTextEncryptor", "()Lorg/springframework/security/crypto/encrypt/TextEncryptor;", "userHasConfirmedTOTPDevice", "", "username", "profileId", "Lde/justsoftware/authorization/id/ProfileId;", "createNewDevice", "Lde/justsoftware/authorization/controller/TOTPSecretDto;", "getOrCreateNewDevice", "generateNewSecret", "getOrCreateNewDeviceIntern", "user", "Lde/justsoftware/authorization/oauth2/JustUser;", "checkTOTPCodeAndConfirmDevice", "code", "authContext", "Lde/justsoftware/authorization/config/JustAuthorizationContext;", "", "totpAuthentication", "Lde/justsoftware/authorization/totp/TOTPAuthentication;", "Lde/justsoftware/authorization/totp/TOTPCheckResult;", "findConfirmedTOTPDevice", "", "Lde/justsoftware/authorization/controller/TOTPDeviceDto;", "generateQRCode", "device", "Lde/justsoftware/authorization/totp/TOTPDevice;", "verifyCode", "isMFARequired", "deleteTOTPDevice", "Companion", "just-authorization-server"})
public class TOTPAuthenticationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JustUserDetailService userService;
    @NotNull
    private final SettingsService settingsService;
    @NotNull
    private final TOTPDeviceRepository totpDeviceRepository;
    @NotNull
    private final PermissionConnector permissionConnector;
    @NotNull
    private final String systemDomainPrefix;
    @NotNull
    private final TextEncryptor textEncryptor;
    private static final Logger LOG = LoggerFactory.getLogger(TOTPAuthenticationService.class);
    @NotNull
    private static final String TEXT_ENCRYPTOR_SALT = "5ab5ea80dcb641d373626bc8671e5006";

    public TOTPAuthenticationService(@NotNull JustUserDetailService userService, @NotNull SettingsService settingsService, @NotNull TOTPDeviceRepository totpDeviceRepository, @NotNull PermissionConnector permissionConnector, @Value(value="${just.auth.mfaEncryptionPassword}") @NotNull String mfaEncryptionPassword, @Value(value="${just.common.system.domainprefix}") @NotNull String systemDomainPrefix) {
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        Intrinsics.checkNotNullParameter((Object)settingsService, (String)"settingsService");
        Intrinsics.checkNotNullParameter((Object)totpDeviceRepository, (String)"totpDeviceRepository");
        Intrinsics.checkNotNullParameter((Object)permissionConnector, (String)"permissionConnector");
        Intrinsics.checkNotNullParameter((Object)mfaEncryptionPassword, (String)"mfaEncryptionPassword");
        Intrinsics.checkNotNullParameter((Object)systemDomainPrefix, (String)"systemDomainPrefix");
        this.userService = userService;
        this.settingsService = settingsService;
        this.totpDeviceRepository = totpDeviceRepository;
        this.permissionConnector = permissionConnector;
        this.systemDomainPrefix = systemDomainPrefix;
        TextEncryptor textEncryptor = Encryptors.delux((CharSequence)mfaEncryptionPassword, (CharSequence)TEXT_ENCRYPTOR_SALT);
        Intrinsics.checkNotNullExpressionValue((Object)textEncryptor, (String)"delux(...)");
        this.textEncryptor = textEncryptor;
    }

    @NotNull
    public TextEncryptor getTextEncryptor() {
        return this.textEncryptor;
    }

    public boolean userHasConfirmedTOTPDevice(@NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        JustUser user = this.userService.loadUserByUsername(username);
        TOTPDevice device = this.totpDeviceRepository.findTOTPDeviceByProfileId(user.getProfileId());
        return device != null && device.getConfirmed();
    }

    public boolean userHasConfirmedTOTPDevice(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        TOTPDevice device = this.totpDeviceRepository.findTOTPDeviceByProfileId(profileId);
        return device != null && device.getConfirmed();
    }

    @NotNull
    public TOTPSecretDto createNewDevice() {
        JustUser user = this.userService.loadUserCurrentlyAuthenticated();
        return this.getOrCreateNewDeviceIntern(user, true);
    }

    @NotNull
    public TOTPSecretDto getOrCreateNewDevice(@NotNull String username, boolean generateNewSecret) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        JustUser user = this.userService.loadUserByUsername(username);
        return this.getOrCreateNewDeviceIntern(user, generateNewSecret);
    }

    public static /* synthetic */ TOTPSecretDto getOrCreateNewDevice$default(TOTPAuthenticationService tOTPAuthenticationService, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getOrCreateNewDevice");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return tOTPAuthenticationService.getOrCreateNewDevice(string, bl);
    }

    private TOTPSecretDto getOrCreateNewDeviceIntern(JustUser user, boolean generateNewSecret) {
        TOTPDevice device = this.totpDeviceRepository.findTOTPDeviceByProfileId(user.getProfileId());
        if (device == null) {
            ProfileId profileId = user.getProfileId();
            String string = this.getTextEncryptor().encrypt(RandomSecretProvider.Companion.generateSecret().getBase32Encoded());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encrypt(...)");
            device = new TOTPDevice(null, profileId, string, false, null, null, 57, null);
        } else if (generateNewSecret) {
            String string = this.getTextEncryptor().encrypt(RandomSecretProvider.Companion.generateSecret().getBase32Encoded());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encrypt(...)");
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            device = TOTPDevice.copy$default((TOTPDevice)device, null, null, (String)string, (boolean)false, (Instant)instant, null, (int)35, null);
        }
        this.totpDeviceRepository.upsertDevice(device);
        String string = this.getTextEncryptor().decrypt(device.getEncryptedSecret());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decrypt(...)");
        return new TOTPSecretDto(string, this.generateQRCode(device, user.getUsername()));
    }

    public boolean checkTOTPCodeAndConfirmDevice(@NotNull String code, @NotNull JustAuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return TOTPCheckResult.OK == this.checkTOTPCodeAndConfirmDevice(code, authContext.getProfileId());
    }

    public void checkTOTPCodeAndConfirmDevice(@NotNull TOTPAuthentication totpAuthentication) {
        Intrinsics.checkNotNullParameter((Object)totpAuthentication, (String)"totpAuthentication");
        String code = totpAuthentication.getCode();
        CharSequence charSequence = code;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new TOTPAuthenticationException(TOTPCheckResult.MISSING_CODE.getMessage());
        }
        String string = totpAuthentication.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        JustUser user = this.userService.loadUserByUsername(string);
        TOTPCheckResult result = this.checkTOTPCodeAndConfirmDevice(code, user.getProfileId());
        if (result != TOTPCheckResult.OK) {
            throw new TOTPAuthenticationException(result.getMessage());
        }
    }

    @NotNull
    public TOTPCheckResult checkTOTPCodeAndConfirmDevice(@NotNull String code, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        TOTPDevice device = this.totpDeviceRepository.findTOTPDeviceByProfileId(profileId);
        if (device == null) {
            LOG.debug("no totp device for profileId {}", (Object)profileId);
            return TOTPCheckResult.NO_DEVICE_REGISTERED;
        }
        boolean isCodeCorrect = this.verifyCode(device, code);
        if (isCodeCorrect) {
            if (!device.getConfirmed()) {
                this.totpDeviceRepository.setTOTPDeviceConfirmed(device.getId());
            }
            return TOTPCheckResult.OK;
        }
        LOG.debug("wrong totp code for profileId {}", (Object)profileId);
        return TOTPCheckResult.WRONG_CODE;
    }

    @NotNull
    public List<TOTPDeviceDto> findConfirmedTOTPDevice(@NotNull ProfileId profileId, @NotNull JustAuthorizationContext authContext) throws UnauthorizedException {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (Intrinsics.areEqual((Object)profileId, (Object)authContext.getProfileId()) || this.permissionConnector.mayManage((ItemId)authContext.getTenantId(), authContext.getProfileId())) {
            TOTPDevice totpDevice = this.totpDeviceRepository.findTOTPDeviceByProfileId(profileId);
            if (totpDevice != null && totpDevice.getConfirmed()) {
                return CollectionsKt.listOf((Object)new TOTPDeviceDto(totpDevice.getId(), totpDevice.getCreatedAt()));
            }
        } else {
            throw new UnauthorizedException("User does not have sufficient permissions.");
        }
        return CollectionsKt.emptyList();
    }

    private String generateQRCode(TOTPDevice device, String username) {
        String domain = new URI(this.systemDomainPrefix).getHost();
        DefaultTOTPService defaultTOTPService = new DefaultTOTPService(null, null, 3, null);
        String string = this.getTextEncryptor().decrypt(device.getEncryptedSecret());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decrypt(...)");
        TOTPSecret tOTPSecret = TOTPSecret.Companion.fromBase32EncodedString(string);
        EmailAddress emailAddress = new EmailAddress(username);
        Intrinsics.checkNotNull((Object)domain);
        String string2 = defaultTOTPService.generateTOTPUrl(tOTPSecret, emailAddress, new Issuer(domain)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String totpUri = string2;
        BitMatrix matrix = new MultiFormatWriter().encode(totpUri, BarcodeFormat.QR_CODE, 800, 800);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)"png", (OutputStream)stream);
        Base64 base64 = (Base64)Base64.Default;
        byte[] byArray = stream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return Base64.encode$default((Base64)base64, (byte[])byArray, (int)0, (int)0, (int)6, null);
    }

    public boolean verifyCode(@NotNull TOTPDevice device, @NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        DefaultTOTPService defaultTOTPService = new DefaultTOTPService(null, null, 3, null);
        TOTP tOTP = new TOTP(code);
        String string = this.getTextEncryptor().decrypt(device.getEncryptedSecret());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decrypt(...)");
        TOTPVerificationResult result = defaultTOTPService.verify(tOTP, TOTPSecret.Companion.fromBase32EncodedString(string));
        return result.isSuccess();
    }

    public boolean isMFARequired(@NotNull JustUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        TOTPDevice totpDevice = this.totpDeviceRepository.findTOTPDeviceByProfileId(user.getProfileId());
        if (totpDevice != null && totpDevice.getConfirmed()) {
            return true;
        }
        if (user.getTenantId() == null) {
            return TenantSettings.Companion.getMFA_MANDATORY_DEFAULT();
        }
        TenantSettings tenantSettings = this.settingsService.find(user.getTenantId());
        return tenantSettings != null ? tenantSettings.getMfaMandatory() : TenantSettings.Companion.getMFA_MANDATORY_DEFAULT();
    }

    public void deleteTOTPDevice(@NotNull ProfileId profileId, @NotNull JustAuthorizationContext authContext) throws UnauthorizedException {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!this.permissionConnector.mayManage((ItemId)authContext.getTenantId(), authContext.getProfileId())) {
            throw new UnauthorizedException("User does not have sufficient permissions.");
        }
        this.totpDeviceRepository.deleteTOTPDeviceByProfileId(profileId);
    }
}

