/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2.client;

import de.justsoftware.authorization.config.JustOauthClients;
import de.justsoftware.authorization.id.TenantId;
import de.justsoftware.authorization.oauth2.client.ApiTokenService;
import de.justsoftware.authorization.oauth2.client.ExposedRegisteredClientRepositoryKt;
import de.justsoftware.authorization.oauth2.client.RegisteredClients;
import de.justsoftware.authorization.oauth2.client.oauth2Authorization.Oauth2AuthorizationRepository;
import de.justsoftware.authorization.token.ApiToken;
import de.justsoftware.authorization.token.Scope;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.ISqlExpressionBuilder;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.DeleteStatement;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.settings.OAuth2TokenFormat;
import org.springframework.security.oauth2.server.authorization.settings.TokenSettings;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenClaimsSet;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Transactional
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u0000 $2\u00020\u0001:\u0001$B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J \u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\u001e\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\u001e\u0010\"\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/justsoftware/authorization/oauth2/client/ApiTokenService;", "", "clientRepository", "Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClientRepository;", "oauth2AuthorizationService", "Lorg/springframework/security/oauth2/server/authorization/OAuth2AuthorizationService;", "justOauthClients", "Lde/justsoftware/authorization/config/JustOauthClients;", "oauth2AuthorizationRepository", "Lde/justsoftware/authorization/oauth2/client/oauth2Authorization/Oauth2AuthorizationRepository;", "<init>", "(Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClientRepository;Lorg/springframework/security/oauth2/server/authorization/OAuth2AuthorizationService;Lde/justsoftware/authorization/config/JustOauthClients;Lde/justsoftware/authorization/oauth2/client/oauth2Authorization/Oauth2AuthorizationRepository;)V", "getClientRepository", "()Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClientRepository;", "getOauth2AuthorizationService", "()Lorg/springframework/security/oauth2/server/authorization/OAuth2AuthorizationService;", "getJustOauthClients", "()Lde/justsoftware/authorization/config/JustOauthClients;", "getOauth2AuthorizationRepository", "()Lde/justsoftware/authorization/oauth2/client/oauth2Authorization/Oauth2AuthorizationRepository;", "accessTokenGenerator", "Lorg/springframework/security/crypto/keygen/StringKeyGenerator;", "deleteApiTokensForScope", "", "tenantId", "Lde/justsoftware/authorization/id/TenantId;", "scope", "", "Lde/justsoftware/authorization/token/Scope;", "generateApiTokenForScope", "Lde/justsoftware/authorization/token/ApiToken;", "getCurrentApiToken", "getOrCreateClientForScope", "Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClient;", "getClientIdForScope", "", "Companion", "just-authorization-server"})
@SourceDebugExtension(value={"SMAP\nApiTokenService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiTokenService.kt\nde/justsoftware/authorization/oauth2/client/ApiTokenService\n+ 2 Queries.kt\norg/jetbrains/exposed/sql/QueriesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n121#2,5:144\n1557#3:149\n1628#3,3:150\n1557#3:153\n1628#3,3:154\n1557#3:157\n1628#3,3:158\n*S KotlinDebug\n*F\n+ 1 ApiTokenService.kt\nde/justsoftware/authorization/oauth2/client/ApiTokenService\n*L\n55#1:144,5\n63#1:149\n63#1:150,3\n124#1:153\n124#1:154,3\n139#1:157\n139#1:158,3\n*E\n"})
public class ApiTokenService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RegisteredClientRepository clientRepository;
    @NotNull
    private final OAuth2AuthorizationService oauth2AuthorizationService;
    @NotNull
    private final JustOauthClients justOauthClients;
    @NotNull
    private final Oauth2AuthorizationRepository oauth2AuthorizationRepository;
    @NotNull
    private final StringKeyGenerator accessTokenGenerator;
    private static final long ONE_YEAR_IN_DAYS = 365L;
    private static final int ACCESS_TOKEN_KEY_LENGTH = 48;

    public ApiTokenService(@NotNull RegisteredClientRepository clientRepository, @NotNull OAuth2AuthorizationService oauth2AuthorizationService, @NotNull JustOauthClients justOauthClients, @NotNull Oauth2AuthorizationRepository oauth2AuthorizationRepository) {
        Intrinsics.checkNotNullParameter((Object)clientRepository, (String)"clientRepository");
        Intrinsics.checkNotNullParameter((Object)oauth2AuthorizationService, (String)"oauth2AuthorizationService");
        Intrinsics.checkNotNullParameter((Object)justOauthClients, (String)"justOauthClients");
        Intrinsics.checkNotNullParameter((Object)oauth2AuthorizationRepository, (String)"oauth2AuthorizationRepository");
        this.clientRepository = clientRepository;
        this.oauth2AuthorizationService = oauth2AuthorizationService;
        this.justOauthClients = justOauthClients;
        this.oauth2AuthorizationRepository = oauth2AuthorizationRepository;
        this.accessTokenGenerator = (StringKeyGenerator)new Base64StringKeyGenerator(Base64.getUrlEncoder().withoutPadding(), 48);
    }

    @NotNull
    public RegisteredClientRepository getClientRepository() {
        return this.clientRepository;
    }

    @NotNull
    public OAuth2AuthorizationService getOauth2AuthorizationService() {
        return this.oauth2AuthorizationService;
    }

    @NotNull
    public JustOauthClients getJustOauthClients() {
        return this.justOauthClients;
    }

    @NotNull
    public Oauth2AuthorizationRepository getOauth2AuthorizationRepository() {
        return this.oauth2AuthorizationRepository;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteApiTokensForScope(@NotNull TenantId tenantId, @NotNull Set<? extends Scope> scope) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        String clientId = this.getClientIdForScope(tenantId, scope);
        RegisteredClient client = this.getClientRepository().findByClientId(clientId);
        if (client != null) {
            void $this$deleteApiTokensForScope_u24lambda_u240;
            Table $this$deleteWhere_u24default$iv = (Table)RegisteredClients.INSTANCE;
            Integer limit$iv = null;
            boolean $i$f$deleteWhere = false;
            ISqlExpressionBuilder iSqlExpressionBuilder = (ISqlExpressionBuilder)SqlExpressionBuilder.INSTANCE;
            RegisteredClients registeredClients = (RegisteredClients)$this$deleteWhere_u24default$iv;
            Table table = $this$deleteWhere_u24default$iv;
            Transaction transaction = TransactionManager.Companion.current();
            DeleteStatement.Companion companion = DeleteStatement.Companion;
            boolean bl = false;
            Op op = SqlExpressionBuilder.INSTANCE.eqEntityIDValue((ExpressionWithColumnType)$this$deleteApiTokensForScope_u24lambda_u240.getId(), (Object)UUID.fromString(client.getId()));
            companion.where(transaction, table, op, false, limit$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ApiToken generateApiTokenForScope(@NotNull TenantId tenantId, @NotNull Set<? extends Scope> scope) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        RegisteredClient client = this.getOrCreateClientForScope(tenantId, scope);
        this.getOauth2AuthorizationRepository().deleteByClientId(client);
        Iterable $this$map$iv = scope;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Scope scope2 = (Scope)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        Set scopes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Instant issuedAt = Instant.now();
        Instant expiresAt = issuedAt.plus(client.getTokenSettings().getAccessTokenTimeToLive());
        OAuth2TokenClaimsSet.Builder claimsBuilder = OAuth2TokenClaimsSet.builder();
        claimsBuilder.issuer(this.getJustOauthClients().getSystemDomainPrefix());
        claimsBuilder.subject(client.getClientId()).audience(CollectionsKt.listOf((Object)client.getClientId())).issuedAt(issuedAt).expiresAt(expiresAt).notBefore(issuedAt).id(UUID.randomUUID().toString());
        if (!CollectionUtils.isEmpty((Collection)scopes)) {
            claimsBuilder.claim("scope", (Object)scopes);
        }
        OAuth2TokenClaimsSet accessTokenClaimsSet = claimsBuilder.build();
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, this.accessTokenGenerator.generateKey(), accessTokenClaimsSet.getIssuedAt(), accessTokenClaimsSet.getExpiresAt(), scopes);
        OAuth2Authorization authorization = OAuth2Authorization.withRegisteredClient((RegisteredClient)client).token((OAuth2Token)accessToken, arg_0 -> ApiTokenService.generateApiTokenForScope$lambda$2(tenantId, client, scopes, arg_0)).authorizedScopes(scopes).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).principalName(client.getClientId()).build();
        this.getOauth2AuthorizationService().save(authorization);
        ApiToken apiToken = this.getCurrentApiToken(tenantId, scope);
        Intrinsics.checkNotNull((Object)apiToken);
        return apiToken;
    }

    @Nullable
    public ApiToken getCurrentApiToken(@NotNull TenantId tenantId, @NotNull Set<? extends Scope> scope) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        String clientId = this.getClientIdForScope(tenantId, scope);
        RegisteredClient client = this.getClientRepository().findByClientId(clientId);
        if (client == null) {
            return null;
        }
        Oauth2AuthorizationRepository oauth2AuthorizationRepository = this.getOauth2AuthorizationRepository();
        UUID uUID = UUID.fromString(client.getId());
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        return oauth2AuthorizationRepository.findAllOauth2Authorizations(uUID, tenantId.getValue());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public RegisteredClient getOrCreateClientForScope(@NotNull TenantId tenantId, @NotNull Set<? extends Scope> scope) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        String clientId = this.getClientIdForScope(tenantId, scope);
        RegisteredClient client = this.getClientRepository().findByClientId(clientId);
        if (client != null) {
            boolean bl = Intrinsics.areEqual((Object)ExposedRegisteredClientRepositoryKt.tenantId((RegisteredClient)client), (Object)tenantId);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return client;
        }
        ClientSettings.Builder builder = ClientSettings.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
        ClientSettings clientSettings = ExposedRegisteredClientRepositoryKt.tenantId((ClientSettings.Builder)builder, (TenantId)tenantId).requireProofKey(false).requireAuthorizationConsent(false).build();
        TokenSettings tokenSettings = TokenSettings.builder().accessTokenFormat(OAuth2TokenFormat.REFERENCE).accessTokenTimeToLive(Duration.ofDays(365L)).build();
        Iterable $this$map$iv = scope;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Scope scope2 = (Scope)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        Set scopes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        RegisteredClient newClient = RegisteredClient.withId((String)UUID.randomUUID().toString()).clientId(clientId).clientSettings(clientSettings).tokenSettings(tokenSettings).scopes(arg_0 -> ApiTokenService.getOrCreateClientForScope$lambda$4(scopes, arg_0)).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).build();
        this.getClientRepository().save(newClient);
        Intrinsics.checkNotNull((Object)newClient);
        return newClient;
    }

    /*
     * WARNING - void declaration
     */
    private String getClientIdForScope(TenantId tenantId, Set<? extends Scope> scope) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = scope;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void obj;
            Scope scope2 = (Scope)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(obj.toString());
        }
        String identifier = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)"_", null, null, (int)0, null, null, (int)62, null);
        return identifier + "_" + tenantId;
    }

    private static final void generateApiTokenForScope$lambda$2(TenantId $tenantId, RegisteredClient $client, Set $scopes, Map metadata) {
        Intrinsics.checkNotNullParameter((Object)$tenantId, (String)"$tenantId");
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$scopes, (String)"$scopes");
        Map claims = new LinkedHashMap();
        claims.put(TenantId.Companion.getJsonKey(), $tenantId.toTypedString());
        claims.put("username", $client.getClientId());
        claims.put("scope", StringUtils.collectionToCommaDelimitedString((Collection)$scopes));
        Intrinsics.checkNotNull((Object)metadata);
        metadata.put(OAuth2Authorization.Token.CLAIMS_METADATA_NAME, MapsKt.toMap((Map)claims));
    }

    private static final void getOrCreateClientForScope$lambda$4(Set $scopes, Set it) {
        Intrinsics.checkNotNullParameter((Object)$scopes, (String)"$scopes");
        it.addAll($scopes);
    }
}

