/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2;

import de.justsoftware.authorization.oauth2.ToroTokenMigrationService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.EventListener;
import org.springframework.jdbc.core.simple.JdbcClient;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Profile(value={"!test"})
@DependsOn(value={"registeredClientRepository"})
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0017J\b\u0010\u000b\u001a\u00020\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lde/justsoftware/authorization/oauth2/ToroTokenMigrationService;", "", "jdbcClient", "Lorg/springframework/jdbc/core/simple/JdbcClient;", "<init>", "(Lorg/springframework/jdbc/core/simple/JdbcClient;)V", "getJdbcClient", "()Lorg/springframework/jdbc/core/simple/JdbcClient;", "migrateTokens", "", "refreshScopeChange", "onApplicationReady", "Companion", "just-authorization-server"})
public class ToroTokenMigrationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JdbcClient jdbcClient;
    @NotNull
    private static final Logger LOG;

    public ToroTokenMigrationService(@NotNull JdbcClient jdbcClient) {
        Intrinsics.checkNotNullParameter((Object)jdbcClient, (String)"jdbcClient");
        this.jdbcClient = jdbcClient;
    }

    @NotNull
    public JdbcClient getJdbcClient() {
        return this.jdbcClient;
    }

    public void migrateTokens() {
        JdbcClient.ResultQuerySpec resultQuerySpec = this.getJdbcClient().sql("SELECT 1 FROM  information_schema.tables\n              WHERE  table_schema = 'public'\n              AND    table_name = 'oauth_token'").query();
        Intrinsics.checkNotNullExpressionValue((Object)resultQuerySpec, (String)"query(...)");
        JdbcClient.ResultQuerySpec result = resultQuerySpec;
        if (!result.rowSet().next()) {
            LOG.warn("no oauth_token table available to migrate. This is normal during tests");
            return;
        }
        int updated = this.getJdbcClient().sql("insert into oauth2_authorization (id, registered_client_id, principal_name, principal_profile_id, principal_tenant_id, authorization_grant_type, authorized_scopes, access_token_value, access_token_expires_at, refresh_token_value, refresh_token_expires_at)\n(\nselect gen_random_uuid(),c.id, COALESCE(p.email, t.client_id),CASE WHEN p.id IS NULL THEN null else CONCAT('PROFILE,',p.id) END,\n       COALESCE(p.tenant_id, cd.tenant_id),t.grant_type,t.\"scope\",t.access_token ,t.access_token_expiry ,t.refresh_token ,t.refresh_token_expiry\nfrom public.oauth_token t\n         left join public.person p on t.person_id  = p.id\n         JOIN public.oauth_client_details cd ON cd.client_id = t.client_id\n         join oauth2_registered_client c on c.client_id=t.client_id\nwhere (access_token_expiry > now() or refresh_token_expiry > now())\n    and not exists(SELECT 1 FROM oauth2_authorization where oauth2_authorization.access_token_value=t.access_token)\n)").update();
        LOG.info("migrated " + updated + " oauth-tokens");
    }

    @EventListener(value={RefreshScopeRefreshedEvent.class})
    @Transactional
    public void refreshScopeChange() {
        this.migrateTokens();
    }

    @EventListener(value={ApplicationReadyEvent.class})
    @Transactional
    public void onApplicationReady() {
        this.migrateTokens();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Logger logger = LoggerFactory.getLogger(ToroTokenMigrationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

