/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.connector;

import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.id.TenantId;
import de.justsoftware.authorization.oauth2.JustToroUser;
import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.oauth2.LoginDto;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/authorization/connector/ToroConnector;", "", "toroInternalUrl", "", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/client/RestClient$Builder;)V", "getToroInternalUrl", "()Ljava/lang/String;", "restClient", "Lorg/springframework/web/client/RestClient;", "getRestClient", "()Lorg/springframework/web/client/RestClient;", "retrieveUser", "Lde/justsoftware/authorization/oauth2/JustUser;", "username", "password", "just-authorization-server"})
public class ToroConnector {
    @NotNull
    private final String toroInternalUrl;
    @NotNull
    private final RestClient restClient;

    public ToroConnector(@Value(value="${just.toro.internal}") @NotNull String toroInternalUrl, @NotNull RestClient.Builder restClientBuilder) {
        Intrinsics.checkNotNullParameter((Object)toroInternalUrl, (String)"toroInternalUrl");
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        this.toroInternalUrl = toroInternalUrl;
        RestClient restClient = restClientBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
        this.restClient = restClient;
    }

    @NotNull
    public String getToroInternalUrl() {
        return this.toroInternalUrl;
    }

    @NotNull
    public RestClient getRestClient() {
        return this.restClient;
    }

    @Nullable
    public JustUser retrieveUser(@NotNull String username, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
        return (JustUser)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.getRestClient().post().uri(this.getToroInternalUrl() + "/auth/login/", new Object[0])).accept(mediaTypeArray)).body((Object)new LoginDto(username, password)).exchange((arg_0, arg_1) -> ToroConnector.retrieveUser$lambda$0(username, arg_0, arg_1));
    }

    private static final JustUser retrieveUser$lambda$0(String $username, HttpRequest httpRequest, RestClient.RequestHeadersSpec.ConvertibleClientHttpResponse clientResponse) {
        Intrinsics.checkNotNullParameter((Object)$username, (String)"$username");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)clientResponse, (String)"clientResponse");
        if (clientResponse.getStatusCode() != HttpStatus.OK) {
            throw new UsernameNotFoundException("Status " + clientResponse.getStatusCode() + " when retrieving user: " + $username + ".");
        }
        JustToroUser justToroUser = (JustToroUser)clientResponse.bodyTo(JustToroUser.class);
        if (justToroUser == null) {
            throw new UsernameNotFoundException("null returned from toro when trying to load user " + $username + ".");
        }
        JustToroUser toroUser = justToroUser;
        String string = toroUser.getUsername();
        List list = toroUser.getAuthorities();
        ProfileId profileId = toroUser.getProfileId();
        TenantId tenantId = toroUser.getTenantId();
        boolean bl = toroUser.isAccountNonExpired();
        boolean bl2 = toroUser.isAccountNonLocked();
        boolean bl3 = toroUser.isCredentialsNonExpired();
        boolean bl4 = toroUser.isEnabled();
        return new JustUser(profileId, tenantId, string, null, list, bl, bl2, bl3, bl4);
    }
}

