/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.config;

import de.justsoftware.authorization.trusteddevice.TrustedDeviceAuthenticationHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationCode;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.CookieClearingLogoutHandler;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/authorization/config/InvalidateSessionAndAddTrustedDeviceAndRedirectHandler;", "Lorg/springframework/security/web/authentication/AuthenticationSuccessHandler;", "trustedDeviceAuthenticationHandler", "Lde/justsoftware/authorization/trusteddevice/TrustedDeviceAuthenticationHandler;", "<init>", "(Lde/justsoftware/authorization/trusteddevice/TrustedDeviceAuthenticationHandler;)V", "onAuthenticationSuccess", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "authentication", "Lorg/springframework/security/core/Authentication;", "just-authorization-server"})
public final class InvalidateSessionAndAddTrustedDeviceAndRedirectHandler
implements AuthenticationSuccessHandler {
    @NotNull
    private final TrustedDeviceAuthenticationHandler trustedDeviceAuthenticationHandler;

    public InvalidateSessionAndAddTrustedDeviceAndRedirectHandler(@NotNull TrustedDeviceAuthenticationHandler trustedDeviceAuthenticationHandler) {
        Intrinsics.checkNotNullParameter((Object)trustedDeviceAuthenticationHandler, (String)"trustedDeviceAuthenticationHandler");
        this.trustedDeviceAuthenticationHandler = trustedDeviceAuthenticationHandler;
    }

    public void onAuthenticationSuccess(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Authentication authentication) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = (OAuth2AuthorizationCodeRequestAuthenticationToken)authentication;
        String string = authorizationCodeRequestAuthentication.getRedirectUri();
        Intrinsics.checkNotNull((Object)string);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)string);
        Object[] objectArray = new Object[1];
        OAuth2AuthorizationCode oAuth2AuthorizationCode = authorizationCodeRequestAuthentication.getAuthorizationCode();
        Intrinsics.checkNotNull((Object)oAuth2AuthorizationCode);
        objectArray[0] = oAuth2AuthorizationCode.getTokenValue();
        UriComponentsBuilder uriComponentsBuilder2 = uriComponentsBuilder.queryParam("code", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder2, (String)"queryParam(...)");
        UriComponentsBuilder uriBuilder = uriComponentsBuilder2;
        if (StringUtils.hasText((String)authorizationCodeRequestAuthentication.getState())) {
            Object[] objectArray2 = new Object[1];
            String string2 = authorizationCodeRequestAuthentication.getState();
            Intrinsics.checkNotNull((Object)string2);
            objectArray2[0] = UriUtils.encode((String)string2, (Charset)StandardCharsets.UTF_8);
            uriBuilder.queryParam("state", objectArray2);
        }
        String string3 = uriBuilder.build(true).toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUriString(...)");
        String redirectUri = string3;
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        this.trustedDeviceAuthenticationHandler.onAuthenticationSuccess(request, response, authentication);
        request.getSession(false).invalidate();
        String[] stringArray = new String[]{"JSESSIONID"};
        new CookieClearingLogoutHandler(stringArray).logout(request, response, authentication);
        redirectStrategy.sendRedirect(request, response, redirectUri);
    }
}

