/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.mybatis.mapper;

import de.justsoftware.admin.id.TenantId;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.annotation.Transactional;

@Mapper
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\bg\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u0006\u0010\u0006\u001a\u00020\u0007H'J\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H'J\u001e\u0010\r\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/admin/mybatis/mapper/TenantScimAvailableFieldsRepository;", "", "getAll", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "replaceAllFields", "", "fields", "", "deleteAllForTenant", "insertAll", "names", "", "admin-service"})
public interface TenantScimAvailableFieldsRepository {
    @Select(value={"\n        SELECT name FROM scim_available_fields\n        WHERE tenant_id = #{tenantId}\n    "})
    @NotNull
    public LinkedHashSet<String> getAll(@NotNull TenantId var1);

    @Transactional
    default public void replaceAllFields(@NotNull Collection<String> fields, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.deleteAllForTenant(tenantId);
        if (fields.isEmpty()) {
            return;
        }
        this.insertAll(CollectionsKt.toSet((Iterable)fields), tenantId);
    }

    @Delete(value={"DELETE FROM scim_available_fields WHERE tenant_id = #{tenantId}"})
    public void deleteAllForTenant(@NotNull TenantId var1);

    @Insert(value={"\n    <script>\n        INSERT INTO scim_available_fields (name, tenant_id) VALUES\n        <foreach collection=\"names\" item=\"name\" separator=\",\">\n            (#{name}, #{tenantId})\n        </foreach>\n    </script>\n    "})
    public void insertAll(@NotNull Set<String> var1, @NotNull TenantId var2);
}

