/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.mybatis.mapper;

import de.justsoftware.admin.domain.user.model.Profile;
import de.justsoftware.admin.domain.user.persistence.repository.ProfileRepository;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.id.TenantId;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mapper
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\bg\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H'JZ\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u00072\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u000e2\b\b\u0001\u0010\u0011\u001a\u00020\u000e2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0013H'J\u0012\u0010\u0015\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u0007H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0016\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/admin/mybatis/mapper/ProfileMapper;", "Lde/justsoftware/admin/domain/user/persistence/repository/ProfileRepository;", "getByIds", "", "Lde/justsoftware/admin/domain/user/model/Profile;", "ids", "", "Lde/justsoftware/admin/id/ProfileId;", "insertOrUpdate", "", "id", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "firstname", "", "lastname", "email", "imageUrl", "active", "", "blocked", "delete", "admin-service"})
public interface ProfileMapper
extends ProfileRepository {
    @Select(value={"<script>\n        SELECT id, firstname, lastname, email, image_url, active, blocked, tenant_id FROM profile p\n        WHERE p.id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)\n        </script>"})
    @NotNull
    public Set<Profile> getByIds(@NotNull Collection<ProfileId> var1);

    @Insert(value={"<script>\n\n        <if test=\"_databaseId == 'POSTGRES'\">\n            INSERT INTO profile (id, tenant_id, firstname, lastname, email, image_url, active, blocked)\n                VALUES (#{id}, #{tenantId}, #{firstName}, #{lastName}, #{email}, #{imageUrl}, #{active}, #{blocked})\n            ON CONFLICT(id)\n                DO UPDATE SET (tenant_id, firstname, lastname, email, image_url, active, blocked)\n                = (#{tenantId}, #{firstName}, #{lastName}, #{email}, #{imageUrl}, #{active}, #{blocked})\n        </if>\n\n        <if test=\"_databaseId == 'ORACLE'\">\n            MERGE INTO profile p USING (SELECT #{id} as id from dual) s ON (s.id = p.id)\n            WHEN MATCHED THEN\n                UPDATE SET\n                    tenant_id = #{tenantId},\n                    firstname = #{firstName},\n                    lastname = #{lastName},\n                    email = #{email},\n                    image_url = #{imageUrl},\n                    active = #{active},\n                    blocked = #{blocked}\n            WHEN NOT MATCHED THEN\n                INSERT (id, tenant_id, firstname, lastname, email, image_url, active, blocked)\n                VALUES (#{id}, #{tenantId}, #{firstName}, #{lastName}, #{email}, #{imageUrl}, #{active}, #{blocked})\n        </if>\n\n        </script>\n        "})
    public void insertOrUpdate(@Param(value="id") @NotNull ProfileId var1, @Param(value="tenantId") @Nullable TenantId var2, @Param(value="firstName") @NotNull String var3, @Param(value="lastName") @NotNull String var4, @Param(value="email") @NotNull String var5, @Param(value="imageUrl") @NotNull String var6, @Param(value="active") boolean var7, @Param(value="blocked") boolean var8);

    @Delete(value={"DELETE FROM profile WHERE id = #{id}"})
    public void delete(@Param(value="id") @NotNull ProfileId var1);
}

