/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.kafka.publisher.producer;

import de.justsoftware.admin.exceptions.NotFoundException;
import de.justsoftware.admin.kafka.publisher.producer.PermissionConfigProducer;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00020\bH\u0010\u00a2\u0006\u0002\b\tJ\r\u0010\n\u001a\u00020\bH\u0010\u00a2\u0006\u0002\b\u000bR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/admin/kafka/publisher/producer/PermissionConfigProducer;", "", "permissionProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "", "<init>", "(Lde/justsoftware/kafka/client/KafkaCleaningProducer;)V", "sendAppConfig", "", "sendAppConfig$admin_service", "sendTenantConfig", "sendTenantConfig$admin_service", "Companion", "admin-service"})
public class PermissionConfigProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KafkaCleaningProducer<String, String> permissionProducer;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final String TOPIC = "just.permission.config";
    @NotNull
    private static final String CONFIG_FILE_PATH_APP = "/permission-app-config.json";
    @NotNull
    private static final String CONFIG_FILE_PATH_TENANT = "/permission-tenant-config.json";

    public PermissionConfigProducer(@NotNull KafkaCleaningProducer<String, String> permissionProducer) {
        Intrinsics.checkNotNullParameter(permissionProducer, (String)"permissionProducer");
        this.permissionProducer = permissionProducer;
    }

    public void sendAppConfig$admin_service() {
        URL config;
        log.info("Sending Permission APP Config to TOPIC: 'just.permission.config'");
        URL uRL = this.getClass().getResource(CONFIG_FILE_PATH_APP);
        if (uRL == null) {
            throw new NotFoundException("Cant find file '/permission-app-config.json' in resources!");
        }
        URL uRL2 = config = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        this.permissionProducer.send(new ProducerRecord(TOPIC, (Object)"APP", (Object)new String(byArray, charset)));
    }

    public void sendTenantConfig$admin_service() {
        URL config;
        log.info("Sending Permission TENANT Config to TOPIC: 'just.permission.config'");
        URL uRL = this.getClass().getResource(CONFIG_FILE_PATH_TENANT);
        if (uRL == null) {
            throw new NotFoundException("Cant find file '/permission-tenant-config.json' in resources!");
        }
        URL uRL2 = config = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        this.permissionProducer.send(new ProducerRecord(TOPIC, (Object)"TENANT", (Object)new String(byArray, charset)));
    }

    static {
        Logger logger = LoggerFactory.getLogger(PermissionConfigProducer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

