/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.tenant;

import de.justsoftware.admin.domain.tenant.model.TenantPermission;
import de.justsoftware.admin.domain.tenant.persistence.TenantPermissionRepository;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.id.UserId;
import de.justsoftware.admin.model.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J+\u0010\u0011\u001a\u00020\n2!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\n0\u0013H\u0016J2\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0016J,\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000eH\u0012J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u001e\u001a\u00020\u001bH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/justsoftware/admin/domain/tenant/TenantPermissionService;", "", "tenantPermissionRepo", "Lde/justsoftware/admin/domain/tenant/persistence/TenantPermissionRepository;", "<init>", "(Lde/justsoftware/admin/domain/tenant/persistence/TenantPermissionRepository;)V", "savePermission", "Lde/justsoftware/admin/domain/tenant/model/TenantPermission;", "tenantPermission", "save", "", "tenantPermissions", "", "getBy", "", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "forEachPermission", "consumer", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "update", "adds", "removes", "checkRemainingManagers", "add", "Lde/justsoftware/admin/id/UserId;", "remove", "deleteAllFor", "granteeId", "findTenantManagers", "admin-service"})
@SourceDebugExtension(value={"SMAP\nTenantPermissionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TenantPermissionService.kt\nde/justsoftware/admin/domain/tenant/TenantPermissionService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n1863#2,2:117\n774#2:119\n865#2,2:120\n1557#2:122\n1628#2,3:123\n774#2:126\n865#2,2:127\n1557#2:129\n1628#2,3:130\n1863#2:133\n774#2:134\n865#2,2:135\n1863#2,2:137\n1864#2:139\n1863#2,2:140\n1557#2:142\n1628#2,3:143\n1782#2,4:146\n1557#2:150\n1628#2,3:151\n*S KotlinDebug\n*F\n+ 1 TenantPermissionService.kt\nde/justsoftware/admin/domain/tenant/TenantPermissionService\n*L\n29#1:117,2\n53#1:119\n53#1:120,2\n53#1:122\n53#1:123,3\n54#1:126\n54#1:127,2\n54#1:129\n54#1:130,3\n57#1:133\n62#1:134\n62#1:135,2\n63#1:137,2\n57#1:139\n79#1:140,2\n95#1:142\n95#1:143,3\n97#1:146,4\n114#1:150\n114#1:151,3\n*E\n"})
public class TenantPermissionService {
    @NotNull
    private final TenantPermissionRepository tenantPermissionRepo;

    public TenantPermissionService(@NotNull TenantPermissionRepository tenantPermissionRepo) {
        Intrinsics.checkNotNullParameter((Object)tenantPermissionRepo, (String)"tenantPermissionRepo");
        this.tenantPermissionRepo = tenantPermissionRepo;
    }

    @NotNull
    public TenantPermission savePermission(@NotNull TenantPermission tenantPermission) {
        Intrinsics.checkNotNullParameter((Object)tenantPermission, (String)"tenantPermission");
        this.tenantPermissionRepo.upsert(tenantPermission.getTenantId(), tenantPermission.getGranteeId().toTypedString(), tenantPermission.getRole());
        return tenantPermission;
    }

    public void save(@NotNull Set<TenantPermission> tenantPermissions) {
        Intrinsics.checkNotNullParameter(tenantPermissions, (String)"tenantPermissions");
        Iterable $this$forEach$iv = tenantPermissions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TenantPermission it = (TenantPermission)element$iv;
            boolean bl = false;
            this.tenantPermissionRepo.upsert(it.getTenantId(), it.getGranteeId().toTypedString(), it.getRole());
        }
    }

    @NotNull
    public List<TenantPermission> getBy(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.tenantPermissionRepo.findByTenantId(tenantId);
    }

    public void forEachPermission(@NotNull Function1<? super TenantPermission, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.tenantPermissionRepo.forEach(consumer);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<TenantPermission> update(@NotNull TenantId tenantId, @NotNull Set<TenantPermission> adds, @NotNull Set<TenantPermission> removes) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        TenantPermission it;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(adds, (String)"adds");
        Intrinsics.checkNotNullParameter(removes, (String)"removes");
        Iterable $this$filter$iv = adds;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (TenantPermission)element$iv$iv;
            boolean bl = false;
            if (!(it.getRole() == Role.MANAGER)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (TenantPermission)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getGranteeId());
        }
        List addManagers = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = removes;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TenantPermission it2 = (TenantPermission)element$iv$iv;
            boolean bl = false;
            if (!(it2.getRole() == Role.MANAGER)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TenantPermission it2 = (TenantPermission)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it2.getGranteeId());
        }
        List removeManagers = (List)destination$iv$iv2;
        this.checkRemainingManagers(tenantId, addManagers, removeManagers);
        Iterable $this$forEach$iv = adds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TenantPermission it3 = (TenantPermission)element$iv;
            boolean bl = false;
            if (it3.getRole().isVsl()) {
                void $this$forEach$iv2;
                void $this$filterTo$iv$iv3;
                Iterable $this$filter$iv3;
                Set origins = this.tenantPermissionRepo.findByTenantIdAndGranteeId(it3.getTenantId(), it3.getGranteeId().toTypedString());
                Iterable it4 = origins;
                boolean $i$f$filter3 = false;
                Iterator iterator = $this$filter$iv3;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                    TenantPermission origin = (TenantPermission)element$iv$iv;
                    boolean bl2 = false;
                    if (!origin.getRole().isVsl()) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                $this$filter$iv3 = (List)destination$iv$iv3;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    TenantPermission origin = (TenantPermission)element$iv2;
                    boolean bl3 = false;
                    this.tenantPermissionRepo.deleteOne(origin.getTenantId(), origin.getGranteeId().toTypedString(), origin.getRole());
                }
            }
            this.tenantPermissionRepo.upsert(it3.getTenantId(), it3.getGranteeId().toTypedString(), it3.getRole());
        }
        $this$forEach$iv = removes;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TenantPermission it5 = (TenantPermission)element$iv;
            boolean bl = false;
            this.tenantPermissionRepo.deleteOne(it5.getTenantId(), it5.getGranteeId().toTypedString(), it5.getRole());
        }
        return this.tenantPermissionRepo.findByTenantId(tenantId);
    }

    /*
     * WARNING - void declaration
     */
    private void checkRemainingManagers(TenantId tenantId, List<? extends UserId> add, List<? extends UserId> remove) {
        int remaining;
        void $this$count$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        if (remove.isEmpty()) {
            return;
        }
        Iterable iterable = this.tenantPermissionRepo.findByTenantIdAndPermission(tenantId, Role.MANAGER);
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TenantPermission tenantPermission = (TenantPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getGranteeId());
        }
        $this$map$iv = CollectionsKt.union((Iterable)((List)destination$iv$iv), (Iterable)add);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v0 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                UserId it = (UserId)element$iv;
                boolean bl = false;
                if (!(!remove.contains(it)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v0 = remaining = count$iv;
        }
        if (remaining < 1) {
            throw new IllegalArgumentException("Cant delete the last Manager of a Tenant!");
        }
    }

    @NotNull
    public List<TenantPermission> deleteAllFor(@NotNull UserId granteeId) {
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        List permissions = this.tenantPermissionRepo.findBy(granteeId.toTypedString());
        this.tenantPermissionRepo.deleteManyBy(granteeId.toTypedString());
        return permissions;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<UserId> findTenantManagers(@NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$map$iv = this.tenantPermissionRepo.findByTenantIdAndPermission(tenantId, Role.MANAGER);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TenantPermission tenantPermission = (TenantPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getGranteeId());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }
}

