/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.web;

import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.connector.profile.InternalCreateProfileModel;
import de.justsoftware.admin.connector.profile.ProfileConnector;
import de.justsoftware.admin.domain.user.UserService;
import de.justsoftware.admin.domain.user.model.Grantee;
import de.justsoftware.admin.domain.user.model.UserGroup;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.id.UserId;
import de.justsoftware.admin.util.Unauthorized;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fH\u0017J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/justsoftware/admin/application/web/UserApplicationService;", "", "userService", "Lde/justsoftware/admin/domain/user/UserService;", "profileConnector", "Lde/justsoftware/admin/connector/profile/ProfileConnector;", "<init>", "(Lde/justsoftware/admin/domain/user/UserService;Lde/justsoftware/admin/connector/profile/ProfileConnector;)V", "createProfile", "Lde/justsoftware/admin/id/ProfileId;", "profileInput", "Lde/justsoftware/admin/connector/profile/InternalCreateProfileModel;", "authContext", "Lde/justsoftware/admin/authorization/AuthorizationContext;", "getByIds", "", "Lde/justsoftware/admin/domain/user/model/Grantee;", "ids", "Lde/justsoftware/admin/id/UserId;", "getAllTenantUsersGroup", "Lde/justsoftware/admin/domain/user/model/UserGroup;", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "admin-service"})
public class UserApplicationService {
    @NotNull
    private final UserService userService;
    @NotNull
    private final ProfileConnector profileConnector;

    public UserApplicationService(@NotNull UserService userService, @NotNull ProfileConnector profileConnector) {
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        Intrinsics.checkNotNullParameter((Object)profileConnector, (String)"profileConnector");
        this.userService = userService;
        this.profileConnector = profileConnector;
    }

    @NotNull
    public ProfileId createProfile(@NotNull InternalCreateProfileModel profileInput, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)profileInput, (String)"profileInput");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        TenantId tenantId = TenantId.Companion.fromString(profileInput.getTenantId());
        authContext.checkTenantManager(tenantId);
        return this.profileConnector.createProfile(profileInput);
    }

    @Unauthorized
    @NotNull
    public List<Grantee> getByIds(@NotNull List<? extends UserId> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        return this.userService.getByIds(ids);
    }

    @NotNull
    public UserGroup getAllTenantUsersGroup(@NotNull TenantId tenantId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        return this.userService.getAllTenantUsersGroup(tenantId);
    }
}

