/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.lz4.LZ4Utils;
import net.jpountz.util.Utils;

final class LZ4JavaSafeFastDecompressor
extends LZ4FastDecompressor {
    public static final LZ4FastDecompressor INSTANCE = new LZ4JavaSafeFastDecompressor();

    LZ4JavaSafeFastDecompressor() {
    }

    @Override
    public int decompress(byte[] src, int srcOff, byte[] dest, int destOff, int destLen) {
        int literalCopyEnd;
        int literalLen;
        Utils.checkRange(src, srcOff);
        Utils.checkRange(dest, destOff, destLen);
        if (destLen == 0) {
            if (src[srcOff] != 0) {
                throw new LZ4Exception("Malformed input at " + srcOff);
            }
            return 1;
        }
        int destEnd = destOff + destLen;
        int sOff = srcOff;
        int dOff = destOff;
        while (true) {
            int matchCopyEnd;
            int token2 = Utils.readByte(src, sOff) & 0xFF;
            ++sOff;
            literalLen = token2 >>> 4;
            if (literalLen == 15) {
                int len = -1;
                while ((len = src[sOff++]) == -1) {
                    literalLen += 255;
                }
                literalLen += len & 0xFF;
            }
            if ((literalCopyEnd = dOff + literalLen) > destEnd - 8) {
                if (literalCopyEnd != destEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                break;
            }
            LZ4Utils.wildArraycopy(src, sOff, dest, dOff, literalLen);
            dOff = literalCopyEnd;
            int matchDec = LZ4Utils.readShortLittleEndian(src, sOff += literalLen);
            sOff += 2;
            int matchOff = dOff - matchDec;
            if (matchOff < destOff) {
                throw new LZ4Exception("Malformed input at " + sOff);
            }
            int matchLen = token2 & 0xF;
            if (matchLen == 15) {
                int len = -1;
                while ((len = src[sOff++]) == -1) {
                    matchLen += 255;
                }
                matchLen += len & 0xFF;
            }
            if ((matchCopyEnd = dOff + (matchLen += 4)) > destEnd - 8) {
                if (matchCopyEnd > destEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                LZ4Utils.safeIncrementalCopy(dest, matchOff, dOff, matchLen);
            } else {
                LZ4Utils.wildIncrementalCopy(dest, matchOff, dOff, matchCopyEnd);
            }
            dOff = matchCopyEnd;
        }
        LZ4Utils.safeArraycopy(src, sOff, dest, dOff, literalLen);
        dOff = literalCopyEnd;
        return (sOff += literalLen) - srcOff;
    }
}

