/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.search;

import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.people.application.utils.OffsetBasedPageRequest;
import de.justsoftware.people.business.event.ProfilesCreatedEvent;
import de.justsoftware.people.business.event.ProfilesDeletedEvent;
import de.justsoftware.people.business.event.ProfilesUpdatedEvent;
import de.justsoftware.people.business.event.UserGroupCreatedOrPublishedEvent;
import de.justsoftware.people.business.event.UserGroupDeletedEvent;
import de.justsoftware.people.business.event.UserGroupMembersUpdatedEvent;
import de.justsoftware.people.business.event.UserGroupRolesUpdatedEvent;
import de.justsoftware.people.business.event.UserGroupUpdatedEvent;
import de.justsoftware.people.business.profile.ProfileAttributeConfigService;
import de.justsoftware.people.business.profile.ProfileService;
import de.justsoftware.people.business.profile.model.Profile;
import de.justsoftware.people.business.profile.model.ProfileAttributeConfig;
import de.justsoftware.people.business.search.SearchService;
import de.justsoftware.people.business.search.VisibilityService;
import de.justsoftware.people.business.search.model.FacetFilter;
import de.justsoftware.people.business.search.model.SearchField;
import de.justsoftware.people.business.search.model.SearchFilter;
import de.justsoftware.people.business.search.model.SearchId;
import de.justsoftware.people.business.search.solr.SolrIntegration;
import de.justsoftware.people.business.search.solr.model.ProfileSearchReadModel;
import de.justsoftware.people.business.search.solr.model.SearchModel;
import de.justsoftware.people.business.search.solr.model.UserGroupSearchIndexModel;
import de.justsoftware.people.business.usergroup.UserGroupService;
import de.justsoftware.people.business.usergroup.model.UserGroup;
import de.justsoftware.people.model.PagedResult;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.model.UserGroupId;
import de.justsoftware.people.persistence.UserGroupMemberRepository;
import de.justsoftware.people.persistence.model.DbUserGroupMember;
import de.justsoftware.people.utils.CollectionUtilsKt;
import de.justsoftware.people.utils.KafkaUtilsKt;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.search.shared.SolrIndexQueue;
import de.justsoftware.search.shared.model.SearchType;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.event.EventListener;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0006\b\u0017\u0018\u0000 e2\u00020\u0001:\u0001eBU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0014\b\u0001\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J`\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00122\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0016J<\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0016J.\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010,\u001a\u00020-H\u0016J>\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0016J \u00100\u001a\u0004\u0018\u00010\u00172\u0006\u00101\u001a\u0002022\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016JJ\u00103\u001a\b\u0012\u0004\u0012\u00020/0\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00120\u001f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0016J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020:0<2\u0006\u0010=\u001a\u000206H\u0016J\b\u0010>\u001a\u00020?H\u0016J!\u0010@\u001a\u00020?2\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020\u00120BH\u0011\u00a2\u0006\u0002\bDJ\u0015\u0010E\u001a\u00020?2\u0006\u0010F\u001a\u00020GH\u0011\u00a2\u0006\u0002\bHJ\u0015\u0010I\u001a\u00020?2\u0006\u0010F\u001a\u00020JH\u0011\u00a2\u0006\u0002\bKJ\u0015\u0010L\u001a\u00020?2\u0006\u0010F\u001a\u00020MH\u0011\u00a2\u0006\u0002\bNJ\u0015\u0010O\u001a\u00020?2\u0006\u0010F\u001a\u00020PH\u0011\u00a2\u0006\u0002\bQJ\u0015\u0010R\u001a\u00020?2\u0006\u0010F\u001a\u00020SH\u0011\u00a2\u0006\u0002\bTJ\u0015\u0010U\u001a\u00020?2\u0006\u0010F\u001a\u00020VH\u0011\u00a2\u0006\u0002\bWJ\u0015\u0010X\u001a\u00020?2\u0006\u0010F\u001a\u00020YH\u0011\u00a2\u0006\u0002\bZJ\u0015\u0010[\u001a\u00020?2\u0006\u0010F\u001a\u00020\\H\u0011\u00a2\u0006\u0002\b]J\u0016\u0010^\u001a\u00020?2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020C0`H\u0012J\u0010\u0010^\u001a\u00020?2\u0006\u0010a\u001a\u00020CH\u0012J\u0010\u0010b\u001a\u00020?2\u0006\u0010c\u001a\u00020$H\u0012J\u0016\u0010b\u001a\u00020?2\f\u0010d\u001a\b\u0012\u0004\u0012\u0002020`H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\b\u0012\u0004\u0012\u0002060\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u001a\u00109\u001a\b\u0012\u0004\u0012\u00020:0\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u00108\u00a8\u0006f"}, d2={"Lde/justsoftware/people/business/search/SearchService;", "", "solrIntegration", "Lde/justsoftware/people/business/search/solr/SolrIntegration;", "profileAttributeConfigService", "Lde/justsoftware/people/business/profile/ProfileAttributeConfigService;", "profileService", "Lde/justsoftware/people/business/profile/ProfileService;", "userGroupService", "Lde/justsoftware/people/business/usergroup/UserGroupService;", "visibilityService", "Lde/justsoftware/people/business/search/VisibilityService;", "solrIndexQueue", "Lde/justsoftware/search/shared/SolrIndexQueue;", "userGroupMemberRepository", "Lde/justsoftware/people/persistence/UserGroupMemberRepository;", "kafkaProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "", "<init>", "(Lde/justsoftware/people/business/search/solr/SolrIntegration;Lde/justsoftware/people/business/profile/ProfileAttributeConfigService;Lde/justsoftware/people/business/profile/ProfileService;Lde/justsoftware/people/business/usergroup/UserGroupService;Lde/justsoftware/people/business/search/VisibilityService;Lde/justsoftware/search/shared/SolrIndexQueue;Lde/justsoftware/people/persistence/UserGroupMemberRepository;Lde/justsoftware/kafka/client/KafkaCleaningProducer;)V", "allProfiles", "Lde/justsoftware/people/model/PagedResult;", "Lde/justsoftware/people/business/search/solr/model/ProfileSearchReadModel;", "tenantId", "Lde/justsoftware/people/model/TenantId;", "searchString", "searchFilter", "", "Lde/justsoftware/people/business/search/model/SearchFilter;", "searchRoles", "", "Lde/justsoftware/permission/client/model/Role;", "facetFilter", "Lde/justsoftware/people/business/search/model/FacetFilter;", "groupId", "Lde/justsoftware/people/model/UserGroupId;", "offset", "", "limit", "birthdayList", "currentDate", "Ljava/time/LocalDate;", "profilesInUserGroup", "isTenantAdmin", "", "allProfilesAndUserGroups", "Lde/justsoftware/people/business/search/solr/model/SearchModel;", "findProfile", "profileId", "Lde/justsoftware/people/model/ProfileId;", "searchInNames", "types", "searchableFields", "Lde/justsoftware/people/business/search/model/SearchField;", "getSearchableFields", "()Ljava/util/List;", "searchConfiguration", "Lde/justsoftware/people/business/profile/model/ProfileAttributeConfig;", "getSearchConfiguration", "Ljava/util/Optional;", "searchField", "reindexAllGroups", "", "onSearchIndex", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "Lde/justsoftware/people/business/search/model/SearchId;", "onSearchIndex$people_api", "onProfilesUpdatedEvent", "e", "Lde/justsoftware/people/business/event/ProfilesUpdatedEvent;", "onProfilesUpdatedEvent$people_api", "onProfilesCreatedEvent", "Lde/justsoftware/people/business/event/ProfilesCreatedEvent;", "onProfilesCreatedEvent$people_api", "onProfilesDeletedEvent", "Lde/justsoftware/people/business/event/ProfilesDeletedEvent;", "onProfilesDeletedEvent$people_api", "onUserGroupCreatedOrPublishedEvent", "Lde/justsoftware/people/business/event/UserGroupCreatedOrPublishedEvent;", "onUserGroupCreatedOrPublishedEvent$people_api", "onUserGroupUpdatedEvent", "Lde/justsoftware/people/business/event/UserGroupUpdatedEvent;", "onUserGroupUpdatedEvent$people_api", "onUserGroupDeletedEvent", "Lde/justsoftware/people/business/event/UserGroupDeletedEvent;", "onUserGroupDeletedEvent$people_api", "onUserGroupMembersUpdatedEvent", "Lde/justsoftware/people/business/event/UserGroupMembersUpdatedEvent;", "onUserGroupMembersUpdatedEvent$people_api", "onUserGroupRolesUpdatedEvent", "Lde/justsoftware/people/business/event/UserGroupRolesUpdatedEvent;", "onUserGroupRolesUpdatedEvent$people_api", "queueReindexInPeopleCore", "searchIds", "", "searchId", "queueFullIndex", "userGroupId", "profileIds", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nSearchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchService.kt\nde/justsoftware/people/business/search/SearchService\n+ 2 CollectionUtils.kt\nde/justsoftware/people/utils/CollectionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,326:1\n17#2:327\n17#2:331\n1628#3,3:328\n1628#3,3:332\n808#3,11:335\n808#3,11:346\n1557#3:357\n1628#3,3:358\n1557#3:361\n1628#3,3:362\n1863#3,2:365\n1557#3:367\n1628#3,3:368\n*S KotlinDebug\n*F\n+ 1 SearchService.kt\nde/justsoftware/people/business/search/SearchService\n*L\n121#1:327\n207#1:331\n121#1:328,3\n207#1:332,3\n208#1:335,11\n209#1:346,11\n215#1:357\n215#1:358,3\n221#1:361\n221#1:362,3\n293#1:365,2\n310#1:367\n310#1:368,3\n*E\n"})
public class SearchService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SolrIntegration solrIntegration;
    @NotNull
    private final ProfileAttributeConfigService profileAttributeConfigService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final VisibilityService visibilityService;
    @NotNull
    private final SolrIndexQueue solrIndexQueue;
    @NotNull
    private final UserGroupMemberRepository userGroupMemberRepository;
    @NotNull
    private final KafkaCleaningProducer<String, String> kafkaProducer;
    @NotNull
    public static final String PEOPLE_SEARCH_INDEX_TOPIC = "just.people.search.index";
    @NotNull
    public static final String SEARCH_INDEX_LISTENER_ID = "SearchIndexConsumer";
    private static final Logger LOG = LoggerFactory.getLogger(SearchService.class);

    public SearchService(@NotNull SolrIntegration solrIntegration, @NotNull ProfileAttributeConfigService profileAttributeConfigService, @NotNull ProfileService profileService, @NotNull UserGroupService userGroupService, @NotNull VisibilityService visibilityService, @NotNull SolrIndexQueue solrIndexQueue, @NotNull UserGroupMemberRepository userGroupMemberRepository, @Qualifier(value="KAFKA_STRING_PRODUCER") @NotNull KafkaCleaningProducer<String, String> kafkaProducer) {
        Intrinsics.checkNotNullParameter((Object)solrIntegration, (String)"solrIntegration");
        Intrinsics.checkNotNullParameter((Object)profileAttributeConfigService, (String)"profileAttributeConfigService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)visibilityService, (String)"visibilityService");
        Intrinsics.checkNotNullParameter((Object)solrIndexQueue, (String)"solrIndexQueue");
        Intrinsics.checkNotNullParameter((Object)userGroupMemberRepository, (String)"userGroupMemberRepository");
        Intrinsics.checkNotNullParameter(kafkaProducer, (String)"kafkaProducer");
        this.solrIntegration = solrIntegration;
        this.profileAttributeConfigService = profileAttributeConfigService;
        this.profileService = profileService;
        this.userGroupService = userGroupService;
        this.visibilityService = visibilityService;
        this.solrIndexQueue = solrIndexQueue;
        this.userGroupMemberRepository = userGroupMemberRepository;
        this.kafkaProducer = kafkaProducer;
    }

    @NotNull
    public PagedResult<ProfileSearchReadModel> allProfiles(@Nullable TenantId tenantId, @NotNull String searchString, @NotNull List<? extends SearchFilter> searchFilter, @NotNull Set<Role> searchRoles, @Nullable FacetFilter facetFilter, @Nullable UserGroupId groupId, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        Intrinsics.checkNotNullParameter(searchFilter, (String)"searchFilter");
        Intrinsics.checkNotNullParameter(searchRoles, (String)"searchRoles");
        return this.solrIntegration.allProfiles(tenantId, searchString, searchFilter, searchRoles, facetFilter, groupId, offset, limit);
    }

    @NotNull
    public PagedResult<ProfileSearchReadModel> birthdayList(@NotNull TenantId tenantId, @NotNull LocalDate currentDate, @NotNull Set<Role> searchRoles, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)currentDate, (String)"currentDate");
        Intrinsics.checkNotNullParameter(searchRoles, (String)"searchRoles");
        return this.solrIntegration.birthdayList(tenantId, currentDate, searchRoles, offset, limit);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PagedResult<ProfileSearchReadModel> profilesInUserGroup(@NotNull UserGroupId groupId, int offset, int limit, boolean isTenantAdmin) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        OffsetBasedPageRequest pageRequest = new OffsetBasedPageRequest((long)offset, limit, null, 4, null);
        Page profileIds = isTenantAdmin ? this.userGroupMemberRepository.findByUserGroupId((UUID)groupId.getId(), (Pageable)pageRequest) : this.userGroupMemberRepository.findActiveByUserGroupId((UUID)groupId.getId(), (Pageable)pageRequest);
        Iterable iterable = (Iterable)profileIds;
        SolrIntegration solrIntegration = this.solrIntegration;
        boolean $i$f$mapToSet = false;
        void var10_10 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbUserGroupMember dbUserGroupMember = (DbUserGroupMember)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ProfileId(it.getProfileId()));
        }
        PagedResult profiles = solrIntegration.getProfiles((Set)destination$iv$iv);
        return new PagedResult((long)offset, profileIds.getTotalElements(), profiles.getRows());
    }

    @NotNull
    public PagedResult<SearchModel> allProfilesAndUserGroups(@Nullable TenantId tenantId, @NotNull String searchString, @NotNull Set<Role> searchRoles, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        Intrinsics.checkNotNullParameter(searchRoles, (String)"searchRoles");
        return this.solrIntegration.allProfilesAndUserGroups(tenantId, searchString, searchRoles, offset, limit);
    }

    @Nullable
    public ProfileSearchReadModel findProfile(@NotNull ProfileId profileId, @NotNull Set<Role> searchRoles) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter(searchRoles, (String)"searchRoles");
        return this.solrIntegration.findProfile(profileId, searchRoles);
    }

    @NotNull
    public PagedResult<SearchModel> searchInNames(@NotNull TenantId tenantId, @NotNull String searchString, @NotNull Set<Role> searchRoles, @NotNull Set<String> types, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        Intrinsics.checkNotNullParameter(searchRoles, (String)"searchRoles");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        return this.solrIntegration.searchInNames(tenantId, searchString, searchRoles, types, offset, limit);
    }

    @NotNull
    public List<SearchField> getSearchableFields() {
        return this.profileAttributeConfigService.searchFields();
    }

    @NotNull
    public List<ProfileAttributeConfig> getSearchConfiguration() {
        return CollectionsKt.toList((Iterable)this.profileAttributeConfigService.getConfiguration().values());
    }

    @NotNull
    public Optional<ProfileAttributeConfig> getSearchConfiguration(@NotNull SearchField searchField) {
        Intrinsics.checkNotNullParameter((Object)searchField, (String)"searchField");
        return this.profileAttributeConfigService.configFor(searchField);
    }

    public void reindexAllGroups() {
        this.solrIntegration.deleteAllUserGroups();
        this.userGroupService.forAllUserGroups(arg_0 -> SearchService.reindexAllGroups$lambda$1(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="SearchIndexConsumer", containerFactory="searchIndexQueueConsumerFactory", topics={"just.people.search.index"}, idIsGroup=false)
    public void onSearchIndex$people_api(@NotNull ConsumerRecords<SearchId, String> records) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        LOG.debug("Update Solr for {} records", (Object)records.count());
        Iterable $this$mapToSet$iv = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Iterable destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void p0;
            ConsumerRecord consumerRecord = (ConsumerRecord)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((SearchId)p0.key());
        }
        Set searchIds = (Set)destination$iv$iv;
        Iterable $this$filterIsInstance$iv = searchIds;
        boolean $i$f$filterIsInstance = false;
        destination$iv$iv = $this$filterIsInstance$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof ProfileId)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set profileIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Iterable $this$filterIsInstance$iv2 = searchIds;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv2 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UserGroupId)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        Set userGroupIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
        Map visibilities = this.visibilityService.visibilities(searchIds);
        Map profiles = this.profileService.findUndeletedProfileByIds((Iterable)profileIds);
        Map profileUserGroupIds = this.userGroupService.getUserGroupsForProfiles(profiles.keySet());
        Map userGroups = this.userGroupService.findAllByIds(userGroupIds);
        Set deletedSearchIds = SetsKt.minus((Set)SetsKt.minus((Set)searchIds, (Iterable)profiles.keySet()), (Iterable)userGroups.keySet());
        Iterable $this$map$iv = profiles.values();
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Iterable destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Profile profile = (Profile)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            List list = (List)profileUserGroupIds.get(it.getId());
            Collection collection2 = (Collection)visibilities.get(it.getId());
            collection.add(Profile.Companion.toProfileSearchIndexModel((Profile)it, list != null ? CollectionsKt.toSet((Iterable)list) : null, collection2 != null ? CollectionsKt.toSet((Iterable)collection2) : null));
        }
        List profileSearchIndexModels = (List)destination$iv$iv4;
        Iterable $this$map$iv2 = userGroups.values();
        boolean $i$f$map2 = false;
        destination$iv$iv4 = $this$map$iv2;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserGroup bl = (UserGroup)item$iv$iv;
            collection = destination$iv$iv5;
            boolean bl2 = false;
            UserGroupId userGroupId = it.getId();
            String string = it.getName();
            TenantId tenantId = it.getTenantId();
            boolean bl3 = it.isImported();
            boolean bl4 = it.isAllTenantUsers();
            Collection collection3 = (Collection)visibilities.get(it.getId());
            if (collection3 == null || (collection3 = CollectionsKt.toSet((Iterable)collection3)) == null) {
                collection3 = SetsKt.emptySet();
            }
            collection.add(new UserGroupSearchIndexModel(userGroupId, string, tenantId, bl3, bl4, (Set)collection3));
        }
        List userGroupSearchIndexModel = (List)destination$iv$iv5;
        this.solrIntegration.delete(deletedSearchIds);
        this.solrIntegration.index((Iterable)CollectionsKt.plus((Collection)profileSearchIndexModels, (Iterable)userGroupSearchIndexModel));
        Object[] objectArray = new Object[]{profileSearchIndexModels.size(), userGroupSearchIndexModel.size(), deletedSearchIds.size()};
        LOG.info("Updating Solr with {} profiles and {} groups. Deleting {} profiles and groups.", objectArray);
    }

    @EventListener
    public void onProfilesUpdatedEvent$people_api(@NotNull ProfilesUpdatedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.queueReindexInPeopleCore((Collection)e.getUpdatedProfiles());
        this.queueFullIndex((Collection)e.getUpdatedProfiles());
    }

    @EventListener
    public void onProfilesCreatedEvent$people_api(@NotNull ProfilesCreatedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.queueFullIndex((Collection)e.getCreatedProfiles().keySet());
    }

    @EventListener
    public void onProfilesDeletedEvent$people_api(@NotNull ProfilesDeletedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.queueReindexInPeopleCore((Collection)e.getProfileIds());
        this.queueFullIndex((Collection)e.getProfileIds());
    }

    @EventListener
    public void onUserGroupCreatedOrPublishedEvent$people_api(@NotNull UserGroupCreatedOrPublishedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.queueReindexInPeopleCore((SearchId)e.getUserGroupId());
        this.queueFullIndex(e.getUserGroupId());
    }

    @EventListener
    public void onUserGroupUpdatedEvent$people_api(@NotNull UserGroupUpdatedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.queueReindexInPeopleCore((SearchId)e.getUserGroupId());
        this.queueFullIndex(e.getUserGroupId());
    }

    @EventListener
    public void onUserGroupDeletedEvent$people_api(@NotNull UserGroupDeletedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.queueReindexInPeopleCore((Collection)SetsKt.plus((Set)SetsKt.setOf((Object)e.getUserGroupId()), (Iterable)e.getGroupMembers()));
        this.queueFullIndex((Collection)e.getGroupMembers());
        this.queueFullIndex(e.getUserGroupId());
    }

    @EventListener
    public void onUserGroupMembersUpdatedEvent$people_api(@NotNull UserGroupMembersUpdatedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.queueReindexInPeopleCore((Collection)SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.setOf((Object)e.getUserGroupId()), (Iterable)e.getAddedMembers()), (Iterable)e.getDeletedMembers()));
        this.queueFullIndex((Collection)SetsKt.plus((Set)e.getAddedMembers(), (Iterable)e.getDeletedMembers()));
        this.queueFullIndex(e.getUserGroupId());
    }

    @EventListener
    public void onUserGroupRolesUpdatedEvent$people_api(@NotNull UserGroupRolesUpdatedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.queueReindexInPeopleCore((Collection)SetsKt.plus((Set)SetsKt.setOf((Object)e.getUserGroupId()), (Iterable)e.getGroupMembers()));
        this.queueFullIndex(e.getUserGroupId());
        this.queueFullIndex((Collection)e.getGroupMembers());
    }

    private void queueReindexInPeopleCore(Collection<? extends SearchId> searchIds) {
        Iterable $this$forEach$iv = searchIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SearchId p0 = (SearchId)element$iv;
            boolean bl = false;
            this.queueReindexInPeopleCore(p0);
        }
    }

    private void queueReindexInPeopleCore(SearchId searchId) {
        this.kafkaProducer.send(new ProducerRecord("just.people.search.index", (Object)searchId.toCanonicalId(), (Object)""), SearchService::queueReindexInPeopleCore$lambda$5);
    }

    private void queueFullIndex(UserGroupId userGroupId) {
        this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)userGroupId.toSearchableId()), SearchType.USER_GROUP);
    }

    /*
     * WARNING - void declaration
     */
    private void queueFullIndex(Collection<ProfileId> profileIds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = profileIds;
        SolrIndexQueue solrIndexQueue = this.solrIndexQueue;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProfileId profileId = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toSearchableId());
        }
        solrIndexQueue.queueFullIndex((List)destination$iv$iv, SearchType.PROFILE);
    }

    private static final void reindexAllGroups$lambda$1(SearchService this$0, UserGroup userGroup) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        this$0.queueReindexInPeopleCore((SearchId)userGroup.getId());
    }

    private static final void queueReindexInPeopleCore$lambda$5(RecordMetadata metadata, Exception exception) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Companion.access$logErrorCallback((Companion)Companion, (RecordMetadata)metadata, (Exception)exception);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }
}

