/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.application.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SearchFilterModel {
    private static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper();
    private final String _id;
    private final ImmutableList<String> _values;

    @JsonCreator
    public SearchFilterModel(@JsonProperty(value="id") String id, @JsonProperty(value="values") List<String> values) {
        this._id = Strings.nullToEmpty((String)id);
        this._values = values != null ? (ImmutableList)values.stream().filter(Objects::nonNull).collect(ImmutableList.toImmutableList()) : ImmutableList.of();
    }

    @Nonnull
    public String getId() {
        return this._id;
    }

    @Nonnull
    public ImmutableList<String> getValues() {
        return this._values;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("values", (Object)this._values.toString()).toString();
    }

    @Nonnull
    public static SearchFilterModel parse(String model) {
        try {
            return (SearchFilterModel)JSON_OBJECT_MAPPER.readValue(model, SearchFilterModel.class);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

