/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice;

import de.justsoftware.notificationservice.ExceptionHandlerConfiguration;
import de.justsoftware.notificationservice.exception.NotFoundException;
import de.justsoftware.notificationservice.exception.UnauthorizedException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Configuration
@ControllerAdvice
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0017J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\tH\u0017J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u000bH\u0017\u00a8\u0006\r"}, d2={"Lde/justsoftware/notificationservice/ExceptionHandlerConfiguration;", "", "()V", "handleAllExceptions", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "handleNotFoundException", "Lde/justsoftware/notificationservice/exception/NotFoundException;", "handleUnauthorizedException", "Lde/justsoftware/notificationservice/exception/UnauthorizedException;", "Companion", "notification-service"})
@SourceDebugExtension(value={"SMAP\nExceptionHandlerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionHandlerConfiguration.kt\nde/justsoftware/notificationservice/ExceptionHandlerConfiguration\n+ 2 LoggerUtils.kt\nde/justsoftware/notificationservice/util/LoggerUtilsKt\n*L\n1#1,44:1\n8#2:45\n7#2,3:46\n*S KotlinDebug\n*F\n+ 1 ExceptionHandlerConfiguration.kt\nde/justsoftware/notificationservice/ExceptionHandlerConfiguration\n*L\n40#1:45\n40#1:46,3\n*E\n"})
public class ExceptionHandlerConfiguration {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String DEFAULT_ERROR = "An unexpected error occurred.";

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    @NotNull
    public String handleAllExceptions(@NotNull Exception e) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String it = string = DEFAULT_ERROR;
        boolean bl = false;
        LOG.error("Internal Server Error:", (Throwable)e);
        return string;
    }

    @ExceptionHandler(value={NotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    @Nullable
    public String handleNotFoundException(@NotNull NotFoundException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getMessage();
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    @Nullable
    public String handleUnauthorizedException(@NotNull UnauthorizedException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getMessage();
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

