/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.persistence.model;

import de.justsoftware.permission.client.model.Role;
import de.justsoftware.wikiservice.model.GranteeId;
import de.justsoftware.wikiservice.model.PermissionId;
import de.justsoftware.wikiservice.model.PermissionType;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.model.AuditModel;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Entity
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\n\u0010\u000eR\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lde/justsoftware/wikiservice/persistence/model/Permission;", "Lde/justsoftware/wikiservice/persistence/model/AuditModel;", "id", "Lde/justsoftware/wikiservice/model/PermissionId;", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "type", "Lde/justsoftware/wikiservice/model/PermissionType;", "granteeId", "Lde/justsoftware/wikiservice/model/GranteeId;", "<init>", "(Lde/justsoftware/wikiservice/model/PermissionId;Lde/justsoftware/wikiservice/model/WikiId;Lde/justsoftware/wikiservice/model/PermissionType;Lde/justsoftware/wikiservice/model/GranteeId;)V", "role", "Lde/justsoftware/permission/client/model/Role;", "(Lde/justsoftware/wikiservice/model/WikiId;Lde/justsoftware/wikiservice/model/PermissionType;Lde/justsoftware/permission/client/model/Role;)V", "getId", "()Lde/justsoftware/wikiservice/model/PermissionId;", "setId", "(Lde/justsoftware/wikiservice/model/PermissionId;)V", "getWikiId", "()Lde/justsoftware/wikiservice/model/WikiId;", "setWikiId", "(Lde/justsoftware/wikiservice/model/WikiId;)V", "getType", "()Lde/justsoftware/wikiservice/model/PermissionType;", "setType", "(Lde/justsoftware/wikiservice/model/PermissionType;)V", "getGranteeId", "()Lde/justsoftware/wikiservice/model/GranteeId;", "setGranteeId", "(Lde/justsoftware/wikiservice/model/GranteeId;)V", "wiki-service"})
public final class Permission
extends AuditModel {
    @AttributeOverride(name="id", column=@Column(name="id"))
    @EmbeddedId
    @NotNull
    private PermissionId id;
    @Embedded
    @AttributeOverride(name="id", column=@Column(name="wikiId"))
    @NotNull
    private WikiId wikiId;
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private PermissionType type;
    @Embedded
    @AttributeOverride(name="granteeId", column=@Column(name="granteeId"))
    @NotNull
    private GranteeId granteeId;

    public Permission(@NotNull PermissionId id, @NotNull WikiId wikiId, @NotNull PermissionType type, @NotNull GranteeId granteeId) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        this.id = id;
        this.wikiId = wikiId;
        this.type = type;
        this.granteeId = granteeId;
    }

    @NotNull
    public final PermissionId getId() {
        return this.id;
    }

    public final void setId(@NotNull PermissionId permissionId) {
        Intrinsics.checkNotNullParameter((Object)permissionId, (String)"<set-?>");
        this.id = permissionId;
    }

    @NotNull
    public final WikiId getWikiId() {
        return this.wikiId;
    }

    public final void setWikiId(@NotNull WikiId wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"<set-?>");
        this.wikiId = wikiId;
    }

    @NotNull
    public final PermissionType getType() {
        return this.type;
    }

    public final void setType(@NotNull PermissionType permissionType) {
        Intrinsics.checkNotNullParameter((Object)permissionType, (String)"<set-?>");
        this.type = permissionType;
    }

    @NotNull
    public final GranteeId getGranteeId() {
        return this.granteeId;
    }

    public final void setGranteeId(@NotNull GranteeId granteeId) {
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"<set-?>");
        this.granteeId = granteeId;
    }

    public Permission(@NotNull WikiId wikiId, @NotNull PermissionType type, @NotNull Role role) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        this(new PermissionId(), wikiId, type, GranteeId.Companion.toGranteeId(role));
    }

    public Permission() {
    }
}

