/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.kafka;

import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.UserGroupService;
import de.justsoftware.wikiservice.kafka.UserGroupKafkaConsumer;
import de.justsoftware.wikiservice.model.UserGroupId;
import de.justsoftware.wikiservice.persistence.model.UserGroup;
import de.justsoftware.wikiservice.util.KafkaUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/wikiservice/kafka/UserGroupKafkaConsumer;", "", "userGroupService", "Lde/justsoftware/wikiservice/business/UserGroupService;", "permissionService", "Lde/justsoftware/wikiservice/business/PermissionService;", "<init>", "(Lde/justsoftware/wikiservice/business/UserGroupService;Lde/justsoftware/wikiservice/business/PermissionService;)V", "onUserGroupChanged", "", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "Lde/justsoftware/wikiservice/model/UserGroupId;", "Lde/justsoftware/wikiservice/persistence/model/UserGroup;", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nUserGroupKafkaConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserGroupKafkaConsumer.kt\nde/justsoftware/wikiservice/kafka/UserGroupKafkaConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1863#2,2:56\n*S KotlinDebug\n*F\n+ 1 UserGroupKafkaConsumer.kt\nde/justsoftware/wikiservice/kafka/UserGroupKafkaConsumer\n*L\n31#1:56,2\n*E\n"})
public class UserGroupKafkaConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    public static final String TOPIC = "just.people.userGroup";
    private static final Logger LOG = LoggerFactory.getLogger(UserGroupKafkaConsumer.class);

    @Autowired
    public UserGroupKafkaConsumer(@NotNull UserGroupService userGroupService, @NotNull PermissionService permissionService) {
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        this.userGroupService = userGroupService;
        this.permissionService = permissionService;
    }

    @KafkaListener(id="userGroupConsumer", containerFactory="userGroupConsumerFactory", topics={"just.people.userGroup"}, idIsGroup=false)
    public void onUserGroupChanged(@NotNull ConsumerRecords<UserGroupId, UserGroup> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$forEach$iv = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConsumerRecord record = (ConsumerRecord)element$iv;
            boolean bl = false;
            try {
                UserGroup userGroup = (UserGroup)record.value();
                if (userGroup != null) {
                    this.userGroupService.save(userGroup);
                    continue;
                }
                UserGroupId userGroupId = (UserGroupId)record.key();
                Intrinsics.checkNotNull((Object)userGroupId);
                this.userGroupService.deleteById(userGroupId);
                this.permissionService.deletePermissionsForGrantee(userGroupId.toGranteeId());
            }
            catch (RuntimeException e) {
                LOG.error("Failed to save or update UserGroup with key = " + record.key() + ". Skip this record.", (Throwable)e);
            }
        }
    }
}

