/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.graphql.fetchers;

import de.justsoftware.wikiservice.application.ProfileApplicationService;
import de.justsoftware.wikiservice.application.model.ProfileDto;
import de.justsoftware.wikiservice.application.model.WithUpdatedBy;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.graphql.AuthenticatedGraphQLContext;
import de.justsoftware.wikiservice.graphql.dataloader.DataLoaderFactory;
import de.justsoftware.wikiservice.graphql.dataloader.DataLoaderName;
import de.justsoftware.wikiservice.model.ProfileId;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/wikiservice/graphql/fetchers/ProfileInfoFetcher;", "", "profileApplicationService", "Lde/justsoftware/wikiservice/application/ProfileApplicationService;", "<init>", "(Lde/justsoftware/wikiservice/application/ProfileApplicationService;)V", "profileDataLoaderFactory", "Lde/justsoftware/wikiservice/graphql/dataloader/DataLoaderFactory;", "Lde/justsoftware/wikiservice/model/ProfileId;", "Lde/justsoftware/wikiservice/application/model/ProfileDto;", "getUpdatedBy", "Lgraphql/schema/DataFetcher;", "Ljava/util/concurrent/CompletableFuture;", "getGetUpdatedBy", "()Lgraphql/schema/DataFetcher;", "wiki-service"})
public class ProfileInfoFetcher {
    @NotNull
    private final ProfileApplicationService profileApplicationService;
    @NotNull
    private final DataFetcher<CompletableFuture<ProfileDto>> getUpdatedBy;

    @Autowired
    public ProfileInfoFetcher(@NotNull ProfileApplicationService profileApplicationService) {
        Intrinsics.checkNotNullParameter((Object)profileApplicationService, (String)"profileApplicationService");
        this.profileApplicationService = profileApplicationService;
        this.getUpdatedBy = ProfileInfoFetcher::getUpdatedBy$lambda$1;
    }

    @Bean
    @NotNull
    public DataLoaderFactory<ProfileId, ProfileDto> profileDataLoaderFactory() {
        return new DataLoaderFactory(DataLoaderName.PROFILE_LOADER, (arg_0, arg_1) -> ProfileInfoFetcher.profileDataLoaderFactory$lambda$0(this, arg_0, arg_1));
    }

    @NotNull
    public DataFetcher<CompletableFuture<ProfileDto>> getGetUpdatedBy() {
        return this.getUpdatedBy;
    }

    private static final Map profileDataLoaderFactory$lambda$0(ProfileInfoFetcher this$0, List profileIds, AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)profileIds, (String)"profileIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this$0.profileApplicationService.readByIds(CollectionsKt.toSet((Iterable)profileIds), authContext);
    }

    private static final CompletableFuture getUpdatedBy$lambda$1(DataFetchingEnvironment env) {
        Object object = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        WithUpdatedBy updated = (WithUpdatedBy)object;
        Object object2 = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object2;
        DataLoader dataLoader = context.getDataLoader(DataLoaderName.PROFILE_LOADER);
        return dataLoader.load((Object)updated.getUpdatedBy());
    }
}

