/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.controller;

import de.justsoftware.wikiservice.application.SubscriptionApplicationService;
import de.justsoftware.wikiservice.application.model.SubscriptionDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.ArticleApplicationService;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.ChapterApplicationService;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.GlobalConfigApplicationService;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.WikiApplicationService;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.WikiOverviewApplicationService;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.ArticleDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.ArticleHeadingDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.ArticleVersionDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.ChapterDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.ContentCountDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.CreateWikiDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.GlobalConfigDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.PreviewDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.WikiDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.WikiOverviewConfigDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.WikiPreviewDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.controller.WikiController;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ArticleVersionId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.model.WikiOverview;
import de.justsoftware.wikiservice.util.IdUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001:\u0004MNOPB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ$\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u001a\u0010\u0018\u001a\u00020\u00112\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J$\u0010\u001b\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0019\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J$\u0010\u001d\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0019\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u001a\u0010\u001f\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J \u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J6\u0010#\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010&\u001a\u00020'2\b\b\u0001\u0010(\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u001a\u0010)\u001a\u00020\u00152\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u001a\u0010*\u001a\u00020\u00152\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u001a\u0010+\u001a\u00020\u00112\b\b\u0001\u0010,\u001a\u00020-2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u001a\u0010.\u001a\u00020/2\b\b\u0001\u00100\u001a\u0002012\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u001a\u00102\u001a\u0002032\b\b\u0001\u00104\u001a\u0002052\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0010\u00106\u001a\u0002072\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u001a\u00108\u001a\u0002092\b\b\u0001\u0010:\u001a\u0002092\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J>\u0010;\u001a\b\u0012\u0004\u0012\u00020<0$2\b\b\u0001\u0010&\u001a\u00020'2\b\b\u0001\u0010(\u001a\u00020'2\b\b\u0001\u0010=\u001a\u00020>2\b\b\u0001\u0010?\u001a\u00020@2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u001a\u0010A\u001a\u00020B2\b\b\u0001\u0010C\u001a\u00020D2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u001a\u0010E\u001a\u00020B2\b\b\u0001\u0010F\u001a\u00020G2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u001a\u0010H\u001a\u00020I2\b\b\u0001\u0010F\u001a\u00020G2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u001a\u0010J\u001a\u00020I2\b\b\u0001\u00100\u001a\u0002012\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J0\u0010K\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030L0$2\b\b\u0001\u0010&\u001a\u00020'2\b\b\u0001\u0010(\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lde/justsoftware/wikiservice/controller/WikiController;", "", "articleApplicationService", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/ArticleApplicationService;", "subscriptionApplicationService", "Lde/justsoftware/wikiservice/application/SubscriptionApplicationService;", "globalConfigApplicationService", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/GlobalConfigApplicationService;", "wikiOverviewApplicationService", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/WikiOverviewApplicationService;", "wikiApplicationService", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/WikiApplicationService;", "chapterApplicationService", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/ChapterApplicationService;", "<init>", "(Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/ArticleApplicationService;Lde/justsoftware/wikiservice/application/SubscriptionApplicationService;Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/GlobalConfigApplicationService;Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/WikiOverviewApplicationService;Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/WikiApplicationService;Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/ChapterApplicationService;)V", "getArticle", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/ArticleDto;", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "preferDraft", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "createArticle", "articleInfo", "Lde/justsoftware/wikiservice/controller/WikiController$CreateArticle;", "updateArticle", "Lde/justsoftware/wikiservice/controller/WikiController$UpdateArticle;", "moveArticle", "Lde/justsoftware/wikiservice/controller/WikiController$MoveArticle;", "deleteArticle", "getArticleHeadings", "", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/ArticleHeadingDto;", "getVersionHistoryForArticle", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/ArticleVersionDto;", "page", "", "pageSize", "updateEditingTokenForArticle", "deleteEditingTokenForArticle", "getArticleVersion", "articleVersionId", "Lde/justsoftware/wikiservice/model/ArticleVersionId;", "getChapter", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/ChapterDto;", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "createOrUpdateSubscription", "Lde/justsoftware/wikiservice/application/model/SubscriptionDto;", "subscriptionInfo", "Lde/justsoftware/wikiservice/controller/WikiController$CreateOrUpdateSubscription;", "getGlobalConfig", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/GlobalConfigDto;", "changeOverviewConfig", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/WikiOverviewConfigDto;", "configDto", "getWikiPreviews", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/WikiPreviewDto;", "sortKey", "Lde/justsoftware/wikiservice/persistence/model/WikiOverview$Companion$Sort;", "sortDirection", "Lde/justsoftware/wikiservice/persistence/model/WikiOverview$Companion$Direction;", "createWiki", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/WikiDto;", "wiki", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/CreateWikiDto;", "getWiki", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "getWikiContentCount", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/ContentCountDto;", "getChapterContentCount", "getSubscribedItems", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/PreviewDto;", "CreateArticle", "UpdateArticle", "MoveArticle", "CreateOrUpdateSubscription", "wiki-service"})
public class WikiController {
    @NotNull
    private final ArticleApplicationService articleApplicationService;
    @NotNull
    private final SubscriptionApplicationService subscriptionApplicationService;
    @NotNull
    private final GlobalConfigApplicationService globalConfigApplicationService;
    @NotNull
    private final WikiOverviewApplicationService wikiOverviewApplicationService;
    @NotNull
    private final WikiApplicationService wikiApplicationService;
    @NotNull
    private final ChapterApplicationService chapterApplicationService;

    public WikiController(@NotNull ArticleApplicationService articleApplicationService, @NotNull SubscriptionApplicationService subscriptionApplicationService, @NotNull GlobalConfigApplicationService globalConfigApplicationService, @NotNull WikiOverviewApplicationService wikiOverviewApplicationService, @NotNull WikiApplicationService wikiApplicationService, @NotNull ChapterApplicationService chapterApplicationService) {
        Intrinsics.checkNotNullParameter((Object)articleApplicationService, (String)"articleApplicationService");
        Intrinsics.checkNotNullParameter((Object)subscriptionApplicationService, (String)"subscriptionApplicationService");
        Intrinsics.checkNotNullParameter((Object)globalConfigApplicationService, (String)"globalConfigApplicationService");
        Intrinsics.checkNotNullParameter((Object)wikiOverviewApplicationService, (String)"wikiOverviewApplicationService");
        Intrinsics.checkNotNullParameter((Object)wikiApplicationService, (String)"wikiApplicationService");
        Intrinsics.checkNotNullParameter((Object)chapterApplicationService, (String)"chapterApplicationService");
        this.articleApplicationService = articleApplicationService;
        this.subscriptionApplicationService = subscriptionApplicationService;
        this.globalConfigApplicationService = globalConfigApplicationService;
        this.wikiOverviewApplicationService = wikiOverviewApplicationService;
        this.wikiApplicationService = wikiApplicationService;
        this.chapterApplicationService = chapterApplicationService;
    }

    @GetMapping(value={"/articles/{articleId}"})
    @NotNull
    public ArticleDto getArticle(@PathVariable(value="articleId") @NotNull ArticleId articleId, @RequestParam(value="preferDraft", required=false) boolean preferDraft, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.read(articleId, preferDraft, authContext);
    }

    @PostMapping(value={"/articles"})
    @NotNull
    public ArticleDto createArticle(@RequestBody @NotNull CreateArticle articleInfo, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleInfo, (String)"articleInfo");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.create(IdUtilsKt.parentIdOf((String)articleInfo.getParentId()), articleInfo.getTitle(), articleInfo.getContent(), articleInfo.getTextContent(), articleInfo.isDraft(), authContext);
    }

    @PutMapping(value={"/articles/{articleId}"})
    @NotNull
    public ArticleDto updateArticle(@PathVariable(value="articleId") @NotNull ArticleId articleId, @RequestBody @NotNull UpdateArticle articleInfo, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)articleInfo, (String)"articleInfo");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.update(articleId, articleInfo.getTitle(), articleInfo.getContent(), articleInfo.getTextContent(), articleInfo.isDraft(), authContext);
    }

    @PutMapping(value={"/articles/{articleId}/move"})
    @NotNull
    public ArticleDto moveArticle(@PathVariable(value="articleId") @NotNull ArticleId articleId, @RequestBody @NotNull MoveArticle articleInfo, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)articleInfo, (String)"articleInfo");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.move(articleId, IdUtilsKt.parentIdOf((String)articleInfo.getParentId()), authContext);
    }

    @DeleteMapping(value={"/articles/{articleId}"})
    @NotNull
    public ArticleDto deleteArticle(@PathVariable(value="articleId") @NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.delete(articleId, authContext);
    }

    @GetMapping(value={"/articleHeadings/{articleId}"})
    @NotNull
    public List<ArticleHeadingDto> getArticleHeadings(@PathVariable(value="articleId") @NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.readHeadingsOfArticle(articleId, authContext);
    }

    @GetMapping(value={"/articles/{articleId}/versionHistory"})
    @Nullable
    public Page<ArticleVersionDto> getVersionHistoryForArticle(@PathVariable(value="articleId") @NotNull ArticleId articleId, @RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="pageSize", required=false, defaultValue="30") int pageSize, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.readArticleVersions(articleId, page, pageSize, authContext);
    }

    @PutMapping(value={"/articles/{articleId}/token"})
    public boolean updateEditingTokenForArticle(@PathVariable(value="articleId") @NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.updateEditingToken(articleId, authContext);
    }

    @DeleteMapping(value={"/articles/{articleId}/token"})
    public boolean deleteEditingTokenForArticle(@PathVariable(value="articleId") @NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.deleteEditingToken(articleId, authContext);
    }

    @GetMapping(value={"/articleVersions/{articleVersionId}"})
    @NotNull
    public ArticleDto getArticleVersion(@PathVariable(value="articleVersionId") @NotNull ArticleVersionId articleVersionId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleVersionId, (String)"articleVersionId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.readArticleByVersionId(articleVersionId, authContext);
    }

    @GetMapping(value={"/chapters/{chapterId}"})
    @NotNull
    public ChapterDto getChapter(@PathVariable(value="chapterId") @NotNull ChapterId chapterId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chapterApplicationService.read(chapterId, authContext);
    }

    @PutMapping(value={"/subscriptions"})
    @NotNull
    public SubscriptionDto createOrUpdateSubscription(@RequestBody @NotNull CreateOrUpdateSubscription subscriptionInfo, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)subscriptionInfo, (String)"subscriptionInfo");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.subscriptionApplicationService.setSubscription(IdUtilsKt.itemIdOf((String)subscriptionInfo.getItemId()), subscriptionInfo.isSubscribed(), authContext);
    }

    @GetMapping(value={"/globalConfig"})
    @NotNull
    public GlobalConfigDto getGlobalConfig(@NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.globalConfigApplicationService.getGlobalConfig(authContext);
    }

    @PutMapping(value={"/overviewConfig"})
    @NotNull
    public WikiOverviewConfigDto changeOverviewConfig(@RequestBody @NotNull WikiOverviewConfigDto configDto, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)configDto, (String)"configDto");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.wikiOverviewApplicationService.setWikiOverviewConfig(configDto.getKey(), configDto.getDirection(), configDto.getDisplay(), authContext);
    }

    @GetMapping(value={"/wikiPreviews"})
    @NotNull
    public Page<WikiPreviewDto> getWikiPreviews(@RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="pageSize", required=false, defaultValue="30") int pageSize, @RequestParam(value="sortKey", required=false, defaultValue="TITLE") @NotNull WikiOverview.Companion.Sort sortKey, @RequestParam(value="sortDirection", required=false, defaultValue="ASCENDING") @NotNull WikiOverview.Companion.Direction sortDirection, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)sortKey, (String)"sortKey");
        Intrinsics.checkNotNullParameter((Object)sortDirection, (String)"sortDirection");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.wikiApplicationService.getWikiList(page, pageSize, sortKey, sortDirection, authContext);
    }

    @PostMapping(value={"/wikis"})
    @NotNull
    public WikiDto createWiki(@RequestBody @NotNull CreateWikiDto wiki, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wiki, (String)"wiki");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.wikiApplicationService.create(wiki, authContext);
    }

    @GetMapping(value={"/wikis/{wikiId}"})
    @NotNull
    public WikiDto getWiki(@PathVariable(value="wikiId") @NotNull WikiId wikiId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.wikiApplicationService.read(wikiId, authContext);
    }

    @GetMapping(value={"/wikis/{wikiId}/contentCount"})
    @NotNull
    public ContentCountDto getWikiContentCount(@PathVariable(value="wikiId") @NotNull WikiId wikiId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.wikiApplicationService.getContentCount(wikiId, authContext);
    }

    @GetMapping(value={"/chapters/{chapterId}/contentCount"})
    @NotNull
    public ContentCountDto getChapterContentCount(@PathVariable(value="chapterId") @NotNull ChapterId chapterId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chapterApplicationService.getContentCount(chapterId, authContext);
    }

    @GetMapping(value={"/subscribedItems"})
    @NotNull
    public Page<? extends PreviewDto<?>> getSubscribedItems(@RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="pageSize", required=false, defaultValue="30") int pageSize, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.subscriptionApplicationService.getSubscribedItems(page, pageSize, authContext);
    }
}

