/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.permission.client.model.Role;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.SubscriptionService;
import de.justsoftware.wikiservice.business.exceptions.EmptyTitleOrDescriptionException;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.GranteeId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.model.WikiModifiedEvent;
import de.justsoftware.wikiservice.persistence.WikiRepository;
import de.justsoftware.wikiservice.persistence.model.Deletion;
import de.justsoftware.wikiservice.persistence.model.Wiki;
import de.justsoftware.wikiservice.persistence.model.WikiOverview;
import de.justsoftware.wikiservice.persistence.model.WikiPreview;
import de.justsoftware.wikiservice.util.SortUtilsKt;
import de.justsoftware.wikiservice.util.TransactionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001BI\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\"\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00150!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0#H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00150%H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0#H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001f0(H\u0016J4\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00150%2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0#2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J>\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00102\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-2\u0006\u00103\u001a\u00020-2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J<\u00108\u001a\b\u0012\u0004\u0012\u00020\u00150%2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0#2\u0006\u00109\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00150#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J&\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00150%2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0016J.\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00150%2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0016J,\u0010=\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010>\u001a\u0004\u0018\u00010\u00172\b\u0010?\u001a\u0004\u0018\u00010\u00172\u0006\u0010@\u001a\u00020\u001aH\u0017J\u0012\u0010A\u001a\u00020B2\b\u0010C\u001a\u0004\u0018\u00010\u0017H\u0012J\u0018\u0010D\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010E\u001a\u00020FH\u0017J\u0016\u0010G\u001a\u00020H2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020J0#H\u0017J\"\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00150!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0#H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lde/justsoftware/wikiservice/business/WikiService;", "", "wikiRepository", "Lde/justsoftware/wikiservice/persistence/WikiRepository;", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "permissionService", "Lde/justsoftware/wikiservice/business/PermissionService;", "subscriptionService", "Lde/justsoftware/wikiservice/business/SubscriptionService;", "transactionUtils", "Lde/justsoftware/wikiservice/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "<init>", "(Lde/justsoftware/wikiservice/persistence/WikiRepository;Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/PermissionService;Lde/justsoftware/wikiservice/business/SubscriptionService;Lde/justsoftware/wikiservice/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/wikiservice/authorization/AuthorizationService;)V", "create", "Lde/justsoftware/wikiservice/persistence/model/Wiki;", "title", "", "description", "creator", "Lde/justsoftware/wikiservice/model/ProfileId;", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "read", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "readByIds", "", "wikiIds", "", "readAll", "", "readAllIds", "streamAllIds", "Ljava/util/stream/Stream;", "readByRoles", "roles", "Lde/justsoftware/permission/client/model/Role;", "page", "", "limit", "getPreviewPage", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/wikiservice/persistence/model/WikiPreview;", "profileId", "pageSize", "sortKey", "Lde/justsoftware/wikiservice/persistence/model/WikiOverview$Companion$Sort;", "sortDirection", "Lde/justsoftware/wikiservice/persistence/model/WikiOverview$Companion$Direction;", "readByRolesAndSubscriber", "subscriber", "findWikisByTenant", "readByTenant", "readByTenantAndSubscriber", "update", "newTitle", "newDescription", "updater", "isNotNullButEmpty", "", "str", "delete", "deletionId", "Lde/justsoftware/wikiservice/model/DeletionId;", "removeDeletedWikis", "", "deletions", "Lde/justsoftware/wikiservice/persistence/model/Deletion;", "getWikisByIds", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nWikiService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WikiService.kt\nde/justsoftware/wikiservice/business/WikiService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,251:1\n1611#2,9:252\n1863#2:261\n1864#2:263\n1620#2:264\n1557#2:265\n1628#2,3:266\n1557#2:269\n1628#2,3:270\n1557#2:273\n1628#2,3:274\n1611#2,9:277\n1863#2:286\n1864#2:288\n1620#2:289\n1557#2:290\n1628#2,3:291\n1#3:262\n1#3:287\n*S KotlinDebug\n*F\n+ 1 WikiService.kt\nde/justsoftware/wikiservice/business/WikiService\n*L\n93#1:252,9\n93#1:261\n93#1:263\n93#1:264\n102#1:265\n102#1:266,3\n138#1:269\n138#1:270,3\n150#1:273\n150#1:274,3\n235#1:277,9\n235#1:286\n235#1:288\n235#1:289\n243#1:290\n243#1:291,3\n93#1:262\n235#1:287\n*E\n"})
public class WikiService {
    @NotNull
    private final WikiRepository wikiRepository;
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final SubscriptionService subscriptionService;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final AuthorizationService authorizationService;

    @Autowired
    public WikiService(@NotNull WikiRepository wikiRepository, @NotNull ChapterService chapterService, @NotNull ArticleService articleService, @NotNull PermissionService permissionService, @NotNull SubscriptionService subscriptionService, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull AuthorizationService authorizationService) {
        Intrinsics.checkNotNullParameter((Object)wikiRepository, (String)"wikiRepository");
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)subscriptionService, (String)"subscriptionService");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        this.wikiRepository = wikiRepository;
        this.chapterService = chapterService;
        this.articleService = articleService;
        this.permissionService = permissionService;
        this.subscriptionService = subscriptionService;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
        this.authorizationService = authorizationService;
    }

    @Transactional
    @NotNull
    public Wiki create(@NotNull String title, @NotNull String description, @NotNull ProfileId creator, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        if (StringsKt.isBlank((CharSequence)title) || StringsKt.isBlank((CharSequence)description)) {
            throw new EmptyTitleOrDescriptionException();
        }
        Object object = this.wikiRepository.saveAndFlush((Object)new Wiki(new WikiId(), ((Object)StringsKt.trim((CharSequence)title)).toString(), description, tenantId, creator, null));
        Wiki it = (Wiki)object;
        boolean bl = false;
        WikiId wikiId = it.getId();
        this.permissionService.addPermissionItemForNewWiki(wikiId, tenantId);
        this.subscriptionService.setSubscription((ItemId)wikiId, creator, true);
        it = (Wiki)object;
        boolean bl2 = false;
        this.transactionUtils.afterCommit(() -> WikiService.create$lambda$2$lambda$1(this, it));
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
        return (Wiki)object2;
    }

    @Transactional
    @NotNull
    public Wiki read(@NotNull WikiId wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Object object = this.wikiRepository.getReferenceById((Object)wikiId);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getReferenceById(...)");
        return (Wiki)object;
    }

    @NotNull
    public Map<WikiId, Wiki> readByIds(@NotNull Set<WikiId> wikiIds) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        return wikiIds.isEmpty() ? MapsKt.emptyMap() : this.wikiRepository.findByIds(wikiIds);
    }

    @NotNull
    public List<Wiki> readAll() {
        List list = this.wikiRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAll(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<WikiId> readAllIds() {
        void $this$mapNotNullTo$iv$iv;
        List list = this.wikiRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAll(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            WikiId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Wiki it = (Wiki)element$iv$iv;
            boolean bl2 = false;
            if (it.getId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public Stream<WikiId> streamAllIds() {
        return this.wikiRepository.streamAllIds();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Wiki> readByRoles(@NotNull Set<Role> roles, int page, int limit, @NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable iterable = roles;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void r;
            Role role = (Role)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GranteeId.Companion.toGranteeId((Role)r));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        Set set = CollectionsKt.toSet((Iterable)it);
        String[] stringArray = new String[]{"title"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        List<Wiki> list = this.wikiRepository.findAllByPermissionRoles(set, tenantId, (Pageable)pageRequest).get().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<WikiPreview> getPreviewPage(@NotNull ProfileId profileId, int page, int pageSize, @NotNull WikiOverview.Companion.Sort sortKey, @NotNull WikiOverview.Companion.Direction sortDirection, @NotNull TenantId tenantId) {
        Page page2;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)sortKey, (String)"sortKey");
        Intrinsics.checkNotNullParameter((Object)sortDirection, (String)"sortDirection");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        boolean isTenantManager = (Boolean)MapsKt.getValue((Map)this.authorizationService.mayTenantManageWikis(SetsKt.setOf((Object)tenantId), profileId), (Object)tenantId);
        PageRequest pageRequest = PageRequest.of((int)page, (int)pageSize, (Sort)SortUtilsKt.getSort((WikiOverview.Companion.Sort)sortKey, (WikiOverview.Companion.Direction)sortDirection));
        if (isTenantManager) {
            long l = profileId.getId();
            Intrinsics.checkNotNull((Object)pageRequest);
            page2 = this.wikiRepository.findWikiPreviewsByProfileAndTenant(l, tenantId, (Pageable)pageRequest);
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.authorizationService.getUserRoles(profileId);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Role role = (Role)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(GranteeId.Companion.toGranteeId((Role)it));
            }
            Set granteeIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            long l = profileId.getId();
            Intrinsics.checkNotNull((Object)pageRequest);
            page2 = this.wikiRepository.findWikiPreviewsByRolesAndTenantAndProfile(granteeIds, l, tenantId, (Pageable)pageRequest);
        }
        return page2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Wiki> readByRolesAndSubscriber(@NotNull Set<Role> roles, @NotNull ProfileId subscriber, int page, int limit, @NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable iterable = roles;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void r;
            Role role = (Role)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GranteeId.Companion.toGranteeId((Role)r));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        Set set = CollectionsKt.toSet((Iterable)it);
        long l = subscriber.getId();
        String[] stringArray = new String[]{"title"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        List<Wiki> list = this.wikiRepository.findAllByPermissionRolesAndSubscriber(set, tenantId, l, (Pageable)pageRequest).get().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    @NotNull
    public Set<Wiki> findWikisByTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return CollectionsKt.toSet((Iterable)this.wikiRepository.findAllByTenantId(tenantId));
    }

    @NotNull
    public List<Wiki> readByTenant(@NotNull TenantId tenantId, int page, int limit) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        String[] stringArray = new String[]{"title"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        List list = this.wikiRepository.findAllByTenantId(tenantId, (Pageable)pageRequest).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return list;
    }

    @NotNull
    public List<Wiki> readByTenantAndSubscriber(@NotNull TenantId tenantId, @NotNull ProfileId subscriber, int page, int limit) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        long l = subscriber.getId();
        String[] stringArray = new String[]{"title"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        List list = this.wikiRepository.findAllByTenantIdAndSubscriber(tenantId, l, (Pageable)pageRequest).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return list;
    }

    @Transactional
    @NotNull
    public Wiki update(@NotNull WikiId wikiId, @Nullable String newTitle, @Nullable String newDescription, @NotNull ProfileId updater) {
        Wiki wiki;
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        if (this.isNotNullButEmpty(newTitle) || this.isNotNullButEmpty(newDescription)) {
            throw new EmptyTitleOrDescriptionException();
        }
        Wiki it = (Wiki)this.wikiRepository.getReferenceById((Object)wikiId);
        boolean bl = false;
        if (newTitle != null) {
            it.setTitle(((Object)StringsKt.trim((CharSequence)newTitle)).toString());
        }
        if (newDescription != null) {
            it.setDescription(newDescription);
        }
        it.setModifiedBy(updater);
        it = wiki = (Wiki)this.wikiRepository.saveAndFlush((Object)it);
        boolean bl2 = false;
        this.transactionUtils.afterCommit(() -> WikiService.update$lambda$11$lambda$10(this, it));
        Wiki wiki2 = wiki;
        Intrinsics.checkNotNullExpressionValue((Object)wiki2, (String)"also(...)");
        return wiki2;
    }

    private boolean isNotNullButEmpty(String str) {
        return str != null && StringsKt.isBlank((CharSequence)((Object)StringsKt.trim((CharSequence)str)).toString());
    }

    @Transactional
    @NotNull
    public Wiki delete(@NotNull WikiId wikiId, @NotNull DeletionId deletionId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Wiki wiki = this.read(wikiId);
        this.articleService.deleteWikiArticles(wikiId, deletionId);
        this.chapterService.deleteWikiChapters(wikiId, deletionId);
        this.permissionService.removePermissionsForDeletedWiki(wikiId);
        this.wikiRepository.deleteById((Object)wikiId, deletionId);
        this.transactionUtils.afterCommit(() -> WikiService.delete$lambda$12(this, wikiId));
        return wiki;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void removeDeletedWikis(@NotNull Set<Deletion> deletions) {
        void $this$mapTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(deletions, (String)"deletions");
        Iterable $this$mapNotNull$iv = deletions;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<WikiId> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            WikiId it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Deletion it = (Deletion)element$iv$iv;
            boolean bl2 = false;
            if ((it.getItemType() == IdType.WIKI_WIKI ? new WikiId(it.getItemId()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set wikiIdsToRemovePermissionsFrom = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv = deletions;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv = (Deletion)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            DeletionId deletionId = it.getId();
            if (deletionId == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            collection.add(deletionId);
        }
        Set deletionIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        this.permissionService.removePermissionsForWikis(wikiIdsToRemovePermissionsFrom);
        this.wikiRepository.deleteAllByDeletionIds(deletionIds);
    }

    @NotNull
    public Map<WikiId, Wiki> getWikisByIds(@NotNull Set<WikiId> wikiIds) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        return this.wikiRepository.findByIds(wikiIds);
    }

    private static final Unit create$lambda$2$lambda$1(WikiService this$0, Wiki $it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new WikiModifiedEvent($it.getId()));
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$11$lambda$10(WikiService this$0, Wiki $it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new WikiModifiedEvent($it.getId()));
        return Unit.INSTANCE;
    }

    private static final Unit delete$lambda$12(WikiService this$0, WikiId $wikiId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$wikiId, (String)"$wikiId");
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new WikiModifiedEvent($wikiId));
        return Unit.INSTANCE;
    }
}

