/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.application.model.ChapterDto;
import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.exceptions.EmptyChapterTitleException;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.ChapterModifiedEvent;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.ChapterRepository;
import de.justsoftware.wikiservice.persistence.model.Chapter;
import de.justsoftware.wikiservice.util.TransactionUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0017\u0018\u00002\u00020\u0001B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0017J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\"\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aH\u0016J(\u0010#\u001a\u0014\u0012\u0004\u0012\u00020$\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0 2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020$0\u001aH\u0016J\"\u0010&\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00140 2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020'0\u001aH\u0016J0\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u0014H\u0017J,\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u00182\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u00102\u001a\u00020\u00122\b\b\u0002\u00103\u001a\u00020\u001eH\u0017J \u00104\u001a\u0002052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0012H\u0017J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010:\u001a\u0002052\u0006\u0010;\u001a\u00020'2\u0006\u00106\u001a\u000207H\u0017J\u0016\u0010<\u001a\u0002052\f\u0010=\u001a\b\u0012\u0004\u0012\u0002070\u001aH\u0017J\"\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00100 2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lde/justsoftware/wikiservice/business/ChapterService;", "", "chapterRepository", "Lde/justsoftware/wikiservice/persistence/ChapterRepository;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "transactionUtils", "Lde/justsoftware/wikiservice/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "<init>", "(Lde/justsoftware/wikiservice/persistence/ChapterRepository;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/AncestorService;Lde/justsoftware/wikiservice/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;)V", "readBySubscriber", "", "Lde/justsoftware/wikiservice/persistence/model/Chapter;", "subscriber", "Lde/justsoftware/wikiservice/model/ProfileId;", "page", "", "limit", "read", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "readAllIds", "", "streamAllIds", "Ljava/util/stream/Stream;", "exists", "", "readByIds", "", "Lde/justsoftware/wikiservice/application/model/ChapterDto;", "ids", "readByParentIds", "Lde/justsoftware/wikiservice/model/ParentId;", "parentIds", "countByWikiIds", "Lde/justsoftware/wikiservice/model/WikiId;", "wikiIds", "create", "wiki", "parentId", "title", "", "creator", "position", "update", "id", "updater", "chapterWasMoved", "delete", "", "deletionId", "Lde/justsoftware/wikiservice/model/DeletionId;", "deleter", "findDescendantChapterIdsByChapterId", "deleteWikiChapters", "wikiId", "removeDeletedChapters", "deletionIds", "getChaptersByIds", "chapterIds", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nChapterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChapterService.kt\nde/justsoftware/wikiservice/business/ChapterService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n1611#2,9:205\n1863#2:214\n1864#2:216\n1620#2:217\n1187#2,2:218\n1261#2,4:220\n1279#2,2:224\n1293#2,4:226\n1279#2,2:230\n1293#2,4:232\n1557#2:236\n1628#2,3:237\n1557#2:240\n1628#2,3:241\n1202#2,2:244\n1230#2,4:246\n1863#2,2:250\n1863#2,2:252\n1#3:215\n*S KotlinDebug\n*F\n+ 1 ChapterService.kt\nde/justsoftware/wikiservice/business/ChapterService\n*L\n50#1:205,9\n50#1:214\n50#1:216\n50#1:217\n60#1:218,2\n60#1:220,4\n70#1:224,2\n70#1:226,4\n76#1:230,2\n76#1:232,4\n178#1:236\n178#1:237,3\n186#1:240\n186#1:241,3\n202#1:244,2\n202#1:246,4\n168#1:250,2\n190#1:252,2\n50#1:215\n*E\n"})
public class ChapterService {
    @NotNull
    private final ChapterRepository chapterRepository;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final AncestorService ancestorService;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    public ChapterService(@NotNull ChapterRepository chapterRepository, @NotNull ArticleService articleService, @NotNull AncestorService ancestorService, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)chapterRepository, (String)"chapterRepository");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.chapterRepository = chapterRepository;
        this.articleService = articleService;
        this.ancestorService = ancestorService;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Transactional(readOnly=true)
    @NotNull
    public List<Chapter> readBySubscriber(@NotNull ProfileId subscriber, int page, int limit) {
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        long l = subscriber.getId();
        String[] stringArray = new String[]{"id"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        List<Chapter> list = this.chapterRepository.findAllBySubscriber(l, (Pageable)pageRequest).get().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    @Transactional
    @NotNull
    public Chapter read(@NotNull ChapterId chapterId) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Object object = this.chapterRepository.getReferenceById((Object)chapterId);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getReferenceById(...)");
        return (Chapter)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ChapterId> readAllIds() {
        void $this$mapNotNullTo$iv$iv;
        List list = this.chapterRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAll(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ChapterId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Chapter it = (Chapter)element$iv$iv;
            boolean bl2 = false;
            if (it.getId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public Stream<ChapterId> streamAllIds() {
        return this.chapterRepository.streamAllIds();
    }

    @Transactional
    public boolean exists(@NotNull ChapterId chapterId) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        return this.chapterRepository.existsById((Object)chapterId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChapterId, ChapterDto> readByIds(@NotNull Set<ChapterId> ids) {
        Map map;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (ids.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = ChapterRepository.findByIds$default((ChapterRepository)this.chapterRepository, ids, null, (int)2, null);
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                Chapter it = (Chapter)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.getId(), (Object)ChapterDto.Companion.toDto(it));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            map = destination$iv$iv;
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, List<Chapter>> readByParentIds(@NotNull Set<? extends ParentId> parentIds) {
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Map fromDB = ChapterRepository.findByParentIds$default((ChapterRepository)this.chapterRepository, parentIds, null, (int)2, null);
        Iterable $this$associateWith$iv = parentIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            ParentId parentId = (ParentId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            List list = (List)fromDB.get(it);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List list2 = list;
            map.put(t, list2);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<WikiId, Integer> countByWikiIds(@NotNull Set<WikiId> wikiIds) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Map countsByWiki = this.chapterRepository.countByWikiIds(wikiIds);
        Iterable $this$associateWith$iv = wikiIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            WikiId wikiId = (WikiId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Integer n = (int)((Number)countsByWiki.getOrDefault(it, 0L)).longValue();
            map.put(t, n);
        }
        return MapsKt.toMap((Map)result$iv);
    }

    @Transactional
    @NotNull
    public Chapter create(@NotNull WikiId wiki, @NotNull ParentId parentId, @NotNull String title, @NotNull ProfileId creator, int position) {
        Intrinsics.checkNotNullParameter((Object)wiki, (String)"wiki");
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        if (StringsKt.isBlank((CharSequence)title)) {
            throw new EmptyChapterTitleException();
        }
        ChapterId chapterId = new ChapterId();
        String string = StringUtils.normalizeSpace((String)title);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalizeSpace(...)");
        Object object = this.chapterRepository.saveAndFlush((Object)new Chapter(chapterId, wiki, parentId, string, creator, null, Integer.valueOf(position), 32, null));
        Chapter it = (Chapter)object;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        Instant instant = it.getUpdatedAt();
        if (instant == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        this.ancestorService.updateEditedStatusForAncestors(Chapter.Companion.getParent(it), instant, it.getModifiedBy());
        this.transactionUtils.afterCommit(() -> ChapterService.create$lambda$5$lambda$4(this, it));
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
        return (Chapter)object2;
    }

    @Transactional
    @NotNull
    public Chapter update(@NotNull ChapterId id, @Nullable String title, @NotNull ProfileId updater, boolean chapterWasMoved) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        if (title != null && StringsKt.isBlank((CharSequence)title)) {
            throw new EmptyChapterTitleException();
        }
        Chapter chapter = (Chapter)this.chapterRepository.getReferenceById((Object)id);
        if ((title == null || Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)title)).toString(), (Object)chapter.getTitle())) && !chapterWasMoved) {
            Intrinsics.checkNotNull((Object)chapter);
            return chapter;
        }
        if (title != null) {
            chapter.setTitle(StringUtils.normalizeSpace((String)title));
        }
        chapter.setModifiedBy(updater);
        Object object = this.chapterRepository.saveAndFlush((Object)chapter);
        Chapter it = (Chapter)object;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        ParentId parentId = Chapter.Companion.getParent(it);
        Instant instant = it.getUpdatedAt();
        Intrinsics.checkNotNull((Object)instant);
        this.ancestorService.updateEditedStatusForAncestors(parentId, instant, it.getModifiedBy());
        this.transactionUtils.afterCommit(() -> ChapterService.update$lambda$7$lambda$6(this, it));
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
        return (Chapter)object2;
    }

    public static /* synthetic */ Chapter update$default(ChapterService chapterService, ChapterId chapterId, String string, ProfileId profileId, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return chapterService.update(chapterId, string, profileId, bl);
    }

    @Transactional
    public void delete(@NotNull ChapterId chapterId, @NotNull DeletionId deletionId, @NotNull ProfileId deleter) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Intrinsics.checkNotNullParameter((Object)deleter, (String)"deleter");
        Chapter chapterToDelete = (Chapter)this.chapterRepository.getReferenceById((Object)chapterId);
        Intrinsics.checkNotNull((Object)chapterToDelete);
        ParentId parentId = Chapter.Companion.getParent(chapterToDelete);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.ancestorService.updateEditedStatusForAncestors(parentId, instant, deleter);
        Set descendantChapterIds = this.findDescendantChapterIdsByChapterId(chapterId);
        Set toDeletedChapterIds = CollectionsKt.union((Iterable)SetsKt.setOf((Object)chapterId), (Iterable)descendantChapterIds);
        this.chapterRepository.deleteByIds(toDeletedChapterIds, deletionId);
        this.transactionUtils.afterCommit(() -> ChapterService.delete$lambda$9(toDeletedChapterIds, this));
        this.articleService.deleteByParentIds(toDeletedChapterIds, deletionId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ChapterId> findDescendantChapterIdsByChapterId(@NotNull ChapterId chapterId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Iterable $this$map$iv = this.chapterRepository.findAllDescendantChapterIds(chapterId.getId());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UUID uUID = (UUID)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ChapterId((UUID)it));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void deleteWikiChapters(@NotNull WikiId wikiId, @NotNull DeletionId deletionId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Iterable iterable = this.chapterRepository.deleteByWikiId(wikiId, deletionId);
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Chapter chapter = (Chapter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set deletedChapters = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.transactionUtils.afterCommit(() -> ChapterService.deleteWikiChapters$lambda$13(deletedChapters, this));
    }

    @Transactional
    public void removeDeletedChapters(@NotNull Set<DeletionId> deletionIds) {
        Intrinsics.checkNotNullParameter(deletionIds, (String)"deletionIds");
        this.chapterRepository.deleteAllByDeletionIds(deletionIds);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChapterId, Chapter> getChaptersByIds(@NotNull Set<ChapterId> chapterIds) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(chapterIds, (String)"chapterIds");
        Iterable $this$associateBy$iv = ChapterRepository.findByIds$default((ChapterRepository)this.chapterRepository, chapterIds, null, (int)2, null);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Chapter chapter = (Chapter)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getId(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    private static final Unit create$lambda$5$lambda$4(ChapterService this$0, Chapter $it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ChapterModifiedEvent($it.getId()));
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$7$lambda$6(ChapterService this$0, Chapter $it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ChapterModifiedEvent($it.getId()));
        return Unit.INSTANCE;
    }

    private static final Unit delete$lambda$9(Set $toDeletedChapterIds, ChapterService this$0) {
        Intrinsics.checkNotNullParameter((Object)$toDeletedChapterIds, (String)"$toDeletedChapterIds");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $toDeletedChapterIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChapterId it = (ChapterId)element$iv;
            boolean bl = false;
            this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ChapterModifiedEvent(it));
        }
        return Unit.INSTANCE;
    }

    private static final Unit deleteWikiChapters$lambda$13(Set $deletedChapters, ChapterService this$0) {
        Intrinsics.checkNotNullParameter((Object)$deletedChapters, (String)"$deletedChapters");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $deletedChapters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChapterId it = (ChapterId)element$iv;
            boolean bl = false;
            this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ChapterModifiedEvent(it));
        }
        return Unit.INSTANCE;
    }
}

