/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.business.ArticleService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!test"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lde/justsoftware/wikiservice/business/ArticleHeadingMigrationHealthIndicator;", "Lorg/springframework/boot/actuate/health/AbstractHealthIndicator;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "<init>", "(Lde/justsoftware/wikiservice/business/ArticleService;)V", "doHealthCheck", "", "builder", "Lorg/springframework/boot/actuate/health/Health$Builder;", "wiki-service"})
public class ArticleHeadingMigrationHealthIndicator
extends AbstractHealthIndicator {
    @NotNull
    private final ArticleService articleService;

    @Autowired
    public ArticleHeadingMigrationHealthIndicator(@NotNull ArticleService articleService) {
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        this.articleService = articleService;
    }

    protected void doHealthCheck(@NotNull Health.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        try {
            boolean isFullyMigrated = this.articleService.articlesHeadersFullyMigrated();
            Status articlesHeadersMigrationStatus = isFullyMigrated ? Status.UP : Status.DOWN;
            builder.status(articlesHeadersMigrationStatus).withDetail("Migration Finished", (Object)isFullyMigrated);
        }
        catch (Exception e) {
            builder.status(Status.DOWN).withDetail("error", (Object)e.getMessage());
        }
    }
}

