/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater;

import de.justsoftware.wikiservice.application.model.ProfileDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.PermissionApplicationService;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.ContentCountDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.CreateWikiDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.WikiDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.WikiPreviewDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.ProfileService;
import de.justsoftware.wikiservice.business.SubscriptionService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.model.Profile;
import de.justsoftware.wikiservice.persistence.model.Subscription;
import de.justsoftware.wikiservice.persistence.model.Wiki;
import de.justsoftware.wikiservice.persistence.model.WikiOverview;
import de.justsoftware.wikiservice.persistence.model.WikiPreview;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="WikiApplicationServiceForNewRestEndpoint")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J6\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/WikiApplicationService;", "", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "profileService", "Lde/justsoftware/wikiservice/business/ProfileService;", "permissionApplicationService", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/PermissionApplicationService;", "subscriptionService", "Lde/justsoftware/wikiservice/business/SubscriptionService;", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "<init>", "(Lde/justsoftware/wikiservice/business/WikiService;Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/ProfileService;Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/PermissionApplicationService;Lde/justsoftware/wikiservice/business/SubscriptionService;Lde/justsoftware/wikiservice/authorization/AuthorizationService;)V", "read", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/WikiDto;", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "getWikiList", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/WikiPreviewDto;", "page", "", "pageSize", "sortKey", "Lde/justsoftware/wikiservice/persistence/model/WikiOverview$Companion$Sort;", "sortDirection", "Lde/justsoftware/wikiservice/persistence/model/WikiOverview$Companion$Direction;", "create", "input", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/CreateWikiDto;", "getContentCount", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/ContentCountDto;", "wiki-service"})
public class WikiApplicationService {
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final PermissionApplicationService permissionApplicationService;
    @NotNull
    private final SubscriptionService subscriptionService;
    @NotNull
    private final AuthorizationService authorizationService;

    public WikiApplicationService(@NotNull WikiService wikiService, @NotNull ChapterService chapterService, @NotNull ArticleService articleService, @NotNull ProfileService profileService, @NotNull PermissionApplicationService permissionApplicationService, @NotNull SubscriptionService subscriptionService, @NotNull AuthorizationService authorizationService) {
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)permissionApplicationService, (String)"permissionApplicationService");
        Intrinsics.checkNotNullParameter((Object)subscriptionService, (String)"subscriptionService");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        this.wikiService = wikiService;
        this.chapterService = chapterService;
        this.articleService = articleService;
        this.profileService = profileService;
        this.permissionApplicationService = permissionApplicationService;
        this.subscriptionService = subscriptionService;
        this.authorizationService = authorizationService;
    }

    @NotNull
    public WikiDto read(@NotNull WikiId wikiId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadWiki(wikiId);
        Wiki wiki = this.wikiService.read(wikiId);
        Object v = this.profileService.readByIds(SetsKt.setOf((Object)wiki.getModifiedBy())).get(wiki.getModifiedBy());
        Intrinsics.checkNotNull(v);
        ProfileDto editor = ProfileDto.Companion.toDto((Profile)v);
        Subscription subscription = this.subscriptionService.readWiki(wikiId, authContext.getUser());
        Boolean isManager = (Boolean)this.authorizationService.mayManageWikis(SetsKt.setOf((Object)wikiId), authContext.getUser()).get(wiki.getId());
        WikiDto.Companion companion = WikiDto.Companion;
        boolean bl = subscription.isSubscribed();
        Boolean bl2 = isManager;
        boolean bl3 = bl2 != null ? bl2 : false;
        return companion.toDto(wiki, editor, bl3, bl);
    }

    @NotNull
    public Page<WikiPreviewDto> getWikiList(int page, int pageSize, @NotNull WikiOverview.Companion.Sort sortKey, @NotNull WikiOverview.Companion.Direction sortDirection, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)sortKey, (String)"sortKey");
        Intrinsics.checkNotNullParameter((Object)sortDirection, (String)"sortDirection");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Page page2 = this.wikiService.getPreviewPage(authContext.getUser(), page, pageSize, sortKey, sortDirection, authContext.getTenantId()).map(arg_0 -> WikiApplicationService.getWikiList$lambda$1(WikiApplicationService::getWikiList$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    @Transactional
    @NotNull
    public WikiDto create(@NotNull CreateWikiDto input, @NotNull AuthContext authContext) {
        WikiDto wikiDto;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkCreateWiki();
        Object v = this.profileService.readByIds(SetsKt.setOf((Object)authContext.getUser())).get(authContext.getUser());
        Intrinsics.checkNotNull(v);
        ProfileDto profile = ProfileDto.Companion.toDto((Profile)v);
        WikiDto it = wikiDto = WikiDto.Companion.toDto(this.wikiService.create(input.getTitle(), input.getDescription(), authContext.getUser(), authContext.getTenantId()), profile, true, true);
        boolean bl = false;
        this.permissionApplicationService.setPermissionsForWikiCreation(it.getId(), authContext.getUser().toGranteeId(), authContext);
        return wikiDto;
    }

    @NotNull
    public ContentCountDto getContentCount(@NotNull WikiId wikiId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadWiki(wikiId);
        Integer n = (Integer)this.chapterService.countByWikiIds(SetsKt.setOf((Object)wikiId)).get(wikiId);
        int chapterCount = n != null ? n : 0;
        Integer n2 = (Integer)this.articleService.countByWikiIds(SetsKt.setOf((Object)wikiId)).get(wikiId);
        int articleCount = n2 != null ? n2 : 0;
        return new ContentCountDto((long)chapterCount, (long)articleCount);
    }

    private static final WikiPreviewDto getWikiList$lambda$0(WikiPreview it) {
        Intrinsics.checkNotNull((Object)it);
        return WikiPreviewDto.Companion.toDto(it);
    }

    private static final WikiPreviewDto getWikiList$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (WikiPreviewDto)$tmp0.invoke(p0);
    }
}

