/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater;

import de.justsoftware.wikiservice.application.UserInfoApplicationService;
import de.justsoftware.wikiservice.application.model.ProfileDto;
import de.justsoftware.wikiservice.application.model.TableOfContentsDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.ChapterDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.ContentCountDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.ProfileService;
import de.justsoftware.wikiservice.business.SubscriptionService;
import de.justsoftware.wikiservice.business.TableOfContentsService;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.persistence.model.Chapter;
import de.justsoftware.wikiservice.persistence.model.Profile;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="ChapterApplicationServiceForNewRestEndpoint")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0001\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/ChapterApplicationService;", "", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "profileService", "Lde/justsoftware/wikiservice/business/ProfileService;", "userInfoApplicationService", "Lde/justsoftware/wikiservice/application/UserInfoApplicationService;", "subscriptionService", "Lde/justsoftware/wikiservice/business/SubscriptionService;", "tableOfContentsService", "Lde/justsoftware/wikiservice/business/TableOfContentsService;", "maxChapterDepth", "", "<init>", "(Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/ProfileService;Lde/justsoftware/wikiservice/application/UserInfoApplicationService;Lde/justsoftware/wikiservice/business/SubscriptionService;Lde/justsoftware/wikiservice/business/TableOfContentsService;I)V", "read", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/ChapterDto;", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "getContentCount", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/ContentCountDto;", "wiki-service"})
public class ChapterApplicationService {
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final UserInfoApplicationService userInfoApplicationService;
    @NotNull
    private final SubscriptionService subscriptionService;
    @NotNull
    private final TableOfContentsService tableOfContentsService;
    private final int maxChapterDepth;

    public ChapterApplicationService(@NotNull ChapterService chapterService, @NotNull ArticleService articleService, @NotNull ProfileService profileService, @NotNull UserInfoApplicationService userInfoApplicationService, @NotNull SubscriptionService subscriptionService, @NotNull TableOfContentsService tableOfContentsService, @Value(value="${service.maxChapterNestingDepth:5}") int maxChapterDepth) {
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)userInfoApplicationService, (String)"userInfoApplicationService");
        Intrinsics.checkNotNullParameter((Object)subscriptionService, (String)"subscriptionService");
        Intrinsics.checkNotNullParameter((Object)tableOfContentsService, (String)"tableOfContentsService");
        this.chapterService = chapterService;
        this.articleService = articleService;
        this.profileService = profileService;
        this.userInfoApplicationService = userInfoApplicationService;
        this.subscriptionService = subscriptionService;
        this.tableOfContentsService = tableOfContentsService;
        this.maxChapterDepth = maxChapterDepth;
    }

    @NotNull
    public ChapterDto read(@NotNull ChapterId chapterId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Chapter chapter = this.chapterService.read(chapterId);
        authContext.checkReadWiki(chapter.getWikiId());
        boolean isSubscribed = this.subscriptionService.readChapter(chapterId, authContext.getUser()).isSubscribed();
        Map profiles = this.profileService.readByIds(SetsKt.setOfNotNull((Object)chapter.getModifiedBy()));
        TableOfContentsDto chapterContent = new TableOfContentsDto(chapter.getWikiId(), (ParentId)chapterId, this.maxChapterDepth, this.tableOfContentsService.getSortedTOCElements((ParentId)chapterId, chapter.getWikiId(), authContext));
        Object v = profiles.get(chapter.getModifiedBy());
        if (v == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return ChapterDto.Companion.toDto(chapter, chapterContent, ProfileDto.Companion.toDto((Profile)v), this.userInfoApplicationService.getUserInfo(chapter.getWikiId(), authContext), isSubscribed);
    }

    @NotNull
    public ContentCountDto getContentCount(@NotNull ChapterId chapterId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Chapter chapter = this.chapterService.read(chapterId);
        authContext.checkReadWiki(chapter.getWikiId());
        Set chapterIds = this.chapterService.findDescendantChapterIdsByChapterId(chapterId);
        long articleCount = this.articleService.countByParentIds(CollectionsKt.union((Iterable)chapterIds, (Iterable)SetsKt.setOf((Object)chapterId)));
        return new ContentCountDto((long)chapterIds.size(), articleCount);
    }
}

