/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater;

import de.justsoftware.wikiservice.application.UserInfoApplicationService;
import de.justsoftware.wikiservice.application.model.ProfileDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.ArticleDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.ArticleHeadingDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.ArticleVersionDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.DeletionService;
import de.justsoftware.wikiservice.business.ProfileService;
import de.justsoftware.wikiservice.business.SubscriptionService;
import de.justsoftware.wikiservice.business.exceptions.ArticleNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.ArticleVersionNotFoundException;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ArticleVersionId;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.model.Article;
import de.justsoftware.wikiservice.persistence.model.ArticleHeading;
import de.justsoftware.wikiservice.persistence.model.ArticleVersion;
import de.justsoftware.wikiservice.persistence.model.Profile;
import de.justsoftware.wikiservice.persistence.model.Subscription;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ArticleApplicationServiceForNewRestEndpoint")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0001\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J8\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J8\u0010$\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J \u0010%\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\u0018\u0010'\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010+\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010,\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J.\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002012\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u0002052\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J&\u00106\u001a\u00020\u0015*\u0002072\u0006\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u0001092\u0006\u0010\u001a\u001a\u00020\u001bH\u0012J3\u0010;\u001a\u0002H<\"\u0004\b\u0000\u0010<*\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u0002H<0>H\u0012\u00a2\u0006\u0002\u0010?R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/ArticleApplicationService;", "", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "profileService", "Lde/justsoftware/wikiservice/business/ProfileService;", "userInfoApplicationService", "Lde/justsoftware/wikiservice/application/UserInfoApplicationService;", "subscriptionService", "Lde/justsoftware/wikiservice/business/SubscriptionService;", "deletionService", "Lde/justsoftware/wikiservice/business/DeletionService;", "clock", "Ljava/time/Clock;", "maxEditingTokenDuration", "", "<init>", "(Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/AncestorService;Lde/justsoftware/wikiservice/business/ProfileService;Lde/justsoftware/wikiservice/application/UserInfoApplicationService;Lde/justsoftware/wikiservice/business/SubscriptionService;Lde/justsoftware/wikiservice/business/DeletionService;Ljava/time/Clock;J)V", "read", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/ArticleDto;", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "preferDraft", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "create", "parentId", "Lde/justsoftware/wikiservice/model/ParentId;", "title", "", "content", "textContent", "isDraft", "update", "move", "toParent", "delete", "readHeadingsOfArticle", "", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/ArticleHeadingDto;", "updateEditingToken", "deleteEditingToken", "readArticleVersions", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/ArticleVersionDto;", "page", "", "pageSize", "readArticleByVersionId", "versionId", "Lde/justsoftware/wikiservice/model/ArticleVersionId;", "toDto", "Lde/justsoftware/wikiservice/persistence/model/Article;", "articleVersion", "Lde/justsoftware/wikiservice/persistence/model/ArticleVersion;", "draftVersion", "withWriteCheck", "T", "block", "Lkotlin/Function1;", "(Lde/justsoftware/wikiservice/authorization/AuthContext;Lde/justsoftware/wikiservice/model/ArticleId;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nArticleApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArticleApplicationService.kt\nde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/ArticleApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,274:1\n1557#2:275\n1628#2,3:276\n1246#2,4:285\n126#3:279\n153#3,3:280\n462#4:283\n412#4:284\n*S KotlinDebug\n*F\n+ 1 ArticleApplicationService.kt\nde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/ArticleApplicationService\n*L\n185#1:275\n185#1:276,3\n219#1:285,4\n215#1:279\n215#1:280,3\n219#1:283\n219#1:284\n*E\n"})
public class ArticleApplicationService {
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final AncestorService ancestorService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final UserInfoApplicationService userInfoApplicationService;
    @NotNull
    private final SubscriptionService subscriptionService;
    @NotNull
    private final DeletionService deletionService;
    @NotNull
    private final Clock clock;
    private final long maxEditingTokenDuration;

    public ArticleApplicationService(@NotNull ArticleService articleService, @NotNull AncestorService ancestorService, @NotNull ProfileService profileService, @NotNull UserInfoApplicationService userInfoApplicationService, @NotNull SubscriptionService subscriptionService, @NotNull DeletionService deletionService, @NotNull Clock clock, @Value(value="${service.maxArticleEditingTokenDurationSec:28800}") long maxEditingTokenDuration) {
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)userInfoApplicationService, (String)"userInfoApplicationService");
        Intrinsics.checkNotNullParameter((Object)subscriptionService, (String)"subscriptionService");
        Intrinsics.checkNotNullParameter((Object)deletionService, (String)"deletionService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.articleService = articleService;
        this.ancestorService = ancestorService;
        this.profileService = profileService;
        this.userInfoApplicationService = userInfoApplicationService;
        this.subscriptionService = subscriptionService;
        this.deletionService = deletionService;
        this.clock = clock;
        this.maxEditingTokenDuration = maxEditingTokenDuration;
    }

    @NotNull
    public ArticleDto read(@NotNull ArticleId articleId, boolean preferDraft, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Article article = this.articleService.read(articleId);
        ArticleVersion publishedArticleVersion = this.articleService.findLatestPublishedArticleVersion(articleId);
        ArticleVersion draftArticleVersion = this.articleService.findDraftArticleVersion(articleId);
        if (draftArticleVersion != null && (preferDraft || publishedArticleVersion == null)) {
            authContext.checkWriteWiki(article.getWikiId());
            return this.toDto(article, draftArticleVersion, draftArticleVersion, authContext);
        }
        if (publishedArticleVersion == null) {
            throw new ArticleNotFoundException(articleId);
        }
        authContext.checkReadWiki(article.getWikiId());
        return this.toDto(article, publishedArticleVersion, draftArticleVersion, authContext);
    }

    @NotNull
    public ArticleDto create(@NotNull ParentId parentId, @NotNull String title, @NotNull String content, @NotNull String textContent, boolean isDraft, @NotNull AuthContext authContext) {
        ArticleDto articleDto;
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)textContent, (String)"textContent");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WikiId wikiId = this.ancestorService.getAncestorWikiId(parentId);
        int position = this.ancestorService.getNextPositionForParent(parentId);
        authContext.checkWriteWiki(wikiId);
        Article article = this.articleService.create(parentId, wikiId, title, content, textContent, authContext.getUser(), position, isDraft);
        if (isDraft) {
            ArticleVersion draftVersion = this.articleService.getDraftArticleVersion(article.getId());
            articleDto = this.toDto(article, draftVersion, draftVersion, authContext);
        } else {
            ArticleVersion articleVersion = this.articleService.getLatestPublishedArticleVersion(article.getId());
            articleDto = this.toDto(article, articleVersion, null, authContext);
        }
        return articleDto;
    }

    @Transactional
    @NotNull
    public ArticleDto update(@NotNull ArticleId articleId, @NotNull String title, @NotNull String content, @NotNull String textContent, boolean isDraft, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)textContent, (String)"textContent");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Article article = this.articleService.read(articleId);
        authContext.checkWriteWiki(article.getWikiId());
        Article updatedArticle = this.articleService.update(article.getId(), title, content, textContent, authContext.getUser(), isDraft);
        ArticleVersion publishedOrDraftVersion = this.articleService.getLatestPublishedOrDraftArticleVersion(updatedArticle.getId());
        ArticleVersion draftVersion = this.articleService.findDraftArticleVersion(updatedArticle.getId());
        return this.toDto(article, publishedOrDraftVersion, draftVersion, authContext);
    }

    @Transactional
    @NotNull
    public ArticleDto move(@NotNull ArticleId articleId, @NotNull ParentId toParent, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)toParent, (String)"toParent");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Article article = this.articleService.read(articleId);
        WikiId toWikiId = this.ancestorService.getAncestorWikiId(toParent);
        authContext.checkMoveWikiContent(article.getWikiId(), toWikiId);
        this.ancestorService.moveArticle(articleId, toParent, authContext.getUser());
        Article updatedArticle = this.articleService.read(articleId);
        ArticleVersion articleVersion = this.articleService.getLatestPublishedArticleVersion(updatedArticle.getId());
        ArticleVersion draftVersion = this.articleService.findDraftArticleVersion(articleVersion.getArticleId());
        return this.toDto(updatedArticle, articleVersion, draftVersion, authContext);
    }

    @Transactional
    @NotNull
    public ArticleDto delete(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return (ArticleDto)this.withWriteCheck(authContext, articleId, arg_0 -> ArticleApplicationService.delete$lambda$0(this, articleId, authContext, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ArticleHeadingDto> readHeadingsOfArticle(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        List list;
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WikiId wikiId = this.articleService.read(articleId).getWikiId();
        authContext.checkReadWiki(wikiId);
        List list2 = (List)this.articleService.readHeadings(SetsKt.setOf((Object)articleId)).get(articleId);
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void heading;
                ArticleHeading articleHeading = (ArticleHeading)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ArticleHeadingDto.Companion.toDto((ArticleHeading)heading));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public boolean updateEditingToken(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return (Boolean)this.withWriteCheck(authContext, articleId, arg_0 -> ArticleApplicationService.updateEditingToken$lambda$2(this, authContext, arg_0));
    }

    public boolean deleteEditingToken(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return (Boolean)this.withWriteCheck(authContext, articleId, arg_0 -> ArticleApplicationService.deleteEditingToken$lambda$3(this, authContext, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<ArticleVersionDto> readArticleVersions(@NotNull ArticleId articleId, int page, int pageSize, @NotNull AuthContext authContext) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object;
        Map $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Map $this$map$iv = this.articleService.readByIds(SetsKt.setOf((Object)articleId));
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo22 = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((Article)it.getValue()).getWikiId());
        }
        Set wikiIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        authContext.checkReadArticleVersionHistory(wikiIds);
        Page versions = this.articleService.readPublishedVersionPage(articleId, page, pageSize);
        Set set = versions.map(arg_0 -> ArticleApplicationService.readArticleVersions$lambda$6(ArticleApplicationService::readArticleVersions$lambda$5, arg_0)).toSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toSet(...)");
        $this$mapTo$iv$iv = this.profileService.readByIds(set);
        boolean $i$f$mapValues = false;
        void $i$f$mapTo22 = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = map2;
            boolean bl2 = false;
            ProfileDto profileDto = ProfileDto.Companion.toDto((Profile)it.getValue());
            object.put(k, profileDto);
        }
        Map profiles = destination$iv$iv2;
        Page page2 = versions.map(arg_0 -> ArticleApplicationService.readArticleVersions$lambda$9(arg_0 -> ArticleApplicationService.readArticleVersions$lambda$8(profiles, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    @NotNull
    public ArticleDto readArticleByVersionId(@NotNull ArticleVersionId versionId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)versionId, (String)"versionId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ArticleVersion articleVersion = this.articleService.getArticleVersion(versionId);
        Article article = this.articleService.read(articleVersion.getArticleId());
        if (articleVersion.isDraft()) {
            authContext.checkWriteWiki(article.getWikiId());
        } else {
            authContext.checkReadWiki(article.getWikiId());
        }
        ArticleVersion draftVersion = this.articleService.findDraftArticleVersion(articleVersion.getArticleId());
        return this.toDto(article, articleVersion, draftVersion, authContext);
    }

    private ArticleDto toDto(Article $this$toDto, ArticleVersion articleVersion, ArticleVersion draftVersion, AuthContext authContext) {
        Subscription subscription = this.subscriptionService.readArticle($this$toDto.getId(), authContext.getUser());
        Object[] objectArray = new ProfileId[]{$this$toDto.getEditingStartedBy(), articleVersion.getModifiedBy()};
        Map profiles = this.profileService.readByIds(SetsKt.setOfNotNull((Object[])objectArray));
        ArticleVersion articleVersion2 = draftVersion;
        Object v = profiles.get(articleVersion.getModifiedBy());
        if (v == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Profile profile = (Profile)profiles.get($this$toDto.getEditingStartedBy());
        return ArticleDto.Companion.toDto($this$toDto, articleVersion, (ArticleVersionId)(articleVersion2 != null ? articleVersion2.getId() : null), this.clock, this.maxEditingTokenDuration, ProfileDto.Companion.toDto((Profile)v), profile != null ? ProfileDto.Companion.toDto(profile) : null, this.userInfoApplicationService.getUserInfo($this$toDto.getWikiId(), authContext), subscription.isSubscribed());
    }

    private <T> T withWriteCheck(AuthContext $this$withWriteCheck, ArticleId articleId, Function1<? super Article, ? extends T> block) {
        Article article = this.articleService.read(articleId);
        $this$withWriteCheck.checkWriteWiki(article.getWikiId());
        return (T)block.invoke((Object)article);
    }

    private static final ArticleDto delete$lambda$0(ArticleApplicationService this$0, ArticleId $articleId, AuthContext $authContext, Article it) {
        ArticleDto articleDto;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$articleId, (String)"$articleId");
        Intrinsics.checkNotNullParameter((Object)$authContext, (String)"$authContext");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ArticleVersion articleVersion = this$0.articleService.findLatestPublishedArticleVersion($articleId);
        ArticleVersion draftVersion = this$0.articleService.findDraftArticleVersion($articleId);
        if (articleVersion == null && draftVersion == null) {
            throw new ArticleVersionNotFoundException(null, 1, null);
        }
        DeletionId deletionId = DeletionService.create$default((DeletionService)this$0.deletionService, (ItemId)((ItemId)$articleId), (ProfileId)$authContext.getUser(), null, (int)4, null);
        this$0.articleService.delete($articleId, deletionId, $authContext.getUser());
        if (articleVersion != null) {
            articleDto = this$0.toDto(it, articleVersion, draftVersion, $authContext);
        } else if (draftVersion != null) {
            articleDto = this$0.toDto(it, draftVersion, draftVersion, $authContext);
        } else {
            throw new ArticleVersionNotFoundException(null, 1, null);
        }
        return articleDto;
    }

    private static final boolean updateEditingToken$lambda$2(ArticleApplicationService this$0, AuthContext $authContext, Article article) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$authContext, (String)"$authContext");
        Intrinsics.checkNotNullParameter((Object)article, (String)"article");
        return this$0.articleService.updateEditingToken(article.getId(), $authContext.getUser());
    }

    private static final boolean deleteEditingToken$lambda$3(ArticleApplicationService this$0, AuthContext $authContext, Article article) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$authContext, (String)"$authContext");
        Intrinsics.checkNotNullParameter((Object)article, (String)"article");
        return this$0.articleService.deleteEditingToken(article.getId(), $authContext.getUser());
    }

    private static final ProfileId readArticleVersions$lambda$5(ArticleVersion it) {
        return it.getModifiedBy();
    }

    private static final ProfileId readArticleVersions$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ProfileId)$tmp0.invoke(p0);
    }

    private static final ArticleVersionDto readArticleVersions$lambda$8(Map $profiles, ArticleVersion it) {
        Intrinsics.checkNotNullParameter((Object)$profiles, (String)"$profiles");
        Intrinsics.checkNotNull((Object)it);
        return ArticleVersionDto.Companion.toDto(it, (ProfileDto)$profiles.get(it.getModifiedBy()));
    }

    private static final ArticleVersionDto readArticleVersions$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ArticleVersionDto)$tmp0.invoke(p0);
    }
}

