/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.application.SubscriptionApplicationService;
import de.justsoftware.wikiservice.application.model.SubscriptionDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.AncestorDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.ArticlePreviewDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.ChapterPreviewDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.PreviewDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.WikiPreviewDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.SubscriptionService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.model.Ancestor;
import de.justsoftware.wikiservice.persistence.model.Article;
import de.justsoftware.wikiservice.persistence.model.ArticleVersion;
import de.justsoftware.wikiservice.persistence.model.Chapter;
import de.justsoftware.wikiservice.persistence.model.Subscription;
import de.justsoftware.wikiservice.persistence.model.Wiki;
import de.justsoftware.wikiservice.util.CollectionUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0017\u0018\u0000 *2\u00020\u0001:\u0001*B9\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ*\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J,\u0010!\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030#0\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J.\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\u00112\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0)2\u0006\u0010\u0016\u001a\u00020\u0017H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lde/justsoftware/wikiservice/application/SubscriptionApplicationService;", "", "subscriptionService", "Lde/justsoftware/wikiservice/business/SubscriptionService;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "<init>", "(Lde/justsoftware/wikiservice/business/SubscriptionService;Lde/justsoftware/wikiservice/business/WikiService;Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/AncestorService;Lde/justsoftware/wikiservice/authorization/AuthorizationService;)V", "read", "", "Lde/justsoftware/wikiservice/model/WikiId;", "Lde/justsoftware/wikiservice/application/model/SubscriptionDto;", "wikiIds", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "setSubscription", "itemId", "Lde/justsoftware/wikiservice/model/ItemId;", "isSubscribed", "", "getSubscribedItems", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/PreviewDto;", "page", "", "pageSize", "findPreviewByItemsIds", "itemIds", "", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nSubscriptionApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubscriptionApplicationService.kt\nde/justsoftware/wikiservice/application/SubscriptionApplicationService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 CollectionUtils.kt\nde/justsoftware/wikiservice/util/CollectionUtilsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 LoggerUtils.kt\nde/justsoftware/wikiservice/util/LoggerUtilsKt\n*L\n1#1,158:1\n462#2:159\n412#2:160\n487#2,7:191\n503#2,7:198\n503#2,7:205\n1246#3,4:161\n1611#3,9:165\n1863#3:174\n1864#3:176\n1620#3:177\n817#3,2:179\n817#3,2:182\n817#3,2:185\n1611#3,9:222\n1863#3:231\n1864#3:233\n1620#3:234\n1187#3,2:236\n1261#3,4:238\n1611#3,9:244\n1863#3:253\n1557#3:254\n1628#3,3:255\n1864#3:259\n1620#3:260\n1187#3,2:262\n1261#3,4:264\n1611#3,9:270\n1863#3:279\n1557#3:280\n1628#3,3:281\n1864#3:285\n1620#3:286\n1187#3,2:288\n1261#3,4:290\n1#4:175\n1#4:232\n1#4:258\n1#4:284\n22#5:178\n22#5:181\n22#5:184\n16#5:187\n16#5:212\n16#5:216\n80#5,2:220\n82#5:235\n80#5,2:242\n82#5:261\n80#5,2:268\n82#5:287\n153#6,3:188\n153#6,3:213\n153#6,3:217\n8#7:294\n7#7,3:295\n*S KotlinDebug\n*F\n+ 1 SubscriptionApplicationService.kt\nde/justsoftware/wikiservice/application/SubscriptionApplicationService\n*L\n49#1:159\n49#1:160\n119#1:191,7\n120#1:198,7\n121#1:205,7\n49#1:161,4\n100#1:165,9\n100#1:174\n100#1:176\n100#1:177\n110#1:179,2\n111#1:182,2\n112#1:185,2\n131#1:222,9\n131#1:231\n131#1:233\n131#1:234\n131#1:236,2\n131#1:238,4\n132#1:244,9\n132#1:253\n135#1:254\n135#1:255,3\n132#1:259\n132#1:260\n132#1:262,2\n132#1:264,4\n141#1:270,9\n141#1:279\n145#1:280\n145#1:281,3\n141#1:285\n141#1:286\n141#1:288,2\n141#1:290,4\n100#1:175\n131#1:232\n132#1:258\n141#1:284\n110#1:178\n111#1:181\n112#1:184\n117#1:187\n126#1:212\n127#1:216\n131#1:220,2\n131#1:235\n132#1:242,2\n132#1:261\n141#1:268,2\n141#1:287\n117#1:188,3\n126#1:213,3\n127#1:217,3\n155#1:294\n155#1:295,3\n*E\n"})
public class SubscriptionApplicationService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SubscriptionService subscriptionService;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final AncestorService ancestorService;
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private static final Logger LOG;

    @Autowired
    public SubscriptionApplicationService(@NotNull SubscriptionService subscriptionService, @NotNull WikiService wikiService, @NotNull ChapterService chapterService, @NotNull ArticleService articleService, @NotNull AncestorService ancestorService, @NotNull AuthorizationService authorizationService) {
        Intrinsics.checkNotNullParameter((Object)subscriptionService, (String)"subscriptionService");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        this.subscriptionService = subscriptionService;
        this.wikiService = wikiService;
        this.chapterService = chapterService;
        this.articleService = articleService;
        this.ancestorService = ancestorService;
        this.authorizationService = authorizationService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<WikiId, SubscriptionDto> read(@NotNull List<WikiId> wikiIds, @NotNull AuthContext authContext) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Set userRoles = this.authorizationService.getUserRoles(authContext.getUser());
        Map map = this.subscriptionService.readWikis(CollectionsKt.toSet((Iterable)wikiIds), authContext.getUser(), userRoles);
        boolean $i$f$mapValues = false;
        void var6_6 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void entry;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            SubscriptionDto subscriptionDto = SubscriptionDto.Companion.toDto((Subscription)entry.getValue());
            map3.put(k, subscriptionDto);
        }
        return destination$iv$iv;
    }

    @NotNull
    public SubscriptionDto read(@NotNull ChapterId chapterId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WikiId wikiId = this.chapterService.read(chapterId).getWikiId();
        authContext.checkReadWiki(wikiId);
        return SubscriptionDto.Companion.toDto(this.subscriptionService.readChapter(chapterId, authContext.getUser()));
    }

    @NotNull
    public SubscriptionDto read(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WikiId wikiId = this.articleService.read(articleId).getWikiId();
        authContext.checkReadWiki(wikiId);
        return SubscriptionDto.Companion.toDto(this.subscriptionService.readArticle(articleId, authContext.getUser()));
    }

    @NotNull
    public SubscriptionDto setSubscription(@NotNull ItemId itemId, boolean isSubscribed, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        switch (WhenMappings.$EnumSwitchMapping$0[itemId.type().ordinal()]) {
            case 1: {
                authContext.checkReadWiki((WikiId)itemId);
                break;
            }
            case 2: {
                WikiId wikiId = this.chapterService.read((ChapterId)itemId).getWikiId();
                authContext.checkReadWiki(wikiId);
                break;
            }
            case 3: {
                WikiId wikiId = this.articleService.read((ArticleId)itemId).getWikiId();
                authContext.checkReadWiki(wikiId);
                break;
            }
            default: {
                throw new RuntimeException("Cannot subscribe to " + itemId);
            }
        }
        return SubscriptionDto.Companion.toDto(this.subscriptionService.setSubscription(itemId, authContext.getUser(), isSubscribed));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<? extends PreviewDto<?>> getSubscribedItems(int page, int pageSize, @NotNull AuthContext authContext) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Page subscribedItemIds = this.subscriptionService.getSubscribedItemIds(page, pageSize, authContext.getUser());
        Set set = subscribedItemIds.toSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toSet(...)");
        Map previews = this.findPreviewByItemsIds((Collection)set, authContext);
        Iterable $this$mapNotNull$iv = (Iterable)subscribedItemIds;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PreviewDto it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ItemId it = (ItemId)element$iv$iv;
            boolean bl2 = false;
            if ((PreviewDto)previews.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        long l = subscribedItemIds.getTotalElements();
        Pageable pageable = (Pageable)PageRequest.of((int)page, (int)pageSize);
        List list = (List)destination$iv$iv;
        return (Page)new PageImpl(list, pageable, l);
    }

    /*
     * WARNING - void declaration
     */
    private Map<ItemId, PreviewDto<?>> findPreviewByItemsIds(Collection<? extends ItemId> itemIds, AuthContext authContext) {
        void $this$associateTo$iv$iv$iv;
        void $this$associate$iv$iv;
        void $this$mapNotNullTo$iv$iv$iv;
        Iterable $this$mapNotNull$iv$iv;
        void $this$associateTo$iv$iv$iv2;
        void $this$associate$iv$iv2;
        ChapterPreviewDto it$iv;
        ChapterPreviewDto.Companion companion;
        Object element$iv$iv$iv$iv32;
        void $this$mapNotNullTo$iv$iv$iv2;
        Iterable $this$mapNotNull$iv$iv2;
        void $this$associateTo$iv$iv$iv3;
        void $this$associate$iv$iv3;
        boolean bl;
        void $this$mapNotNullTo$iv$iv$iv3;
        Iterable $this$mapNotNull$iv$iv3;
        Map.Entry it;
        boolean bl2;
        Map.Entry item$iv$iv;
        Collection<ParentId> collection;
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Chapter v;
        Collection collection2;
        void $this$mapTo$iv$iv2;
        Map $this$mapToSet$iv2;
        Object element$iv$iv42;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        void $this$filterIsInstanceTo$iv$iv3;
        Iterable $this$filterIsInstanceToSet$iv = itemIds;
        boolean $i$f$filterIsInstanceToSet = false;
        Iterable iterable = $this$filterIsInstanceToSet$iv;
        Iterable destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv));
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv3) {
            if (!(element$iv$iv2 instanceof WikiId)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        Set wikiIds = (Set)destination$iv$iv;
        Iterable $this$filterIsInstanceToSet$iv2 = itemIds;
        boolean $i$f$filterIsInstanceToSet2 = false;
        destination$iv$iv = $this$filterIsInstanceToSet$iv2;
        Iterable destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv2));
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv3 : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv3 instanceof ChapterId)) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        Set chapterIds = (Set)destination$iv$iv2;
        Iterable $this$filterIsInstanceToSet$iv3 = itemIds;
        boolean $i$f$filterIsInstanceToSet3 = false;
        destination$iv$iv2 = $this$filterIsInstanceToSet$iv3;
        Collection destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv3));
        boolean $i$f$filterIsInstanceTo2232 = false;
        for (Object element$iv$iv42 : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv42 instanceof ArticleId)) continue;
            destination$iv$iv3.add(element$iv$iv42);
        }
        Set articleIds = (Set)destination$iv$iv3;
        Map wikis = this.wikiService.getWikisByIds(wikiIds);
        Map chapters = this.chapterService.getChaptersByIds(chapterIds);
        Map articles = this.articleService.readByIds(articleIds);
        Map $i$f$filterIsInstanceTo2232 = chapters;
        Set set = wikiIds;
        boolean $i$f$mapToSet = false;
        element$iv$iv42 = $this$mapToSet$iv2;
        Collection destination$iv$iv4 = new LinkedHashSet($this$mapToSet$iv2.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            collection2 = destination$iv$iv4;
            boolean bl3 = false;
            v = (Chapter)entry2.getValue();
            collection2.add(v.getWikiId());
        }
        $this$mapToSet$iv2 = articles;
        collection2 = (Set)destination$iv$iv4;
        $i$f$mapToSet = false;
        $this$mapTo$iv$iv2 = $this$mapToSet$iv;
        Collection destination$iv$iv5 = new LinkedHashSet($this$mapToSet$iv.size());
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry3 = entry = iterator.next();
            collection = destination$iv$iv5;
            boolean bl4 = false;
            v = (Article)entry3.getValue();
            collection.add((ParentId)v.getWikiId());
        }
        collection = (Set)destination$iv$iv5;
        Set wikiIdsToCheck = SetsKt.plus((Set)set, (Iterable)SetsKt.plus((Set)collection2, (Iterable)collection));
        Map readableWikiIds = this.authorizationService.mayReadWikis(wikiIdsToCheck, authContext.getUser());
        Map $this$filterKeys$iv = wikis;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterKeys$iv.entrySet()) {
            WikiId wikiId = (WikiId)entry.getKey();
            boolean bl5 = false;
            if (!readableWikiIds.containsKey(wikiId)) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Map readableWikis = result$iv;
        Map $this$filterValues$iv = chapters;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv2 = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            Chapter chapter = (Chapter)entry.getValue();
            boolean bl6 = false;
            if (!readableWikiIds.containsKey(chapter.getWikiId())) continue;
            result$iv2.put(entry.getKey(), entry.getValue());
        }
        Map readableChapters = result$iv2;
        Map $this$filterValues$iv2 = articles;
        boolean $i$f$filterValues2 = false;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv2.entrySet()) {
            Article it4 = (Article)entry.getValue();
            boolean bl7 = false;
            if (!readableWikiIds.containsKey(it4.getWikiId())) continue;
            linkedHashMap.put(entry.getKey(), entry.getValue());
        }
        Map readableArticles = linkedHashMap;
        Map readableArticleVersions = this.articleService.findLatestPublishedArticleVersions(readableArticles.keySet());
        Map map = readableArticles;
        set = this.ancestorService;
        boolean bl8 = false;
        Map map2 = map;
        Collection destination$iv$iv52 = new LinkedHashSet(map.size());
        boolean $i$f$mapTo2 = false;
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = item$iv$iv = iterator2.next();
            collection2 = destination$iv$iv52;
            bl2 = false;
            collection2.add(Article.Companion.getParent((Article)it.getValue()));
        }
        Map map3 = readableChapters;
        collection2 = (Set)destination$iv$iv52;
        boolean bl9 = false;
        Map map4 = map3;
        Iterable destination$iv$iv6 = new LinkedHashSet(map3.size());
        boolean $i$f$mapTo3 = false;
        iterator2 = map4.entrySet().iterator();
        while (iterator2.hasNext()) {
            it = item$iv$iv = iterator2.next();
            collection = destination$iv$iv6;
            bl2 = false;
            collection.add(Chapter.Companion.getParent((Chapter)it.getValue()));
        }
        collection = (Set)destination$iv$iv6;
        Map ancestors = set.getAncestors(SetsKt.plus((Set)collection2, (Iterable)collection));
        Map map5 = readableWikis;
        boolean bl10 = false;
        destination$iv$iv6 = map5.entrySet();
        boolean $i$f$mapNotNull = false;
        iterator2 = $this$mapNotNull$iv$iv3;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv3;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv$iv2 : $this$forEach$iv$iv$iv$iv) {
            Pair pair;
            Object element$iv$iv$iv = element$iv$iv$iv$iv2;
            bl = false;
            Map.Entry entry$iv2 = (Map.Entry)element$iv$iv$iv;
            boolean bl22 = false;
            Map.Entry entry = entry$iv2;
            boolean bl3 = false;
            Wiki v2 = (Wiki)entry.getValue();
            if (WikiPreviewDto.Companion.toPreviewDto(v2, true) != null) {
                WikiPreviewDto it$iv2;
                boolean bl4 = false;
                pair = TuplesKt.to(entry$iv2.getKey(), (Object)it$iv2);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        $this$mapNotNull$iv$iv3 = (List)destination$iv$iv$iv;
        boolean $i$f$associate232 = false;
        int capacity$iv$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv$iv3, (int)10)), (int)16);
        destination$iv$iv$iv = $this$associate$iv$iv3;
        Map destination$iv$iv$iv2 = new LinkedHashMap(capacity$iv$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv$iv : $this$associateTo$iv$iv$iv3) {
            Object element$iv$iv$iv$iv2;
            element$iv$iv$iv$iv2 = destination$iv$iv$iv2;
            Pair it$iv3 = (Pair)element$iv$iv$iv;
            bl = false;
            element$iv$iv$iv$iv2.put((Object)it$iv3.getFirst(), (Object)it$iv3.getSecond());
        }
        Map map6 = destination$iv$iv$iv2;
        Map map7 = readableChapters;
        boolean $i$f$mapValuesNotNull2 = false;
        Iterable $i$f$associate232 = map7.entrySet();
        boolean $i$f$mapNotNull2 = false;
        $this$associateTo$iv$iv$iv3 = $this$mapNotNull$iv$iv2;
        Collection destination$iv$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv$iv2 = $this$mapNotNullTo$iv$iv$iv2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv$iv$iv$iv32 : $this$forEach$iv$iv$iv$iv2) {
            Pair pair;
            List list;
            boolean bl11;
            Chapter chapter;
            ChapterPreviewDto.Companion companion2;
            Object element$iv$iv$iv = element$iv$iv$iv$iv32;
            boolean bl6 = false;
            Map.Entry entry$iv3 = (Map.Entry)element$iv$iv$iv;
            boolean bl7 = false;
            Map.Entry bl3 = entry$iv3;
            boolean bl82 = false;
            Chapter v3 = (Chapter)bl3.getValue();
            List list2 = (List)ancestors.get(Chapter.Companion.getParent(v3));
            if (list2 != null) {
                void $this$mapTo$iv$iv3;
                Iterable bl4 = list2;
                it$iv$iv$iv = true;
                var38_136 = v3;
                companion = ChapterPreviewDto.Companion;
                boolean $i$f$map = false;
                List list3 = $this$map$iv;
                Collection destination$iv$iv62 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo32 = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                    void ancestor;
                    Ancestor ancestor2 = (Ancestor)item$iv$iv3;
                    var47_151 = destination$iv$iv62;
                    boolean bl92 = false;
                    var47_151.add(AncestorDto.Companion.toDto((Ancestor)ancestor));
                }
                var47_151 = (List)destination$iv$iv62;
                companion2 = companion;
                chapter = var38_136;
                bl11 = it$iv$iv$iv;
                list = var47_151;
            } else {
                List $i$f$map = $this$map$iv = CollectionsKt.emptyList();
                it$iv$iv$iv = true;
                boolean bl102 = false;
                LOG.error("No ancestor found for Chapter " + v3.getId() + ". Return empty ancestor list as fallback.");
                var47_151 = Unit.INSTANCE;
                companion2 = companion;
                chapter = var38_136;
                bl11 = it$iv$iv$iv;
                list = $this$map$iv;
            }
            if (companion2.toPreviewDto(chapter, bl11, list) != null) {
                boolean bl112 = false;
                pair = TuplesKt.to(entry$iv3.getKey(), (Object)it$iv);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv$iv = pair;
            boolean bl12 = false;
            destination$iv$iv$iv3.add(it$iv$iv$iv);
        }
        $this$mapNotNull$iv$iv2 = (List)destination$iv$iv$iv3;
        boolean $i$f$associate332 = false;
        int capacity$iv$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv$iv2, (int)10)), (int)16);
        destination$iv$iv$iv3 = $this$associate$iv$iv2;
        Map destination$iv$iv$iv32 = new LinkedHashMap(capacity$iv$iv2);
        boolean $i$f$associateTo2 = false;
        for (Object element$iv$iv$iv : $this$associateTo$iv$iv$iv2) {
            element$iv$iv$iv$iv32 = destination$iv$iv$iv32;
            Pair it$iv4 = (Pair)element$iv$iv$iv;
            boolean bl12 = false;
            element$iv$iv$iv$iv32.put((Object)it$iv4.getFirst(), (Object)it$iv4.getSecond());
        }
        Map map8 = destination$iv$iv$iv32;
        Map $this$mapValuesNotNull$iv3 = readableArticleVersions;
        boolean $i$f$mapValuesNotNull3 = false;
        Iterable $i$f$associate332 = $this$mapValuesNotNull$iv3.entrySet();
        boolean $i$f$mapNotNull3 = false;
        $this$associateTo$iv$iv$iv2 = $this$mapNotNull$iv$iv;
        Collection destination$iv$iv$iv4 = new ArrayList();
        boolean $i$f$mapNotNullTo3 = false;
        void $this$forEach$iv$iv$iv$iv3 = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach3 = false;
        element$iv$iv$iv$iv32 = $this$forEach$iv$iv$iv$iv3.iterator();
        while (element$iv$iv$iv$iv32.hasNext()) {
            Pair pair;
            Object object;
            boolean bl13;
            ArticleVersion articleVersion;
            ArticlePreviewDto.Companion companion3;
            Map.Entry entry$iv4;
            block32: {
                List list;
                Unit unit;
                List article;
                ArticlePreviewDto.Companion companion4;
                boolean bl14;
                ArticleVersion v4;
                block31: {
                    Object object2;
                    Object element$iv$iv$iv$iv4;
                    Object element$iv$iv$iv = element$iv$iv$iv$iv4 = element$iv$iv$iv$iv32.next();
                    boolean bl142 = false;
                    entry$iv4 = (Map.Entry)element$iv$iv$iv;
                    boolean bl15 = false;
                    Map.Entry entry = entry$iv4;
                    boolean bl16 = false;
                    v4 = (ArticleVersion)entry.getValue();
                    companion3 = ArticlePreviewDto.Companion;
                    articleVersion = v4;
                    bl13 = true;
                    object = (Article)articles.get(v4.getArticleId());
                    if (object == null) break block31;
                    Article it$iv$iv$iv = object;
                    bl14 = bl13;
                    companion = articleVersion;
                    companion4 = companion3;
                    boolean bl17 = false;
                    List list4 = (List)ancestors.get(Article.Companion.getParent((Article)article));
                    if (list4 != null) {
                        void $this$mapTo$iv$iv4;
                        Iterable $this$map$iv = list4;
                        boolean $i$f$map = false;
                        Iterable iterable2 = $this$map$iv;
                        Collection destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo4 = false;
                        for (Object item$iv$iv4 : $this$mapTo$iv$iv4) {
                            void ancestor;
                            it$iv = (Ancestor)item$iv$iv4;
                            Collection collection3 = destination$iv$iv7;
                            boolean bl18 = false;
                            collection3.add(AncestorDto.Companion.toDto((Ancestor)ancestor));
                        }
                        object2 = (List)destination$iv$iv7;
                    } else {
                        object2 = null;
                    }
                    unit = object2;
                    companion3 = companion4;
                    articleVersion = companion;
                    bl13 = bl14;
                    Unit unit2 = unit;
                    object = unit2;
                    if (unit2 != null) break block32;
                }
                article = list = CollectionsKt.emptyList();
                bl14 = bl13;
                companion = articleVersion;
                companion4 = companion3;
                boolean bl19 = false;
                LOG.error("No ancestor found for Article " + v4.getArticleId() + ". Return empty ancestor list as fallback.");
                unit = Unit.INSTANCE;
                companion3 = companion4;
                articleVersion = companion;
                bl13 = bl14;
                object = list;
            }
            if (companion3.toPreviewDto(articleVersion, bl13, (List)object) != null) {
                ArticlePreviewDto it$iv5;
                boolean bl20 = false;
                pair = TuplesKt.to(entry$iv4.getKey(), (Object)it$iv5);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv$iv = pair;
            boolean bl21 = false;
            destination$iv$iv$iv4.add(it$iv$iv$iv);
        }
        $this$mapNotNull$iv$iv = (List)destination$iv$iv$iv4;
        boolean $i$f$associate = false;
        int capacity$iv$iv3 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv$iv, (int)10)), (int)16);
        destination$iv$iv$iv4 = $this$associate$iv$iv;
        Map destination$iv$iv$iv42 = new LinkedHashMap(capacity$iv$iv3);
        boolean $i$f$associateTo3 = false;
        for (Object element$iv$iv$iv : $this$associateTo$iv$iv$iv) {
            Map map9 = destination$iv$iv$iv42;
            Pair it$iv6 = (Pair)element$iv$iv$iv;
            boolean bl15 = false;
            Pair pair = it$iv6;
            map9.put(pair.getFirst(), pair.getSecond());
        }
        Map map10 = destination$iv$iv$iv42;
        return MapsKt.plus((Map)MapsKt.plus((Map)map6, (Map)map8), (Map)map10);
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

