/* DHTML Color Picker : v1.0.4 : 2008/05/08 */
/* http://www.colorjack.com/software/dhtml+color+picker.html */

function $(v,o) { return((typeof(o)=='object'?o:document).getElementById(v)); }
function $S(o) { o=$(o); if(o) return(o.style); }
function abPos(o) { var o=(typeof(o)=='object'?o:$(o)), z={X:0,Y:0}; while(o!=null) { z.X+=o.offsetLeft; z.Y+=o.offsetTop; o=o.offsetParent; }; return(z); }
function agent(v) { return(Math.max(navigator.userAgent.toLowerCase().indexOf(v),0)); }
function toggle(v) { $S(v).display=($S(v).display=='none'?'block':'none'); }
function within(v,a,z) { return((v>=a && v<=z)?true:false); }

//The original version of XY had a bug.
//See: http://de.selfhtml.org/javascript/objekte/window.htm#page_x_offset
//@author wolfgang
function XY(e,v) {
    var isDefined = function(x) {
        return typeof x !== 'undefined';
    };
    var o;

    if (agent('msie')) {
        if (isDefined(document.documentElement)
                && isDefined(document.documentElement.scrollLeft)
                && isDefined(document.documentElement.scrollTop)) {
            o = {
                'X':event.clientX+document.documentElement.scrollLeft,
                'Y':event.clientY+document.documentElement.scrollTop
            };
        } else {
            o = {
                'X':event.clientX+document.body.scrollLeft,
                'Y':event.clientY+document.body.scrollTop
            };
        }
    } else {
        o = {
            'X':e.pageX,
            'Y':e.pageY
        };
    }
    return(v?o[v]:o);
}

function zero(v) { v=parseInt(v); return(!isNaN(v)?v:0); }


/* COLOR PICKER */

var maxValue={'H':360,'S':100,'V':100}, HSV={H:360, S:100, V:100};

var slideHSV={H:360, S:100, V:100}, zINDEX=15, stop=1;

function HSVslide(d,o,e) {

    function tXY(e) { tY=XY(e).Y-ab.Y; tX=XY(e).X-ab.X; }
    function mkHSV(a,b,c) { return(Math.min(a,Math.max(0,Math.ceil((parseInt(c)/b)*a)))); }
    function ckHSV(a,b) { if(within(a,0,b)) return(a); else if(a>b) return(b); else if(a<0) return('-'+oo); }
    function drag(e) { if(!stop) { if(d!='drag') tXY(e);
    
        if(d=='colorPickerSVslide') { ds.left=ckHSV(tX-oo,162)+'px'; ds.top=ckHSV(tY-oo,162)+'px';

            slideHSV.S=mkHSV(100,162,ds.left); slideHSV.V=100-mkHSV(100,162,ds.top); HSVupdate();

        }
        else if(d=='colorPickerHslide') { var ck=ckHSV(tY-oo,163), r=['H','S','V'], z={};
            ds.top=(ck)+'px'; slideHSV.H=mkHSV(360,163,ck);

            for(var i in r) { i=r[i]; z[i]=(i=='H')?maxValue[i]-mkHSV(maxValue[i],163,ck):HSV[i]; }

            HSVupdate(z); $S('colorPickerSV').backgroundColor='#'+color.HSV_HEX({H:HSV.H, S:100, V:100});

        }
        else if(d=='drag') { ds.left=XY(e).X+oX-eX+'px'; ds.top=XY(e).Y+oY-eY+'px'; }

    }}

    if(stop) { stop=''; var ds=$S(d!='drag'?d:o);

        if(d=='drag') { var oX=parseInt(ds.left), oY=parseInt(ds.top), eX=XY(e).X, eY=XY(e).Y; $S(o).zIndex=zINDEX++; }

        else {
            var ab=abPos($(o)), tX, tY, oo=(d=='colorPickerHslide')?2:3;
            if (/MSIE/.test(navigator.userAgent) && !window.opera) {
                ab.X+=3;
                ab.Y+=27;
            } else {
                ab.X+=1;
                ab.Y+=22;
            }
            if(d=='colorPickerSVslide') {
                slideHSV.H=HSV.H;
            }
        }
        document.onmousemove=drag; document.onmouseup=function(){ stop=1; document.onmousemove=''; document.onmouseup=''; }; drag(e);

    }
};

function HSVupdate(v) { v=color.HSV_HEX(HSV=v?v:slideHSV);
    $('colorPickerPlugHex').value=v;
    HSVupdate2(v);
    return(v);

};

function HSVupdate2(v) {
    $S('colorPickerPlugCur').background='#'+v;
}

function HSVup(myColor) {
    try {
        var hsvColor = color.RGB_HSV(color.HEX_RGB(myColor));
        if ((hsvColor[0] != Number.NaN) && (hsvColor[1] != Number.NaN) && (hsvColor[2] != Number.NaN)) {
            setH(hsvColor[0]);
            setSV(hsvColor[1], hsvColor[2]);
            HSVupdate2(myColor);
            $S('colorPickerSV').backgroundColor='#'+color.HSV_HEX({H:hsvColor[0], S:100, V:100});
        }
    } catch (e) {
        // burp
    }
}

function setH(value) {
    $S('colorPickerHslide').top = (163-(value*165/360))+'px';
    slideHSV.H=value;
    HSV.H=value;
}

function setSV(sat, val) {
    $S('colorPickerSVslide').left = ((sat*165/100)-3)+'px';
    $S('colorPickerSVslide').top = (162-(val*165/100))+'px';
    slideHSV.S=sat;
    slideHSV.V=val;
    HSV.S=sat;
    HSV.V=val;
}

var _colorPickerTimeout = null;
function loadSV(colorHex, initial) { var z='', hMod = $('colorPickerHmodel');
    if (initial === true && _colorPickerTimeout != null) {
        window.clearTimeout(_colorPickerTimeout);
    }
    if (hMod == null) {
        window.clearTimeout(_colorPickerTimeout);
        _colorPickerTimeout = window.setTimeout(function() {loadSV(colorHex)}, 40);
        return;
    }
    if (/MSIE/.test(navigator.userAgent) && !window.opera) {
        try {
            if (parseFloat(navigator.userAgent.replace(/.*MSIE ([0-9.]*).*/g,"$1")) < 7) {
                // background image removen, ansonsten sieht der Filter nicht aus
                $('colorPickerSV').style.backgroundImage = 'none';
            }
        } catch (e) {
            // mist, lieber nichts machen.
        }
    }

    for(var i=165; i>=0; i--) { z+="<div style=\"background: #"+color.HSV_HEX({H:Math.round((360/165)*i), S:100, V:100})+";\"><br /><\/div>"; }
    hMod.innerHTML=z;

    $('colorPickerPlugHex').value=colorHex;
    HSVup(colorHex);
};


/* COLOR LIBRARY */

color={};

color.cords=function(W) {

    var W2=W/2, rad=(hsv.H/360)*(Math.PI*2), hyp=(hsv.S+(100-hsv.V))/100*(W2/2);

    $S('colorPickerMCur').left=Math.round(Math.abs(Math.round(Math.sin(rad)*hyp)+W2+3))+'px';
    $S('colorPickerMCur').top=Math.round(Math.abs(Math.round(Math.cos(rad)*hyp)-W2-21))+'px';

};

color.HEX=function(o) { o=Math.round(Math.min(Math.max(0,o),255));

    return("0123456789ABCDEF".charAt((o-o%16)/16)+"0123456789ABCDEF".charAt(o%16));

};

color.RGB_HEX=function(o) { var fu=color.HEX; return(fu(o.R)+fu(o.G)+fu(o.B)); };

color.HSV_RGB=function(o) {
    
    var R, G, A, B, C, S=o.S/100, V=o.V/100, H=o.H/360;

    if(S>0) { if(H>=1) H=0;

        H=6*H; F=H-Math.floor(H);
        A=Math.round(255*V*(1-S));
        B=Math.round(255*V*(1-(S*F)));
        C=Math.round(255*V*(1-(S*(1-F))));
        V=Math.round(255*V); 

        switch(Math.floor(H)) {

            case 0: R=V; G=C; B=A; break;
            case 1: R=B; G=V; B=A; break;
            case 2: R=A; G=V; B=C; break;
            case 3: R=A; G=B; B=V; break;
            case 4: R=C; G=A; B=V; break;
            case 5: R=V; G=A; B=B; break;

        }

        return({'R':R?R:0, 'G':G?G:0, 'B':B?B:0, 'A':1});

    }
    else return({'R':(V=Math.round(V*255)), 'G':V, 'B':V, 'A':1});

};

color.HSV_HEX=function(o) { return(color.RGB_HEX(color.HSV_RGB(o))); }

color.RGB_HSV=function(r) {
    var max=Math.max(r[0],r[1],r[2]),delta=max-Math.min(r[0],r[1],r[2]),H,S,V;
    if(max!=0) { S=Math.round(delta/max*100);
        if(r[0]==max) H=(r[1]-r[2])/delta; else if(r[1]==max) H=2+(r[2]-r[0])/delta; else if(r[2]==max) H=4+(r[0]-r[1])/delta;
        var H=Math.min(Math.round(H*60),360); if(H<0) H+=360;
    }
    return({0:H?H:0,1:S?S:0,2:Math.round((max/255)*100)});
}

color.HEX_RGB=function(r) {
    return({0:parseInt(r.substr(0,2),16),1:parseInt(r.substr(2,2),16),2:parseInt(r.substr(4,2),16)});
}
