/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.web.design.theme;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.business.configfile.ConfigService;
import de.justsoftware.onx.design.shared.model.ITheme;
import de.justsoftware.onx.design.shared.model.IThemeAttribute;
import de.justsoftware.onx.design.shared.model.Theme;
import de.justsoftware.onx.design.shared.model.ThemeAttribute;
import de.justsoftware.onx.design.shared.model.ThemeAttributeType;
import de.justsoftware.onx.server.resource.JucoTemplateLoader;
import de.justsoftware.web.design.theme.ThemeRenderer;
import de.justsoftware.web.design.theme.ThemeRendererImpl;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ThemeRendererImpl
implements ThemeRenderer {
    private static final Function<IThemeAttribute, LessVariable> TO_LESS_VARIABLE = new /* Unavailable Anonymous Inner Class!! */;
    private final Configuration _freemarkerConfiguration = new Configuration();
    private final ConfigService _configService;

    @Autowired
    public ThemeRendererImpl(ConfigService configService) {
        this._configService = configService;
        ClassTemplateLoader classTemplateLoader = new ClassTemplateLoader(ThemeRendererImpl.class, "templates");
        JucoTemplateLoader customLoader = new JucoTemplateLoader();
        this._freemarkerConfiguration.setTemplateLoader((TemplateLoader)new MultiTemplateLoader(new TemplateLoader[]{classTemplateLoader, customLoader}));
        this._freemarkerConfiguration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
    }

    @Nonnull
    public String renderTheme(Theme theme) throws TemplateException, IOException {
        StringWriter writer = new StringWriter();
        Template themeTemplate = this._freemarkerConfiguration.getTemplate("defaultTheme.ftl");
        themeTemplate.process((Object)this.toThemeMap(theme), (Writer)writer);
        return writer.toString();
    }

    public String renderTemplateWithGlobalVariables(Theme theme, String templateName) throws TemplateException, IOException {
        StringWriter writer = new StringWriter();
        Template themeTemplate = this._freemarkerConfiguration.getTemplate(templateName);
        ImmutableList globalVariables = FluentIterable.from((Iterable)theme.getThemeAttributes()).transform(TO_LESS_VARIABLE).toList();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("__globalAttributes__", globalVariables);
        for (LessVariable globalVariable : globalVariables) {
            model.put(globalVariable.getName(), globalVariable.getValue());
        }
        themeTemplate.process(model, (Writer)writer);
        return writer.toString();
    }

    @Nonnull
    private ImmutableMap<String, LessVariable> computeVariablesFromConfiguration(Theme theme) {
        ImmutableMap.Builder variableBuilder = ImmutableMap.builder();
        ThemeAttribute brandLogoAttribute = theme.getAttribute(ThemeAttributeType.BRAND_LOGO);
        String brandLogoWidth = brandLogoAttribute == null || brandLogoAttribute.getValue() == null ? "0" : "280px + @header-item-padding";
        variableBuilder.put((Object)"brandLogoWidth", (Object)new LessVariable("brandLogoWidth", brandLogoWidth)).put((Object)"calendarIconWidth", (Object)new LessVariable("calendarIconWidth", "0"));
        return variableBuilder.build();
    }

    @Nonnull
    private Map<String, Object> toThemeMap(Theme theme) {
        HashMap map = Maps.newHashMap();
        map.put("id", theme.getId());
        map.put("responsiveHeaderVars", this.computeVariablesFromConfiguration(theme));
        FluentIterable lessVariables = FluentIterable.from((Iterable)theme.getThemeAttributes()).transform(TO_LESS_VARIABLE);
        for (LessVariable var : lessVariables) {
            map.put(var.getName(), var.getValue());
        }
        return map;
    }

    public ImmutableMap<String, String> toGlobalAttributeMap(ITheme theme) {
        ImmutableMap themeVariables = FluentIterable.from((Iterable)theme.getThemeAttributes()).filter(IThemeAttribute.GLOBAL_VARIABLE).transform(TO_LESS_VARIABLE).filter(Objects::nonNull).uniqueIndex(LessVariable::getName);
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)themeVariables, LessVariable::getValue));
    }
}

