/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.persistence.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.justsoftware.permission.persistence.DAOSupport;
import de.justsoftware.permission.persistence.SqlBuilder;
import de.justsoftware.permission.persistence.jdbc.DAOSupportImpl;
import java.util.List;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class DAOSupportImpl
implements DAOSupport {
    private final JdbcTemplate _jdbcTemplate;

    public DAOSupportImpl(JdbcTemplate jdbcTemplate) {
        this._jdbcTemplate = jdbcTemplate;
    }

    public <T> int[] batchUpdate(String sql, Iterable<? extends T> params, Iterable<? extends Function<? super T, ?>> rowFunctions) {
        ImmutableList batchArgs = (ImmutableList)Streams.stream(params).map(v -> Streams.stream((Iterable)rowFunctions).map(f -> f.apply(v)).toArray()).collect(ImmutableList.toImmutableList());
        return this._jdbcTemplate.batchUpdate(sql, (List)batchArgs);
    }

    public SqlBuilder prep() {
        return new SqlBuilderImpl(this);
    }
}

