/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.rest;

import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import de.justsoftware.news.auth.AuthSettingsService;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.connector.permission.PermissionConnector;
import de.justsoftware.news.domain.event.EventService;
import de.justsoftware.news.domain.poll.CsvExport;
import de.justsoftware.news.domain.poll.PollCsvExportService;
import de.justsoftware.news.domain.poll.PollExportLanguage;
import de.justsoftware.news.id.EventId;
import de.justsoftware.news.id.PollId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.id.TenantId;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0011\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J*\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\b\u0010\u0017\u001a\u00020\u0018H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/news/rest/ExternalController;", "", "authSettingsService", "Lde/justsoftware/news/auth/AuthSettingsService;", "eventService", "Lde/justsoftware/news/domain/event/EventService;", "permissionConnector", "Lde/justsoftware/news/connector/permission/PermissionConnector;", "pollCsvExportService", "Lde/justsoftware/news/domain/poll/PollCsvExportService;", "<init>", "(Lde/justsoftware/news/auth/AuthSettingsService;Lde/justsoftware/news/domain/event/EventService;Lde/justsoftware/news/connector/permission/PermissionConnector;Lde/justsoftware/news/domain/poll/PollCsvExportService;)V", "exportPollCsvFile", "Lorg/springframework/http/ResponseEntity;", "", "eventId", "Lde/justsoftware/news/id/EventId;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "id", "Lde/justsoftware/news/id/PollId;", "language", "Lde/justsoftware/news/domain/poll/PollExportLanguage;", "buildAuthContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "news-service"})
public class ExternalController {
    @NotNull
    private final AuthSettingsService authSettingsService;
    @NotNull
    private final EventService eventService;
    @NotNull
    private final PermissionConnector permissionConnector;
    @NotNull
    private final PollCsvExportService pollCsvExportService;

    public ExternalController(@NotNull AuthSettingsService authSettingsService, @NotNull EventService eventService, @NotNull PermissionConnector permissionConnector, @NotNull PollCsvExportService pollCsvExportService) {
        Intrinsics.checkNotNullParameter((Object)authSettingsService, (String)"authSettingsService");
        Intrinsics.checkNotNullParameter((Object)eventService, (String)"eventService");
        Intrinsics.checkNotNullParameter((Object)permissionConnector, (String)"permissionConnector");
        Intrinsics.checkNotNullParameter((Object)pollCsvExportService, (String)"pollCsvExportService");
        this.authSettingsService = authSettingsService;
        this.eventService = eventService;
        this.permissionConnector = permissionConnector;
        this.pollCsvExportService = pollCsvExportService;
    }

    @GetMapping(value={"/event/{eventId}/ics-export"})
    @NotNull
    public ResponseEntity<byte[]> exportPollCsvFile(@PathVariable @NotNull EventId eventId, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String icsString = this.eventService.exportIcs(eventId, this.buildAuthContext());
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        responseHeaders.setContentDisposition(ContentDisposition.builder((String)"attachment").filename(eventId.getValue() + ".ics").build());
        String string = icsString;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return new ResponseEntity((Object)byArray, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/poll/{id}/csv-export"})
    @NotNull
    public ResponseEntity<Object> exportPollCsvFile(@PathVariable @NotNull PollId id, @RequestParam(value="language") @NotNull PollExportLanguage language, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        CsvExport export = this.pollCsvExportService.export(id, language, this.buildAuthContext());
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Type", "text/csv");
        String titleEncoded = URLEncoder.encode(((Object)StringsKt.trim((CharSequence)export.getPostTitle())).toString(), "UTF-8");
        responseHeaders.add("Content-Disposition", "attachment; filename=" + titleEncoded + ".csv");
        String string = export.getCsvContent();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return new ResponseEntity((Object)byArray, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    private AuthorizationContext buildAuthContext() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Intrinsics.checkNotNull((Object)authentication, (String)"null cannot be cast to non-null type de.justsoftware.jwtfilter.JwtAuthenticationToken");
        JwtAuthenticationToken jwt = (JwtAuthenticationToken)authentication;
        return new AuthorizationContext(TenantId.Companion.fromString(String.valueOf(jwt.getCustomJwtClaims().get((Object)"tenantId"))), ProfileId.Companion.fromString(jwt.getPrincipal().toString()), this.authSettingsService, this.permissionConnector);
    }
}

