/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.comment;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.DgsQuery;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.attachment.AttachmentDataLoader;
import de.justsoftware.news.domain.comment.AllowedActionsDataLoader;
import de.justsoftware.news.domain.comment.CommentIdWithSortOrder;
import de.justsoftware.news.domain.comment.CommentTextInput;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.domain.comment.PostCommentAction;
import de.justsoftware.news.domain.comment.PostCommentDataFetcherKt;
import de.justsoftware.news.domain.comment.PostCommentService;
import de.justsoftware.news.domain.comment.Reference;
import de.justsoftware.news.domain.comment.ResponsesDataLoader;
import de.justsoftware.news.domain.delete.DeleteService;
import de.justsoftware.news.domain.reaction.ReactionDataLoader;
import de.justsoftware.news.domain.user.ProfileDataLoader;
import de.justsoftware.news.graphql.generated.types.AddCommentInput;
import de.justsoftware.news.graphql.generated.types.Attachment;
import de.justsoftware.news.graphql.generated.types.Comment;
import de.justsoftware.news.graphql.generated.types.Likes;
import de.justsoftware.news.graphql.generated.types.PostCommentReference;
import de.justsoftware.news.graphql.generated.types.Profile;
import de.justsoftware.news.graphql.generated.types.Reaction;
import de.justsoftware.news.graphql.generated.types.UpdateCommentInput;
import de.justsoftware.news.id.CommentId;
import de.justsoftware.news.id.CommentableId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.util.Sort;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DgsComponent
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010\u0011\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0017J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\t2\b\b\u0001\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0017J\u001c\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00152\u0006\u0010\f\u001a\u00020\rH\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00152\u0006\u0010\f\u001a\u00020\rH\u0017J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00152\u0006\u0010\f\u001a\u00020\rH\u0017J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00152\u0006\u0010\f\u001a\u00020\rH\u0017J\u001c\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u00152\u0006\u0010\f\u001a\u00020\rH\u0017J$\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00160\u00152\u0006\u0010\"\u001a\u00020#2\u0006\u0010\f\u001a\u00020\rH\u0017J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\f\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lde/justsoftware/news/domain/comment/PostCommentDataFetcher;", "", "commentService", "Lde/justsoftware/news/domain/comment/PostCommentService;", "deleteService", "Lde/justsoftware/news/domain/delete/DeleteService;", "<init>", "(Lde/justsoftware/news/domain/comment/PostCommentService;Lde/justsoftware/news/domain/delete/DeleteService;)V", "addComment", "Lde/justsoftware/news/graphql/generated/types/Comment;", "input", "Lde/justsoftware/news/graphql/generated/types/AddCommentInput;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "deleteComment", "Lde/justsoftware/news/id/CommentId;", "id", "updateComment", "Lde/justsoftware/news/graphql/generated/types/UpdateCommentInput;", "comment", "attachments", "Ljava/util/concurrent/CompletableFuture;", "", "Lde/justsoftware/news/graphql/generated/types/Attachment;", "author", "Lde/justsoftware/news/graphql/generated/types/Profile;", "reference", "Lde/justsoftware/news/graphql/generated/types/PostCommentReference;", "reactions", "Lde/justsoftware/news/graphql/generated/types/Reaction;", "allowedActions", "", "Lde/justsoftware/news/domain/comment/PostCommentAction;", "responses", "sort", "Lde/justsoftware/news/util/Sort;", "likes", "Lgraphql/execution/DataFetcherResult;", "Lde/justsoftware/news/graphql/generated/types/Likes;", "news-service"})
public class PostCommentDataFetcher {
    @NotNull
    private final PostCommentService commentService;
    @NotNull
    private final DeleteService deleteService;

    public PostCommentDataFetcher(@NotNull PostCommentService commentService, @NotNull DeleteService deleteService) {
        Intrinsics.checkNotNullParameter((Object)commentService, (String)"commentService");
        Intrinsics.checkNotNullParameter((Object)deleteService, (String)"deleteService");
        this.commentService = commentService;
        this.deleteService = deleteService;
    }

    @DgsMutation(field="addComment")
    @NotNull
    public Comment addComment(@InputArgument @NotNull AddCommentInput input, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        PostCommentService postCommentService = this.commentService;
        PostId postId = input.getPostId();
        de.justsoftware.news.graphql.generated.types.CommentTextInput commentTextInput = input.getText();
        CommentTextInput commentTextInput2 = commentTextInput != null ? PostCommentDataFetcherKt.toDomain((de.justsoftware.news.graphql.generated.types.CommentTextInput)commentTextInput) : null;
        CommentId commentId = input.getReferenceId();
        List list = input.getAttachmentIds();
        AuthorizationContext authorizationContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        return PostCommentDataFetcherKt.toGql((PostComment)postCommentService.createComment(postId, commentTextInput2, list, (CommentableId)commentId, authorizationContext));
    }

    @DgsMutation(field="deleteComment")
    @NotNull
    public CommentId deleteComment(@InputArgument @NotNull CommentId id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return this.deleteService.markCommentAsDeleted(id, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
    }

    @DgsMutation(field="updateComment")
    @NotNull
    public Comment updateComment(@InputArgument @NotNull UpdateCommentInput input, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        de.justsoftware.news.graphql.generated.types.CommentTextInput commentTextInput = input.getText();
        return PostCommentDataFetcherKt.toGql((PostComment)this.commentService.update(input.getCommentId(), input.getAttachmentIds(), (CommentTextInput)(commentTextInput != null ? PostCommentDataFetcherKt.toDomain((de.justsoftware.news.graphql.generated.types.CommentTextInput)commentTextInput) : null), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsQuery(field="comment")
    @Nullable
    public Comment comment(@InputArgument @NotNull CommentId id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        PostComment postComment = this.commentService.findById(id, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        return postComment != null ? PostCommentDataFetcherKt.toGql((PostComment)postComment) : null;
    }

    @DgsData(parentType="Comment", field="attachments")
    @NotNull
    public CompletableFuture<List<Attachment>> attachments(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(AttachmentDataLoader.class);
        CommentId commentId = ((Comment)dfe.getSourceOrThrow()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)commentId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Comment", field="author")
    @NotNull
    public CompletableFuture<Profile> author(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ProfileDataLoader.class);
        ProfileId authorId = ((Comment)dfe.getSourceOrThrow()).getAuthorId();
        CompletableFuture completableFuture = dataLoader.load((Object)authorId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Comment", field="reference")
    @NotNull
    public CompletableFuture<PostCommentReference> reference(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(Reference.class);
        String referenceId = ((Comment)dfe.getSourceOrThrow()).getReferenceId();
        CompletableFuture completableFuture = dataLoader.load((Object)CommentableId.Companion.fromString(referenceId));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Comment", field="reactions")
    @NotNull
    public CompletableFuture<Reaction> reactions(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ReactionDataLoader.class);
        CommentId commentId = ((Comment)dfe.getSourceOrThrow()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)commentId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Comment", field="allowedActions")
    @NotNull
    public CompletableFuture<Set<PostCommentAction>> allowedActions(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Comment comment = (Comment)dfe.getSourceOrThrow();
        DataLoader dataLoader = dfe.getDataLoader(AllowedActionsDataLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)comment);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Comment", field="responses")
    @NotNull
    public CompletableFuture<List<Comment>> responses(@NotNull Sort sort, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        CommentId commentId = ((Comment)dfe.getSourceOrThrow()).getId();
        DataLoader dataLoader = dfe.getDataLoader(ResponsesDataLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)new CommentIdWithSortOrder(commentId, sort));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Comment", field="likes")
    @NotNull
    public DataFetcherResult<Likes> likes(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataFetcherResult dataFetcherResult = DataFetcherResult.newResult().data((Object)new Likes(null, null, null, 7, null)).localContext((Object)((Comment)dfe.getSourceOrThrow()).getId()).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataFetcherResult, (String)"build(...)");
        return dataFetcherResult;
    }
}

