/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.wiki.service;

import de.justsoftware.mobile.gateway.toro.model.TranslationLanguage;
import de.justsoftware.mobile.gateway.toro.service.ToroApiGatewayService;
import de.justsoftware.mobile.gateway.util.ListsKt;
import de.justsoftware.mobile.gateway.wiki.generated.fragment.SubscriptionFragment;
import de.justsoftware.mobile.gateway.wiki.generated.fragment.WikiArticleFragment;
import de.justsoftware.mobile.gateway.wiki.generated.fragment.WikiChapterFragment;
import de.justsoftware.mobile.gateway.wiki.generated.fragment.WikiFragment;
import de.justsoftware.mobile.gateway.wiki.model.SubscribedWikiItem;
import de.justsoftware.mobile.gateway.wiki.model.Subscription;
import de.justsoftware.mobile.gateway.wiki.model.Wiki;
import de.justsoftware.mobile.gateway.wiki.model.WikiArticle;
import de.justsoftware.mobile.gateway.wiki.model.WikiArticleContent;
import de.justsoftware.mobile.gateway.wiki.model.WikiArticleTranslation;
import de.justsoftware.mobile.gateway.wiki.model.WikiChapter;
import de.justsoftware.mobile.gateway.wiki.model.WikiTeaser;
import de.justsoftware.mobile.gateway.wiki.service.WikiApiGatewayService;
import de.justsoftware.mobile.gateway.wiki.service.WikiService;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0013H\u0016J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lde/justsoftware/mobile/gateway/wiki/service/WikiService;", "", "wikiApiGatewayService", "Lde/justsoftware/mobile/gateway/wiki/service/WikiApiGatewayService;", "toroApiGatewayService", "Lde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService;", "<init>", "(Lde/justsoftware/mobile/gateway/wiki/service/WikiApiGatewayService;Lde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService;)V", "getWikiTeasers", "", "Lde/justsoftware/mobile/gateway/wiki/model/WikiTeaser;", "offset", "", "limit", "getSubscribedWikiItems", "Lde/justsoftware/mobile/gateway/wiki/model/SubscribedWikiItem;", "getWiki", "Lde/justsoftware/mobile/gateway/wiki/model/Wiki;", "wikiId", "", "subscribe", "Lde/justsoftware/mobile/gateway/wiki/model/Subscription;", "unsubscribe", "getWikiChapter", "Lde/justsoftware/mobile/gateway/wiki/model/WikiChapter;", "chapterId", "getWikiArticle", "Lde/justsoftware/mobile/gateway/wiki/model/WikiArticle;", "articleId", "translateWikiArticle", "Lde/justsoftware/mobile/gateway/wiki/model/WikiArticleTranslation;", "targetLanguage", "Lde/justsoftware/mobile/gateway/toro/model/TranslationLanguage;", "content", "Lde/justsoftware/mobile/gateway/wiki/model/WikiArticleContent;", "Companion", "mobile-gateway"})
public class WikiService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WikiApiGatewayService wikiApiGatewayService;
    @NotNull
    private final ToroApiGatewayService toroApiGatewayService;
    private static final int WIKI_MAX_SIZE = 200;

    public WikiService(@NotNull WikiApiGatewayService wikiApiGatewayService, @NotNull ToroApiGatewayService toroApiGatewayService) {
        Intrinsics.checkNotNullParameter((Object)wikiApiGatewayService, (String)"wikiApiGatewayService");
        Intrinsics.checkNotNullParameter((Object)toroApiGatewayService, (String)"toroApiGatewayService");
        this.wikiApiGatewayService = wikiApiGatewayService;
        this.toroApiGatewayService = toroApiGatewayService;
    }

    @NotNull
    public List<WikiTeaser> getWikiTeasers(int offset, int limit) {
        return ListsKt.page((List)WikiTeaser.Companion.sort(WikiTeaser.Companion.toWikiTeasers(this.wikiApiGatewayService.getWikiTeasers(200))), (int)offset, (int)limit);
    }

    @NotNull
    public List<SubscribedWikiItem> getSubscribedWikiItems(int offset, int limit) {
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @Nullable
    public Wiki getWiki(@NotNull String wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        WikiFragment wikiFragment = this.wikiApiGatewayService.getWiki(wikiId);
        return wikiFragment != null ? Wiki.Companion.toWiki(wikiFragment) : null;
    }

    @Nullable
    public Subscription subscribe(@NotNull String wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        SubscriptionFragment subscriptionFragment = this.wikiApiGatewayService.subscribe(wikiId);
        return subscriptionFragment != null ? Subscription.Companion.toSubscription(subscriptionFragment) : null;
    }

    @Nullable
    public Subscription unsubscribe(@NotNull String wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        SubscriptionFragment subscriptionFragment = this.wikiApiGatewayService.unsubscribe(wikiId);
        return subscriptionFragment != null ? Subscription.Companion.toSubscription(subscriptionFragment) : null;
    }

    @Nullable
    public WikiChapter getWikiChapter(@NotNull String chapterId) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        WikiChapterFragment wikiChapterFragment = this.wikiApiGatewayService.getWikiChapter(chapterId);
        return wikiChapterFragment != null ? WikiChapter.Companion.toWikiChapter(wikiChapterFragment) : null;
    }

    @Nullable
    public WikiArticle getWikiArticle(@NotNull String articleId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        boolean translationEnabled = this.toroApiGatewayService.getTranslationEnabled();
        WikiArticleFragment wikiArticleFragment = this.wikiApiGatewayService.getWikiArticle(articleId);
        return wikiArticleFragment != null ? WikiArticle.Companion.toWikiArticle(wikiArticleFragment, translationEnabled) : null;
    }

    @NotNull
    public WikiArticleTranslation translateWikiArticle(@NotNull String articleId, @NotNull TranslationLanguage targetLanguage, @NotNull WikiArticleContent content) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        WikiArticleTranslation input = new WikiArticleTranslation(articleId, targetLanguage, content);
        List translations = this.toroApiGatewayService.translate(targetLanguage, Companion.access$toApiTranslationInputs((Companion)Companion, (WikiArticleTranslation)input));
        return Companion.access$translate((Companion)Companion, (WikiArticleTranslation)input, (List)translations);
    }

    public static final /* synthetic */ WikiApiGatewayService access$getWikiApiGatewayService$p(WikiService $this) {
        return $this.wikiApiGatewayService;
    }
}

