/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security.oauth2;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import de.justsoftware.gateway.config.FeatureToggleService;
import de.justsoftware.gateway.domain.idp.JustClientRegistration;
import de.justsoftware.gateway.domain.idp.JustClientRegistrationRepository;
import de.justsoftware.gateway.security.oauth2.ClientTarget;
import de.justsoftware.gateway.security.oauth2.JustLoginClients;
import de.justsoftware.gateway.security.oauth2.JustLoginHelper;
import de.justsoftware.gateway.security.oauth2.JustOauthLoginAuthenticationEntryPoint;
import de.justsoftware.gateway.security.oauth2.JwtAuthenticationManagerFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class JustClientRegistrationService
implements ReactiveClientRegistrationRepository {
    private static final Logger LOG = LoggerFactory.getLogger(JustClientRegistrationService.class);
    private static final int EXTERNAL_IDP_CONFIG_CACHE_LIFETIME_IN_MINUTES = 60;
    private final ConcurrentHashMap<String, ReactiveAuthenticationManager> _authenticationManagers = new ConcurrentHashMap();
    private final JustOauthLoginAuthenticationEntryPoint _justOauthLoginAuthenticationEntryPoint;
    private final JwtAuthenticationManagerFactory _jwtAuthenticationManagerFactory;
    private final JustClientRegistrationRepository _repository;
    private final JustLoginClients _justLoginClients;
    private final FeatureToggleService _featureToggleService;
    private final LoadingCache<ClientTarget, Mono<Boolean>> _externalIdpConfiguredCache;
    private final LoadingCache<String, Mono<ClientRegistration>> _clientRegistrationCache;
    private final AtomicBoolean _ready = new AtomicBoolean(false);

    @SuppressFBWarnings(value={"MC", "CT"}, justification="would need refactoring that should not be part of this commit")
    public JustClientRegistrationService(JustOauthLoginAuthenticationEntryPoint justOauthLoginAuthenticationEntryPoint, JwtAuthenticationManagerFactory decoderFactory, JustClientRegistrationRepository repository, JustLoginClients justLoginClients, FeatureToggleService featureToggleService) {
        this._justOauthLoginAuthenticationEntryPoint = justOauthLoginAuthenticationEntryPoint;
        this._repository = repository;
        this._justLoginClients = justLoginClients;
        this._jwtAuthenticationManagerFactory = decoderFactory;
        this._featureToggleService = featureToggleService;
        this._externalIdpConfiguredCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(60L)).build(arg_0 -> this.updateEntryPoint(arg_0));
        this._clientRegistrationCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(1L)).build(registrationId -> this._repository.findById(registrationId).map(JustClientRegistration::toClientRegistration));
    }

    @EventListener
    public void handleRefreshEvent(RefreshEvent event) {
        if (this._ready.get()) {
            this.init();
        }
    }

    @EventListener
    public void handleContextRefreshEvent(ApplicationReadyEvent event) {
        this.init();
        this._ready.compareAndSet(false, true);
        LOG.info("ready: {}", (Object)this._ready.get());
    }

    private void init() {
        LOG.info("init registrations");
        this._repository.save(this._justLoginClients.getToroDesktopClient()).subscribe();
        this._repository.save(this._justLoginClients.getToroMobileClient()).subscribe();
        this._repository.deleteById((Object)"just-auth-login").subscribe();
        this._repository.deleteById((Object)"just-auth-mobile-login").subscribe();
        this.refresh().subscribe();
    }

    @Nonnull
    private static Predicate<ClientRegistration> clientsForTarget(ClientTarget target) {
        return r -> {
            Object targetsObject = r.getProviderDetails().getConfigurationMetadata().get("targets");
            if (targetsObject instanceof Set) {
                return ((Set)targetsObject).contains(target);
            }
            return false;
        };
    }

    private static boolean isDefault(ClientRegistration r) {
        return ((Object)r.getProviderDetails().getConfigurationMetadata().getOrDefault("defaultProvider", false)).equals(Boolean.TRUE);
    }

    public Mono<ClientRegistration> findByRegistrationId(String registrationId) {
        return (Mono)this._clientRegistrationCache.get((Object)registrationId);
    }

    @Nonnull
    private Mono<Void> updateAuthenticationManagers() {
        Set currentlyActiveIssuers = this._authenticationManagers.keySet();
        return this._repository.findAll().map(JustClientRegistration::toClientRegistration).filter(it -> it.getProviderDetails().getIssuerUri() != null).map(it -> it.getProviderDetails().getIssuerUri()).filter(Predicate.not(String::isBlank)).collect(Collectors.toSet()).doOnSuccess(requiredIssuers -> {
            requiredIssuers.forEach(arg_0 -> this.addManager(arg_0));
            currentlyActiveIssuers.forEach(uri -> {
                if (!requiredIssuers.contains(uri)) {
                    LOG.info("removing authManager for {}", uri);
                    this._authenticationManagers.remove(uri);
                }
            });
        }).then();
    }

    private void addManager(String issuerUri) {
        if (this._authenticationManagers.containsKey(issuerUri)) {
            return;
        }
        LOG.info("adding issuer for uri {}", (Object)issuerUri);
        try {
            ReactiveAuthenticationManager manager = this._jwtAuthenticationManagerFactory.fromIssuerLocation(issuerUri);
            String key = this.getHostResolverKeyFromIssuer(issuerUri);
            if (key != null) {
                this._authenticationManagers.put(key, manager);
            } else {
                LOG.error("could not resolve reolverKey for issuer {}", (Object)issuerUri);
            }
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Authentication manager for issuer-location {} could not be added.", (Object)issuerUri, (Object)e);
        }
    }

    @Nonnull
    public Mono<ClientRegistration> findByClientId(String clientId, String issuer) {
        return Mono.from((Publisher)this._repository.findByClientIdAndIssuerUri(clientId, issuer)).map(JustClientRegistration::toClientRegistration);
    }

    @Nonnull
    public Mono<ReactiveAuthenticationManager> resolve(String issuer) {
        return Mono.justOrEmpty((Object)this.getHostResolverKeyFromIssuer(issuer)).filter(Predicate.not(String::isEmpty)).mapNotNull(this._authenticationManagers::get);
    }

    @CheckForNull
    private String getHostResolverKeyFromIssuer(@Nullable String issuer) {
        if (issuer == null) {
            return null;
        }
        try {
            return new URL(issuer).toExternalForm();
        }
        catch (MalformedURLException e) {
            LOG.warn("malformed issuer: " + issuer, (Throwable)e);
            return null;
        }
    }

    @Nonnull
    public Mono<Void> save(ClientRegistration registration) {
        LOG.info("save: {} - {}", (Object)registration.getRegistrationId(), (Object)registration.getProviderDetails().getIssuerUri());
        return this._repository.save(registration).then(this.refresh()).then();
    }

    @Nonnull
    public Mono<Void> refresh() {
        this._clientRegistrationCache.invalidateAll();
        this._externalIdpConfiguredCache.invalidateAll();
        return this.updateAuthenticationManagers().then(this.updateEntryPoint(ClientTarget.DESKTOP)).then();
    }

    @Nonnull
    private Mono<Boolean> updateEntryPoint(ClientTarget target) {
        return this.getDefaultDesktopClient().map(client -> {
            this._justOauthLoginAuthenticationEntryPoint.setDefaultIdp(client);
            return true;
        }).switchIfEmpty(Mono.defer(() -> {
            this._justOauthLoginAuthenticationEntryPoint.setDefaultIdp(null);
            return Mono.just((Object)Boolean.FALSE);
        }));
    }

    @Nonnull
    public Mono<Void> delete(String clientRegistrationId) {
        LOG.info("delete: {}", (Object)clientRegistrationId);
        return this._repository.deleteById((Object)clientRegistrationId).then(this.refresh()).then();
    }

    @Nonnull
    public ClientRegistration getJustMobileClientRegistration() {
        return this._justLoginClients.getToroMobileClient();
    }

    @Nonnull
    public Mono<ClientRegistration> getMobileClientRegistrationForTarget(ClientTarget target) {
        return this._repository.findAll().map(JustClientRegistration::toClientRegistration).filter(JustClientRegistrationService.clientsForTarget((ClientTarget)target)).filter(r -> !JustLoginHelper.isJustIdp((String)r.getRegistrationId())).next().switchIfEmpty(Mono.just((Object)this.getJustMobileClientRegistration()));
    }

    @Nonnull
    public Mono<List<ClientRegistration>> getAllDesktopClients() {
        return this._repository.findAll().map(JustClientRegistration::toClientRegistration).filter(JustClientRegistrationService.clientsForTarget((ClientTarget)ClientTarget.DESKTOP)).collectList();
    }

    @Nonnull
    private Mono<ClientRegistration> getDefaultDesktopClient() {
        return this._repository.findAll().map(JustClientRegistration::toClientRegistration).filter(JustClientRegistrationService.clientsForTarget((ClientTarget)ClientTarget.DESKTOP)).filter(JustClientRegistrationService::isDefault).switchIfEmpty(subscriber -> {
            if (this._featureToggleService.isMfaEnabled()) {
                subscriber.onNext((Object)this._justLoginClients.getToroDesktopClient());
            }
            subscriber.onComplete();
        }).next();
    }

    @Nonnull
    public Mono<Boolean> isDesktopIdpConfigured() {
        return (Mono)this._externalIdpConfiguredCache.get((Object)ClientTarget.DESKTOP);
    }
}

