/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security;

import de.justsoftware.gateway.domain.login.UserLogin;
import de.justsoftware.gateway.domain.login.UserLoginRepository;
import de.justsoftware.gateway.ids.ProfileId;
import de.justsoftware.gateway.ids.TenantId;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
@ParametersAreNonnullByDefault
public class UserLoginService {
    private static final Logger LOG = LoggerFactory.getLogger(UserLoginService.class);
    private static final Duration DURATION_TO_KEEP_EXPIRED_LOGINS = Duration.ofDays(7L);
    private final UserLoginRepository _userLoginRepository;
    private final Duration _userLoginTtl;

    public UserLoginService(UserLoginRepository userLoginRepository, @Value(value="${just.gateway.userlogin.ttl}") Duration userLoginTtl) {
        this._userLoginRepository = userLoginRepository;
        this._userLoginTtl = userLoginTtl;
    }

    @Nonnull
    public Mono<UserLogin> saveLogin(ProfileId profileId, TenantId tenantId, OAuth2AuthenticationToken token) {
        UserLogin.UserLoginBuilder userLoginBuilder = UserLogin.builder().profileId(profileId).tenantId(tenantId).registrationId(token.getAuthorizedClientRegistrationId());
        this.addTokenInformation(userLoginBuilder, token);
        return this._userLoginRepository.save((Object)userLoginBuilder.build());
    }

    private void addTokenInformation(UserLogin.UserLoginBuilder builder, OAuth2AuthenticationToken token) {
        OAuth2User principal = token.getPrincipal();
        builder.expiresAt(Instant.now().plus(this._userLoginTtl));
        if (principal instanceof OidcUser) {
            OidcUser oidcUser = (OidcUser)principal;
            builder.idToken(oidcUser.getIdToken().getTokenValue());
            Instant expiresAt = oidcUser.getIdToken().getExpiresAt();
            if (expiresAt != null) {
                builder.expiresAt(expiresAt);
            }
        }
    }

    @Scheduled(fixedRate=7L, timeUnit=TimeUnit.DAYS)
    public void cleanUpOldLogins() {
        this._userLoginRepository.deleteByExpiresAtBefore(Instant.now().minus(DURATION_TO_KEEP_EXPIRED_LOGINS)).subscribe(deleted -> LOG.info("deleted {} expired logins", deleted));
    }
}

