/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.share.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.shares.SharesService;
import de.justsoftware.drive.common.accessrequest.model.AccessRequestBO;
import de.justsoftware.drive.common.authorization.model.SharePrivilege;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.shares.model.ShareBO;
import de.justsoftware.drive.common.usergroup.model.UserGroupId;
import de.justsoftware.drive.common.util.EntryCollectors;
import de.justsoftware.drive.common.util.EntryStream;
import de.justsoftware.drive.rest.accessrequest.AccessRequestFrontendService;
import de.justsoftware.drive.rest.models.Item;
import de.justsoftware.drive.rest.models.Person;
import de.justsoftware.drive.rest.models.Share;
import de.justsoftware.drive.rest.models.ShareDetails;
import de.justsoftware.drive.rest.models.SharePermission;
import de.justsoftware.drive.rest.models.UserGroup;
import de.justsoftware.drive.rest.person.PersonFrontendService;
import de.justsoftware.drive.rest.share.SharesFrontendService;
import de.justsoftware.drive.rest.usergroup.UserGroupFrontendService;
import de.justsoftware.permission.client.model.Role;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class SharesFrontendServiceImpl
implements SharesFrontendService {
    private final SharesService _sharesService;
    private final AccessRequestFrontendService _accessRequestFrontendService;
    private final PersonFrontendService _personFrontendService;
    private final UserGroupFrontendService _userGroupFrontendService;

    @Autowired
    public SharesFrontendServiceImpl(SharesService sharesService, AccessRequestFrontendService accessRequestFrontendService, PersonFrontendService personFrontendService, UserGroupFrontendService userGroupFrontendService) {
        this._sharesService = sharesService;
        this._accessRequestFrontendService = accessRequestFrontendService;
        this._personFrontendService = personFrontendService;
        this._userGroupFrontendService = userGroupFrontendService;
    }

    public ImmutableList<Share> convertShareBOs(Iterable<ItemBO> shares) {
        ImmutableMap rootFolderIds = this._sharesService.getRootFolderIds((Set)FluentIterable.from(shares).transform(ItemBO::getId).toSet());
        return FluentIterable.from(shares).transform(share -> SharesFrontendServiceImpl.convertToShare((ItemBO)share, (DocumentId)((DocumentId)rootFolderIds.get((Object)share.getId())), (boolean)false)).filter(Objects::nonNull).toList();
    }

    public ImmutableList<Share> convertShareBOs(Iterable<ItemBO> shares, Set<ItemBO> subscribedShares) {
        ImmutableMap rootFolderIds = this._sharesService.getRootFolderIds((Set)FluentIterable.from(shares).transform(ItemBO::getId).toSet());
        return FluentIterable.from(shares).transform(share -> SharesFrontendServiceImpl.convertToShare((ItemBO)share, (DocumentId)((DocumentId)rootFolderIds.get((Object)share.getId())), (boolean)subscribedShares.contains(share))).filter(Objects::nonNull).toList();
    }

    @CheckForNull
    private static Share convertToShare(ItemBO share, @Nullable DocumentId rootFolderId, boolean subscribed) {
        return rootFolderId != null ? new Share(new Item(share.getId(), share.getName()), rootFolderId, subscribed) : null;
    }

    public ImmutableMap<Role, SharePrivilege> convertMembers(Map<String, SharePermission> members) {
        ImmutableMap convertedMembers = (ImmutableMap)EntryStream.from(members).mapKey(Role::create).mapValue(SharePermission::getPrivilege).collect(EntryCollectors.toImmutableMap());
        ImmutableSet illegalRoles = (ImmutableSet)convertedMembers.keySet().stream().filter(role -> !role.isProfileRole() && !role.isUserGroupRole() && !role.isTenantRole()).collect(ImmutableSet.toImmutableSet());
        if (!illegalRoles.isEmpty()) {
            throw new IllegalArgumentException(String.format("Unexpected roles: %s", Joiner.on((String)", ").join((Iterable)illegalRoles)));
        }
        return convertedMembers;
    }

    public ShareDetails convertShareBO(ShareBO shareBO) {
        ImmutableSet.Builder personIds = ImmutableSet.builder();
        ImmutableSet.Builder userGroupIds = ImmutableSet.builder();
        shareBO.getPermissions().forEach((role, action) -> {
            role.getProfileId().ifPresent(aLong -> personIds.add((Object)new PersonId(aLong.longValue())));
            role.getUserGroupId().ifPresent(aUuid -> userGroupIds.add((Object)new UserGroupId(aUuid)));
        });
        ImmutableMap persons = this._personFrontendService.getFrontendPersons((Set)personIds.build());
        ImmutableMap userGroups = this._userGroupFrontendService.getUserGroupsByIds((Set)userGroupIds.build());
        ImmutableList permissionDetails = (ImmutableList)EntryStream.from((Map)shareBO.getPermissions()).mapKey(key -> this.toShareRole(key, persons, userGroups)).filterKey(Optional::isPresent).map((role, permission) -> new ShareDetails.PermissionDetails(SharePermission.valueOf((SharePrivilege)permission), (ShareDetails.ShareRoleDetails)role.get())).collect(ImmutableList.toImmutableList());
        return new ShareDetails(shareBO.getId(), shareBO.getName(), (List)permissionDetails);
    }

    public ImmutableList<Person> getRequestingUsersFromAccessRequests(ImmutableSet<AccessRequestBO> pendingRequests) {
        return this._accessRequestFrontendService.convertToRequestingUsers(pendingRequests);
    }

    @Nonnull
    private Optional<ShareDetails.ShareRoleDetails> toShareRole(Role role, ImmutableMap<PersonId, Person> allPersons, ImmutableMap<UserGroupId, UserGroup> userGroups) {
        Optional profileId = role.getProfileId();
        if (profileId.isPresent()) {
            return Optional.of((ShareDetails.ShareRoleDetails)allPersons.get((Object)new PersonId(((Long)profileId.get()).longValue())));
        }
        Optional userGroupId = role.getUserGroupId();
        if (userGroupId.isPresent()) {
            return Optional.of((ShareDetails.ShareRoleDetails)userGroups.get((Object)new UserGroupId((UUID)userGroupId.get())));
        }
        return Optional.empty();
    }
}

