/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.mobile.service;

import de.justsoftware.chat.mobile.model.MobileSetting;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0012J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0016H\u0012J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/chat/mobile/service/MobileSettingsService;", "", "clock", "Ljava/time/Clock;", "<init>", "(Ljava/time/Clock;)V", "settingsMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lde/justsoftware/chat/mobile/model/MobileSetting$SettingId;", "Lde/justsoftware/chat/mobile/model/MobileSetting;", "settings", "", "getSettings", "()Ljava/util/List;", "getSettingsUpdates", "since", "Ljava/time/Instant;", "set", "", "id", "value", "", "", "setEnabled", "chat-service"})
@SourceDebugExtension(value={"SMAP\nMobileSettingsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobileSettingsService.kt\nde/justsoftware/chat/mobile/service/MobileSettingsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n774#2:43\n865#2,2:44\n*S KotlinDebug\n*F\n+ 1 MobileSettingsService.kt\nde/justsoftware/chat/mobile/service/MobileSettingsService\n*L\n32#1:43\n32#1:44,2\n*E\n"})
public class MobileSettingsService {
    @NotNull
    private final Clock clock;
    @NotNull
    private final ConcurrentHashMap<MobileSetting.SettingId, MobileSetting> settingsMap;

    public MobileSettingsService(@NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
        this.settingsMap = new ConcurrentHashMap(MobileSetting.SettingId.values().length);
        this.set(MobileSetting.SettingId.JUCO_VERSION, "25.3.14-4452");
        this.setEnabled(MobileSetting.SettingId.REACT);
        this.setEnabled(MobileSetting.SettingId.MULTI_USER_CHAT_ICONS);
        this.setEnabled(MobileSetting.SettingId.MULTI_USER_CHAT_ICON_PREVIEW);
    }

    @NotNull
    public List<MobileSetting> getSettings() {
        Collection collection = this.settingsMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<MobileSetting> getSettingsUpdates(@NotNull Instant since) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Iterable $this$filter$iv = this.getSettings();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MobileSetting it = (MobileSetting)element$iv$iv;
            boolean bl = false;
            if (!it.getModifyDate().isAfter(since)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private void set(MobileSetting.SettingId id, String value) {
        Map map = this.settingsMap;
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
        MobileSetting mobileSetting = new MobileSetting(id, value, instant);
        map.put(id, mobileSetting);
    }

    private void set(MobileSetting.SettingId id, boolean value) {
        this.set(id, String.valueOf(value));
    }

    private void setEnabled(MobileSetting.SettingId id) {
        this.set(id, true);
    }
}

