/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.mobile.service;

import de.justsoftware.chat.business.ChatReadDateService;
import de.justsoftware.chat.mobile.model.MobilePushNotification;
import de.justsoftware.chat.mobile.model.MobileScheduledPushNotification;
import de.justsoftware.chat.mobile.persistence.MobileScheduledPushNotificationRepository;
import de.justsoftware.chat.mobile.service.JunoRestClientService;
import de.justsoftware.chat.mobile.service.MobilePushNotificationSendService;
import de.justsoftware.chat.mobile.service.MobilePushTokenService;
import de.justsoftware.chat.mobile.util.JunoUtilsKt;
import de.justsoftware.chat.model.ChatProfileId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.TaskSchedulerUtilsKt;
import de.justsoftware.pushnotification.client.model.PushNotificationResult;
import de.justsoftware.pushnotification.client.model.PushNotificationResults;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;

/*
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u0000 (2\u00020\u0001:\u0002'(B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0014\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015H\u0002J\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0015*\b\u0012\u0004\u0012\u00020\u001d0\u0015H\u0002J\u0016\u0010\u001e\u001a\u00020\u001f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015H\u0002J&\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00152\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lde/justsoftware/chat/mobile/service/MobilePushNotificationSendService;", "", "mobilePushTokenService", "Lde/justsoftware/chat/mobile/service/MobilePushTokenService;", "chatReadDateService", "Lde/justsoftware/chat/business/ChatReadDateService;", "junoClient", "Lde/justsoftware/chat/mobile/service/JunoRestClientService;", "taskScheduler", "Lorg/springframework/scheduling/TaskScheduler;", "repository", "Lde/justsoftware/chat/mobile/persistence/MobileScheduledPushNotificationRepository;", "clock", "Ljava/time/Clock;", "<init>", "(Lde/justsoftware/chat/mobile/service/MobilePushTokenService;Lde/justsoftware/chat/business/ChatReadDateService;Lde/justsoftware/chat/mobile/service/JunoRestClientService;Lorg/springframework/scheduling/TaskScheduler;Lde/justsoftware/chat/mobile/persistence/MobileScheduledPushNotificationRepository;Ljava/time/Clock;)V", "batchSize", "", "sendAll", "", "pushNotifications", "", "Lde/justsoftware/chat/mobile/model/MobilePushNotification;", "process", "", "prepareApnsPushNotifications", "Lde/justsoftware/chat/mobile/model/MobileScheduledPushNotification;", "scheduledPushes", "filterAlreadyRead", "Lde/justsoftware/chat/mobile/model/MobilePushNotification$ApnsNewChatMessage;", "sendPushNotifications", "Lde/justsoftware/chat/mobile/service/MobilePushNotificationSendService$SendResult;", "logJunoClientErrors", "error", "", "durationMs", "", "applySendResult", "result", "SendResult", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nMobilePushNotificationSendService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobilePushNotificationSendService.kt\nde/justsoftware/chat/mobile/service/MobilePushNotificationSendService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 6 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n+ 7 TimeUtils.kt\nde/justsoftware/chat/util/TimeUtilsKt\n*L\n1#1,166:1\n1557#2:167\n1628#2,3:168\n1611#2,9:174\n1863#2:183\n1864#2:185\n1620#2:186\n1187#2,2:187\n1261#2,4:189\n1557#2:193\n1628#2,3:194\n1628#2,3:198\n774#2:201\n865#2,2:202\n1557#2:204\n1628#2,3:205\n3193#2,10:208\n1557#2:218\n1628#2,3:219\n1628#2,3:223\n1317#3,2:171\n1#4:173\n1#4:184\n7#5:197\n7#5:222\n9#6:226\n8#6,3:227\n8#7:230\n7#7:231\n8#7:232\n7#7:233\n17#7:234\n16#7:235\n*S KotlinDebug\n*F\n+ 1 MobilePushNotificationSendService.kt\nde/justsoftware/chat/mobile/service/MobilePushNotificationSendService\n*L\n41#1:167\n41#1:168,3\n57#1:174,9\n57#1:183\n57#1:185\n57#1:186\n59#1:187,2\n59#1:189,4\n60#1:193\n60#1:194,3\n70#1:198,3\n72#1:201\n72#1:202,2\n78#1:204\n78#1:205,3\n102#1:208,10\n104#1:218\n104#1:219,3\n107#1:223,3\n50#1:171,2\n57#1:184\n70#1:197\n107#1:222\n123#1:226\n123#1:227,3\n125#1:230\n125#1:231\n126#1:232\n126#1:233\n127#1:234\n127#1:235\n*E\n"})
public final class MobilePushNotificationSendService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final MobilePushTokenService mobilePushTokenService;
    @NotNull
    private final ChatReadDateService chatReadDateService;
    @NotNull
    private final JunoRestClientService junoClient;
    @NotNull
    private final MobileScheduledPushNotificationRepository repository;
    @NotNull
    private final Clock clock;
    private int batchSize;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Duration LOUD_APNS_DELAY;
    private static final Duration PROCESS_RATE;
    @NotNull
    private static final Duration SCHEDULED_PUSH_TTL;

    public MobilePushNotificationSendService(@NotNull MobilePushTokenService mobilePushTokenService, @NotNull ChatReadDateService chatReadDateService, @NotNull JunoRestClientService junoClient, @NotNull TaskScheduler taskScheduler, @NotNull MobileScheduledPushNotificationRepository repository, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)mobilePushTokenService, (String)"mobilePushTokenService");
        Intrinsics.checkNotNullParameter((Object)chatReadDateService, (String)"chatReadDateService");
        Intrinsics.checkNotNullParameter((Object)junoClient, (String)"junoClient");
        Intrinsics.checkNotNullParameter((Object)taskScheduler, (String)"taskScheduler");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.mobilePushTokenService = mobilePushTokenService;
        this.chatReadDateService = chatReadDateService;
        this.junoClient = junoClient;
        this.repository = repository;
        this.clock = clock;
        this.batchSize = 50;
        Duration duration = PROCESS_RATE;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"PROCESS_RATE");
        TaskSchedulerUtilsKt.scheduleAtFixedRateAndSkipMissed((TaskScheduler)taskScheduler, (Duration)duration, () -> this.process());
    }

    /*
     * WARNING - void declaration
     */
    public final void sendAll(@NotNull List<? extends MobilePushNotification> pushNotifications) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(pushNotifications, (String)"pushNotifications");
        Instant now = this.clock.instant();
        Iterable iterable = pushNotifications;
        MobileScheduledPushNotificationRepository mobileScheduledPushNotificationRepository = this.repository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MobilePushNotification mobilePushNotification = (MobilePushNotification)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)now);
            collection.add(Companion.access$schedule((Companion)Companion, (MobilePushNotification)it, (Instant)now));
        }
        mobileScheduledPushNotificationRepository.saveAll((List)destination$iv$iv);
    }

    private final boolean process() {
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
        Sequence $this$forEach$iv = SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.chunked((Sequence)this.repository.findDue(instant), (int)this.batchSize), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */)), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SendResult p0 = (SendResult)element$iv;
            boolean bl = false;
            this.applySendResult(p0);
        }
        Unit it = Unit.INSTANCE;
        boolean bl = false;
        return !this.repository.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final List<MobileScheduledPushNotification> prepareApnsPushNotifications(List<? extends MobileScheduledPushNotification> scheduledPushes) {
        void $this$mapTo$iv$iv;
        void $this$associateTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = scheduledPushes;
        Object object = this;
        boolean $i$f$mapNotNull = false;
        void var5_5 = $this$mapNotNull$iv;
        Iterable<MobilePushNotification.ApnsNewChatMessage> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            MobilePushNotification.ApnsNewChatMessage it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            MobileScheduledPushNotification scheduledPush = (MobileScheduledPushNotification)element$iv$iv;
            boolean bl2 = false;
            MobilePushNotification mobilePushNotification = scheduledPush.getPushNotification();
            if ((mobilePushNotification instanceof MobilePushNotification.ApnsNewChatMessage ? (MobilePushNotification.ApnsNewChatMessage)mobilePushNotification : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$associate$iv = object.filterAlreadyRead((List)destination$iv$iv);
        boolean $i$f$associate = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Object element$iv$iv$iv;
            element$iv$iv$iv = destination$iv$iv2;
            MobilePushNotification.ApnsNewChatMessage push = (MobilePushNotification.ApnsNewChatMessage)element$iv$iv;
            boolean bl = false;
            push = TuplesKt.to((Object)MobilePushNotification.Id.box-impl((UUID)push.getId-Tj4mk38()), (Object)push.toChatUpdate());
            element$iv$iv$iv.put((Object)push.getFirst(), (Object)push.getSecond());
        }
        Map preparedApnsPushNotifications = destination$iv$iv2;
        Iterable $this$map$iv = scheduledPushes;
        boolean $i$f$map = false;
        Iterable capacity$iv22 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void scheduledPush;
            Object element$iv$iv;
            element$iv$iv = (MobileScheduledPushNotification)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            MobilePushNotification.ChatUpdate preparedPushNotification = (MobilePushNotification.ChatUpdate)preparedApnsPushNotifications.get(MobilePushNotification.Id.box-impl((UUID)scheduledPush.getId-Tj4mk38()));
            object.add(preparedPushNotification == null ? scheduledPush : (MobileScheduledPushNotification)scheduledPush.withPushNotification(preparedPushNotification));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<MobilePushNotification.ApnsNewChatMessage> filterAlreadyRead(List<MobilePushNotification.ApnsNewChatMessage> $this$filterAlreadyRead) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Iterable iterable = $this$filterAlreadyRead;
        ChatReadDateService chatReadDateService = this.chatReadDateService;
        boolean $i$f$mapToSet = false;
        void var5_5 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            MobilePushNotification.ApnsNewChatMessage apnsNewChatMessage = (MobilePushNotification.ApnsNewChatMessage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getChatProfileId());
        }
        Map readDates = MapsKt.withDefault((Map)chatReadDateService.getChatReadDates((Set)destination$iv$iv), MobilePushNotificationSendService::filterAlreadyRead$lambda$6);
        Iterable $this$filter$iv = $this$filterAlreadyRead;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MobilePushNotification.ApnsNewChatMessage push = (MobilePushNotification.ApnsNewChatMessage)element$iv$iv;
            boolean bl = false;
            if (!(push.getChatMessageDate().compareTo((Instant)MapsKt.getValue((Map)readDates, (Object)push.getChatProfileId())) <= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final SendResult sendPushNotifications(List<? extends MobileScheduledPushNotification> scheduledPushes) {
        Object object;
        Object p0;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        long startTimeMs = 0L;
        Object object2 = scheduledPushes;
        Companion companion = Companion;
        boolean $i$f$map22 = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MobileScheduledPushNotification mobileScheduledPushNotification = (MobileScheduledPushNotification)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JunoUtilsKt.toJunoPushNotification((MobilePushNotification)it.getPushNotification()));
        }
        object2 = (List)destination$iv$iv;
        Iterable $i$f$map22 = object2;
        boolean bl = false;
        startTimeMs = System.currentTimeMillis();
        Object it = this.junoClient;
        try {
            p0 = object2;
            boolean bl2 = false;
            p0 = Result.constructor-impl((Object)it.sendPushNotifications((List)p0));
        }
        catch (Throwable bl2) {
            p0 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        Companion companion2 = companion;
        object2 = p0;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            void e;
            it = throwable;
            p0 = it;
            companion = companion2;
            boolean bl3 = false;
            long durationMs = System.currentTimeMillis() - startTimeMs;
            this.logJunoClientErrors((Throwable)e, scheduledPushes, durationMs);
            companion2 = companion;
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object2);
        if (throwable2 == null) {
            object = object2;
        } else {
            it = throwable2;
            companion = companion2;
            boolean bl4 = false;
            object = JunoUtilsKt.toPushNotificationResults((List)Companion.access$toIds((Companion)Companion, scheduledPushes), (PushNotificationResult)PushNotificationResult.ERROR);
            companion2 = companion;
        }
        return Companion.access$toSendResult((Companion)companion2, (PushNotificationResults)((PushNotificationResults)object), scheduledPushes);
    }

    private final void logJunoClientErrors(Throwable error, List<? extends MobileScheduledPushNotification> scheduledPushes, long durationMs) {
        LOG.error("Error while sending " + scheduledPushes.size() + " push notifications to juno (after " + durationMs + "ms)", error);
    }

    /*
     * WARNING - void declaration
     */
    private final void applySendResult(SendResult result) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv;
        void $this$partition$iv;
        this.repository.deleteAll(Companion.access$toIds((Companion)Companion, (List)result.getSuccessfulScheduledPushes()));
        Iterable iterable = result.getFailedScheduledPushes();
        Companion companion = Companion;
        boolean $i$f$partition22 = false;
        Companion first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            MobileScheduledPushNotification p0 = (MobileScheduledPushNotification)element$iv;
            boolean bl = false;
            if (Companion.access$shouldRetry((Companion)companion, (MobileScheduledPushNotification)p0)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List scheduledPushesToRetry = (List)pair.component1();
        List scheduledPushesToAbandon = (List)pair.component2();
        this.repository.deleteAll(Companion.access$toIds((Companion)Companion, (List)scheduledPushesToAbandon));
        Iterable $i$f$partition22 = scheduledPushesToRetry;
        first$iv = Companion;
        MobileScheduledPushNotificationRepository mobileScheduledPushNotificationRepository = this.repository;
        boolean $i$f$map22 = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void p0;
            MobileScheduledPushNotification mobileScheduledPushNotification = (MobileScheduledPushNotification)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Companion.access$scheduleRetry((Companion)first$iv, (MobileScheduledPushNotification)p0));
        }
        mobileScheduledPushNotificationRepository.saveAll((List)destination$iv$iv);
        this.repository.deleteAll(Companion.access$toIds((Companion)Companion, (List)result.getInvalidScheduledPushes()));
        $this$map$iv = result.getInvalidScheduledPushes();
        mobileScheduledPushNotificationRepository = this.mobilePushTokenService;
        boolean $i$f$mapToSet = false;
        void $i$f$map22 = $this$mapToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (MobileScheduledPushNotification)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getPushTokenId());
        }
        mobileScheduledPushNotificationRepository.deletePushTokens((Iterable)((Set)destination$iv$iv2));
        this.batchSize = result.getNextBatchSize();
    }

    private static final Instant filterAlreadyRead$lambda$6(ChatProfileId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Instant.EPOCH;
    }

    public static final /* synthetic */ List access$prepareApnsPushNotifications(MobilePushNotificationSendService $this, List scheduledPushes) {
        return $this.prepareApnsPushNotifications(scheduledPushes);
    }

    public static final /* synthetic */ SendResult access$sendPushNotifications(MobilePushNotificationSendService $this, List scheduledPushes) {
        return $this.sendPushNotifications(scheduledPushes);
    }

    public static final /* synthetic */ Duration access$getSCHEDULED_PUSH_TTL$cp() {
        return SCHEDULED_PUSH_TTL;
    }

    public static final /* synthetic */ Duration access$getLOUD_APNS_DELAY$cp() {
        return LOUD_APNS_DELAY;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
        int $this$milliseconds$iv = 1500;
        boolean $i$f$getMilliseconds = false;
        long $this$milliseconds$iv$iv = $this$milliseconds$iv;
        boolean $i$f$getMilliseconds2 = false;
        Duration duration = Duration.ofMillis($this$milliseconds$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        LOUD_APNS_DELAY = duration;
        $this$milliseconds$iv = 200;
        $i$f$getMilliseconds = false;
        $this$milliseconds$iv$iv = $this$milliseconds$iv;
        $i$f$getMilliseconds2 = false;
        Duration duration2 = Duration.ofMillis($this$milliseconds$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
        PROCESS_RATE = LOUD_APNS_DELAY.plus(duration2);
        int $this$hours$iv = 2;
        boolean $i$f$getHours = false;
        long $this$hours$iv$iv = $this$hours$iv;
        boolean $i$f$getHours2 = false;
        Duration duration3 = Duration.ofHours($this$hours$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofHours(...)");
        SCHEDULED_PUSH_TTL = duration3;
    }
}

