/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.mobile.controller;

import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.mobile.controller.MobileController;
import de.justsoftware.chat.mobile.model.MobileAttachmentFilter;
import de.justsoftware.chat.mobile.model.MobileChangeList;
import de.justsoftware.chat.mobile.model.MobileChat;
import de.justsoftware.chat.mobile.model.MobileChatList;
import de.justsoftware.chat.mobile.model.MobileChatMessage;
import de.justsoftware.chat.mobile.model.MobileChatMessageList;
import de.justsoftware.chat.mobile.model.MobileChatSettings;
import de.justsoftware.chat.mobile.model.MobileClientVersion;
import de.justsoftware.chat.mobile.model.MobileIconSize;
import de.justsoftware.chat.mobile.model.MobileMessageReaction;
import de.justsoftware.chat.mobile.model.MobileMessageTypeUpdate;
import de.justsoftware.chat.mobile.model.MobilePlatform;
import de.justsoftware.chat.mobile.model.MobilePushToken;
import de.justsoftware.chat.mobile.model.MobileSearchItemType;
import de.justsoftware.chat.mobile.model.MobileSearchResultList;
import de.justsoftware.chat.mobile.model.MobileSetting;
import de.justsoftware.chat.mobile.model.MobileSyncToken;
import de.justsoftware.chat.mobile.model.MobileThumbnailSize;
import de.justsoftware.chat.mobile.model.MobileUser;
import de.justsoftware.chat.mobile.model.MobileUserList;
import de.justsoftware.chat.mobile.service.MobileApplicationService;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatMessageId;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.util.RestClientUtilsKt;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.reactive.function.client.WebClient;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/mobile"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00fa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 l2\u00020\u0001:\u0001lB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001a\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001a\u0010\u0015\u001a\u00020\u00122\b\b\u0001\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J&\u0010\u0017\u001a\u00020\u00122\b\b\u0001\u0010\u0016\u001a\u00020\u00122\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001a\u0010\u001a\u001a\u00020\u00122\b\b\u0001\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001a\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J$\u0010\u001d\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001a\u0010 \u001a\u00020!2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J$\u0010\"\u001a\u00020!2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010#\u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J4\u0010$\u001a\u00020\u001c2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J$\u0010+\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001a\u0010,\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J.\u0010-\u001a\u00020.2\b\b\u0001\u0010/\u001a\u00020&2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001a\u00100\u001a\u0002012\b\b\u0001\u00102\u001a\u0002032\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001a\u00104\u001a\u0002052\b\b\u0001\u00106\u001a\u0002072\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J<\u00108\u001a\u0002092\b\b\u0001\u0010\u0013\u001a\u00020\u00142\n\b\u0001\u0010:\u001a\u0004\u0018\u0001072\b\b\u0001\u0010\u000e\u001a\u00020\r2\n\b\u0001\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J$\u0010=\u001a\u0002052\b\b\u0001\u00106\u001a\u0002072\b\b\u0001\u0010>\u001a\u00020?2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J.\u0010@\u001a\u0002052\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010A\u001a\u00020B2\b\b\u0001\u0010C\u001a\u0002052\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J8\u0010D\u001a\u0002052\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010A\u001a\u00020B2\b\b\u0001\u0010C\u001a\u0002052\b\b\u0001\u0010E\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J@\u0010F\u001a\u00020G2\b\b\u0001\u0010H\u001a\u00020&2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\u0010\b\u0001\u0010I\u001a\n\u0012\u0004\u0012\u00020K\u0018\u00010J2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J*\u0010L\u001a\u00020\u001c2\b\b\u0001\u00106\u001a\u0002072\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J4\u0010M\u001a\u00020\u001c2\b\b\u0001\u00106\u001a\u0002072\b\b\u0001\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J*\u0010N\u001a\u00020\u001c2\b\b\u0001\u00106\u001a\u0002072\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J \u0010O\u001a\b\u0012\u0004\u0012\u00020Q0P2\b\b\u0001\u00106\u001a\u0002072\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001a\u0010R\u001a\u00020&2\b\b\u0001\u00106\u001a\u0002072\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J \u0010S\u001a\b\u0012\u0004\u0012\u00020T0J2\b\b\u0001\u00106\u001a\u0002072\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J$\u0010U\u001a\u00020T2\b\b\u0001\u00106\u001a\u0002072\b\b\u0001\u0010V\u001a\u00020T2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001a\u0010W\u001a\u00020\u001c2\b\b\u0001\u00106\u001a\u0002072\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u000e\u0010X\u001a\b\u0012\u0004\u0012\u00020Y0JH\u0017J\u001a\u0010Z\u001a\u00020[2\b\b\u0001\u0010\\\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J0\u0010]\u001a\u00020[2\n\b\u0001\u0010^\u001a\u0004\u0018\u00010&2\b\b\u0001\u0010_\u001a\u00020B2\b\b\u0001\u0010\\\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J$\u0010`\u001a\u00020\u001c2\b\b\u0001\u0010a\u001a\u00020&2\b\b\u0001\u0010\\\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J$\u0010b\u001a\u00020c2\n\b\u0001\u0010d\u001a\u0004\u0018\u00010e2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J \u0010f\u001a\u00020\u001c2\u0006\u0010g\u001a\u00020&2\u0006\u0010h\u001a\u00020(2\u0006\u0010i\u001a\u00020*H\u0012J \u0010f\u001a\u00020\u001c2\u0006\u0010j\u001a\u00020k2\u0006\u0010h\u001a\u00020(2\u0006\u0010i\u001a\u00020*H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006m"}, d2={"Lde/justsoftware/chat/mobile/controller/MobileController;", "", "mobileApplicationService", "Lde/justsoftware/chat/mobile/service/MobileApplicationService;", "<init>", "(Lde/justsoftware/chat/mobile/service/MobileApplicationService;)V", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "kotlin.jvm.PlatformType", "Lorg/springframework/web/reactive/function/client/WebClient;", "getRecentChats", "Lde/justsoftware/chat/mobile/model/MobileChatList;", "offset", "", "limit", "authContext", "Lde/justsoftware/chat/authorization/AuthorizationContext;", "getChat", "Lde/justsoftware/chat/mobile/model/MobileChat;", "chatId", "Lde/justsoftware/chat/model/ChatId;", "createChat", "chat", "createChatWithIcon", "icon", "Lorg/springframework/web/multipart/MultipartFile;", "updateChat", "deleteChat", "", "readChat", "readDate", "Ljava/time/Instant;", "getChatSettings", "Lde/justsoftware/chat/mobile/model/MobileChatSettings;", "updateChatSettings", "chatSettings", "getChatIcon", "size", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "updateChatIcon", "deleteChatIcon", "getUsers", "Lde/justsoftware/chat/mobile/model/MobileUserList;", "filter", "getUser", "Lde/justsoftware/chat/mobile/model/MobileUser;", "userId", "Lde/justsoftware/chat/model/ProfileId;", "getMessage", "Lde/justsoftware/chat/mobile/model/MobileChatMessage;", "messageId", "Lde/justsoftware/chat/model/ChatMessageId;", "getMessages", "Lde/justsoftware/chat/mobile/model/MobileChatMessageList;", "offsetMessageId", "attachmentFilter", "Lde/justsoftware/chat/mobile/model/MobileAttachmentFilter;", "updateMessage", "messageTypeUpdate", "Lde/justsoftware/chat/mobile/model/MobileMessageTypeUpdate;", "createTextMessage", "markChatAsRead", "", "message", "createAttachmentMessage", "attachment", "searchParticipants", "Lde/justsoftware/chat/mobile/model/MobileSearchResultList;", "query", "types", "", "Lde/justsoftware/chat/mobile/model/MobileSearchItemType;", "downloadAttachment", "downloadAttachmentThumbnail", "downloadAttachmentPreview", "downloadAttachmentVideoStream", "Lorg/springframework/http/ResponseEntity;", "Lorg/springframework/core/io/Resource;", "getUnauthorizedAttachmentVideoUrl", "getReactions", "Lde/justsoftware/chat/mobile/model/MobileMessageReaction;", "react", "reaction", "deleteReaction", "getSettings", "Lde/justsoftware/chat/mobile/model/MobileSetting;", "registerPushTokenAndroid", "Lde/justsoftware/chat/mobile/model/MobilePushToken;", "pushToken", "registerPushTokenIos", "publicKey", "silenceAlerts", "unregisterPushToken", "platform", "getChanges", "Lde/justsoftware/chat/mobile/model/MobileChangeList;", "token", "Lde/justsoftware/chat/mobile/model/MobileSyncToken;", "download", "url", "fromRequest", "toResponse", "uri", "Ljava/net/URI;", "Companion", "chat-service"})
public class MobileController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MobileApplicationService mobileApplicationService;
    private final WebClient webClient;
    @NotNull
    public static final String MOBILE_API_BASE_PATH = "/api/mobile";

    public MobileController(@NotNull MobileApplicationService mobileApplicationService) {
        Intrinsics.checkNotNullParameter((Object)mobileApplicationService, (String)"mobileApplicationService");
        this.mobileApplicationService = mobileApplicationService;
        this.webClient = WebClient.create();
    }

    @GetMapping(value={"/chats"})
    @NotNull
    public MobileChatList getRecentChats(@RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="20") int limit, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.getRecentChats(offset, limit, authContext);
    }

    @GetMapping(value={"/chats/{chatId}"})
    @NotNull
    public MobileChat getChat(@PathVariable(value="chatId") @NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.getChat(chatId, authContext);
    }

    @PostMapping(value={"/chats"}, params={"!chat"})
    @NotNull
    public MobileChat createChat(@RequestBody @NotNull MobileChat chat, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return MobileApplicationService.createChat$default((MobileApplicationService)this.mobileApplicationService, (MobileChat)chat, null, (AuthorizationContext)authContext, (int)2, null);
    }

    @PostMapping(value={"/chats"}, params={"chat"})
    @NotNull
    public MobileChat createChatWithIcon(@RequestPart(value="chat") @NotNull MobileChat chat, @RequestParam(value="icon", required=false) @Nullable MultipartFile icon, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.createChat(chat, icon, authContext);
    }

    @PutMapping(value={"/chats"})
    @NotNull
    public MobileChat updateChat(@RequestBody @NotNull MobileChat chat, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.updateChat(chat, authContext);
    }

    @DeleteMapping(value={"/chats/{chatId}"})
    public void deleteChat(@PathVariable(value="chatId") @NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.mobileApplicationService.deleteChat(chatId, authContext);
    }

    @PutMapping(value={"/chats/{chatId}/read"})
    @NotNull
    public MobileChat readChat(@PathVariable(value="chatId") @NotNull ChatId chatId, @RequestBody @NotNull Instant readDate, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)readDate, (String)"readDate");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.readChat(chatId, readDate, authContext);
    }

    @GetMapping(value={"/chats/{chatId}/settings"})
    @NotNull
    public MobileChatSettings getChatSettings(@PathVariable(value="chatId") @NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.getChatSettings(chatId, authContext);
    }

    @PutMapping(value={"/chats/{chatId}/settings"})
    @NotNull
    public MobileChatSettings updateChatSettings(@PathVariable(value="chatId") @NotNull ChatId chatId, @RequestBody @NotNull MobileChatSettings chatSettings2, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)chatSettings2, (String)"chatSettings");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.updateChatSettings(chatId, chatSettings2, authContext);
    }

    @GetMapping(value={"/chats/{chatId}/icon"})
    public void getChatIcon(@PathVariable(value="chatId") @NotNull ChatId chatId, @RequestParam(value="size", defaultValue="SMALL") @NotNull String size, @NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        URI uri = this.mobileApplicationService.downloadChatIconUri(chatId, MobileIconSize.Companion.toMobileIconSize(size), authContext);
        this.download(uri, request, response);
    }

    @PutMapping(value={"/chats/{chatId}/icon"})
    @NotNull
    public MobileChat updateChatIcon(@PathVariable(value="chatId") @NotNull ChatId chatId, @RequestParam(value="icon") @NotNull MultipartFile icon, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.updateChatIcon(chatId, icon, authContext);
    }

    @DeleteMapping(value={"/chats/{chatId}/icon"})
    @NotNull
    public MobileChat deleteChatIcon(@PathVariable(value="chatId") @NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.deleteChatIcon(chatId, authContext);
    }

    @GetMapping(value={"/users"})
    @NotNull
    public MobileUserList getUsers(@RequestParam(value="filter", defaultValue="") @NotNull String filter, @RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="20") int limit, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.getUsers(filter, offset, limit, authContext);
    }

    @GetMapping(value={"/users/{userId}"})
    @NotNull
    public MobileUser getUser(@PathVariable(value="userId") @NotNull ProfileId userId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.getUser(userId, authContext);
    }

    @GetMapping(value={"/messages/{messageId}"})
    @NotNull
    public MobileChatMessage getMessage(@PathVariable(value="messageId") @NotNull ChatMessageId messageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.getMessage(messageId, authContext);
    }

    @GetMapping(value={"/chats/{chatId}/messages"})
    @NotNull
    public MobileChatMessageList getMessages(@PathVariable(value="chatId") @NotNull ChatId chatId, @RequestParam(value="offsetId", required=false) @Nullable ChatMessageId offsetMessageId, @RequestParam(value="limit", defaultValue="20") int limit, @RequestParam(value="attachmentFilter", required=false) @Nullable MobileAttachmentFilter attachmentFilter, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.getMessages(chatId, offsetMessageId, limit, attachmentFilter, authContext);
    }

    @PatchMapping(value={"/messages/{messageId}"})
    @NotNull
    public MobileChatMessage updateMessage(@PathVariable(value="messageId") @NotNull ChatMessageId messageId, @RequestBody @NotNull MobileMessageTypeUpdate messageTypeUpdate, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)messageTypeUpdate, (String)"messageTypeUpdate");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.updateMessage(messageId, messageTypeUpdate, authContext);
    }

    @PostMapping(value={"/chats/{chatId}/messages"})
    @NotNull
    public MobileChatMessage createTextMessage(@PathVariable(value="chatId") @NotNull ChatId chatId, @RequestParam(value="markChatAsRead", defaultValue="true") boolean markChatAsRead, @RequestBody @NotNull MobileChatMessage message, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.createTextMessage(chatId, message, markChatAsRead, authContext);
    }

    @PostMapping(value={"/chats/{chatId}/attachments"})
    @NotNull
    public MobileChatMessage createAttachmentMessage(@PathVariable(value="chatId") @NotNull ChatId chatId, @RequestParam(value="markChatAsRead", defaultValue="true") boolean markChatAsRead, @RequestPart(value="message") @NotNull MobileChatMessage message, @RequestParam(value="attachment") @NotNull MultipartFile attachment, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.createAttachmentMessage(chatId, message, attachment, markChatAsRead, authContext);
    }

    @GetMapping(value={"/search/participants/name"})
    @NotNull
    public MobileSearchResultList searchParticipants(@RequestParam(value="query", defaultValue="") @NotNull String query, @RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="20") int limit, @RequestParam(value="type", required=false) @Nullable List<? extends MobileSearchItemType> types, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.searchParticipants(query, offset, limit, types, authContext);
    }

    @GetMapping(value={"/messages/{messageId}/attachment"})
    public void downloadAttachment(@PathVariable(value="messageId") @NotNull ChatMessageId messageId, @NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        String url = this.mobileApplicationService.downloadAttachmentUrl(messageId, authContext);
        this.download(url, request, response);
    }

    @GetMapping(value={"/messages/{messageId}/attachment/thumbnail"})
    public void downloadAttachmentThumbnail(@PathVariable(value="messageId") @NotNull ChatMessageId messageId, @RequestParam(value="size", defaultValue="MEDIUM") @NotNull String size, @NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        URI uri = this.mobileApplicationService.downloadAttachmentThumbnailUri(messageId, MobileThumbnailSize.Companion.toMobileThumbnailSize(size), authContext);
        this.download(uri, request, response);
    }

    @GetMapping(value={"/messages/{messageId}/attachment/preview"})
    public void downloadAttachmentPreview(@PathVariable(value="messageId") @NotNull ChatMessageId messageId, @NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        String url = this.mobileApplicationService.downloadAttachmentPreviewUrl(messageId, authContext);
        this.download(url, request, response);
    }

    @GetMapping(value={"/messages/{messageId}/attachment/video"})
    @NotNull
    public ResponseEntity<Resource> downloadAttachmentVideoStream(@PathVariable(value="messageId") @NotNull ChatMessageId messageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return RestClientUtilsKt.redirectTo$default((String)this.mobileApplicationService.getAttachmentVideoStreamUrl(messageId, authContext), (boolean)true, null, (int)4, null);
    }

    @GetMapping(value={"/messages/{messageId}/attachment/video/url"})
    @NotNull
    public String getUnauthorizedAttachmentVideoUrl(@PathVariable(value="messageId") @NotNull ChatMessageId messageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.getUnauthorizedAttachmentVideoUrl(messageId, authContext);
    }

    @GetMapping(value={"/messages/{messageId}/reactions"})
    @NotNull
    public List<MobileMessageReaction> getReactions(@PathVariable(value="messageId") @NotNull ChatMessageId messageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.getReactions(messageId, authContext);
    }

    @PutMapping(value={"/messages/{messageId}/reactions"})
    @NotNull
    public MobileMessageReaction react(@PathVariable(value="messageId") @NotNull ChatMessageId messageId, @RequestBody @NotNull MobileMessageReaction reaction, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)reaction, (String)"reaction");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.react(messageId, reaction, authContext);
    }

    @DeleteMapping(value={"/messages/{messageId}/reactions"})
    public void deleteReaction(@PathVariable(value="messageId") @NotNull ChatMessageId messageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.mobileApplicationService.deleteReaction(messageId, authContext);
    }

    @GetMapping(value={"/settings"})
    @NotNull
    public List<MobileSetting> getSettings() {
        return this.mobileApplicationService.getSettings();
    }

    @PostMapping(value={"/push/android"})
    @NotNull
    public MobilePushToken registerPushTokenAndroid(@RequestBody @NotNull String pushToken, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        char[] cArray = new char[]{'\"'};
        return MobileApplicationService.registerPushToken$default((MobileApplicationService)this.mobileApplicationService, (String)StringsKt.trim((String)pushToken, (char[])cArray), (MobilePlatform)MobilePlatform.ANDROID, null, (boolean)false, (AuthorizationContext)authContext, (int)8, null);
    }

    @PostMapping(value={"/push/ios"})
    @NotNull
    public MobilePushToken registerPushTokenIos(@RequestParam(value="publicKey") @Nullable String publicKey, @RequestParam(value="silenceAlerts", defaultValue="false") boolean silenceAlerts, @RequestBody @NotNull String pushToken, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        char[] cArray = new char[]{'\"'};
        return this.mobileApplicationService.registerPushToken(StringsKt.trim((String)pushToken, (char[])cArray), MobilePlatform.IOS, publicKey, silenceAlerts, authContext);
    }

    @DeleteMapping(value={"/push/{platform:android|ios}/{token}"})
    public void unregisterPushToken(@PathVariable(value="platform") @NotNull String platform, @PathVariable(value="token") @NotNull String pushToken, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.mobileApplicationService.unregisterPushToken(pushToken, MobilePlatform.Companion.toMobilePlatform(platform), authContext);
    }

    @GetMapping(value={"/changes"})
    @NotNull
    public MobileChangeList getChanges(@RequestParam(value="token", required=false) @Nullable MobileSyncToken token, @NotNull HttpServletRequest request, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.getChanges(token, MobileClientVersion.Companion.toClientVersion(request), authContext);
    }

    private void download(String url, HttpServletRequest fromRequest, HttpServletResponse toResponse) {
        WebClient.RequestHeadersSpec requestHeadersSpec = this.webClient.get().uri(url, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)requestHeadersSpec, (String)"uri(...)");
        Companion.access$copyHeadersAndDownload((Companion)Companion, (WebClient.RequestHeadersSpec)requestHeadersSpec, (HttpServletRequest)fromRequest, (HttpServletResponse)toResponse);
    }

    private void download(URI uri, HttpServletRequest fromRequest, HttpServletResponse toResponse) {
        WebClient.RequestHeadersSpec requestHeadersSpec = this.webClient.get().uri(uri);
        Intrinsics.checkNotNullExpressionValue((Object)requestHeadersSpec, (String)"uri(...)");
        Companion.access$copyHeadersAndDownload((Companion)Companion, (WebClient.RequestHeadersSpec)requestHeadersSpec, (HttpServletRequest)fromRequest, (HttpServletResponse)toResponse);
    }
}

