/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.chat.application.model.ChatMessageDto;
import de.justsoftware.chat.application.model.ControlMessageDto;
import de.justsoftware.chat.business.XmppRestApiService;
import de.justsoftware.chat.business.model.xmpp.CreateNodeStanza;
import de.justsoftware.chat.business.model.xmpp.JabberId;
import de.justsoftware.chat.business.model.xmpp.PublishItemStanza;
import de.justsoftware.chat.business.model.xmpp.Subscription;
import de.justsoftware.chat.business.model.xmpp.SubscriptionState;
import de.justsoftware.chat.business.model.xmpp.SubscriptionsStanza;
import de.justsoftware.chat.business.model.xmpp.XmppConnectedUsersPayload;
import de.justsoftware.chat.business.model.xmpp.XmppPayload;
import de.justsoftware.chat.business.model.xmpp.XmppSendMessagePayload;
import de.justsoftware.chat.business.model.xmpp.XmppSendStanzaPayload;
import de.justsoftware.chat.business.model.xmpp.XmppStanza;
import de.justsoftware.chat.exception.XmppException;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.UserGroupId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B-\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001e\u0010\u0018\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00032\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u001eH\u0016J\u001e\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00032\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u001eH\u0016J&\u0010 \u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0014H\u0016J&\u0010#\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0014H\u0016J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&H\u0016J&\u0010'\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003H\u0012J&\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0014H\u0012J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0012J\u001e\u0010-\u001a\u0002H.\"\u0006\b\u0000\u0010.\u0018\u00012\u0006\u0010+\u001a\u00020/H\u0092\b\u00a2\u0006\u0002\u00100R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lde/justsoftware/chat/business/XmppRestApiService;", "", "domain", "", "xmppHost", "xmppPort", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "httpHeaders", "Lorg/springframework/http/HttpHeaders;", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "xmppRestApiUrl", "pubSubRecipient", "systemUserId", "sendControlMessage", "", "recipients", "", "Lde/justsoftware/chat/model/ProfileId;", "controlMessageDto", "Lde/justsoftware/chat/application/model/ControlMessageDto;", "sendChatMessage", "chatMessageDto", "Lde/justsoftware/chat/application/model/ChatMessageDto;", "sendSubscribeStanza", "nodeName", "subscribers", "", "sendUnsubscribeStanza", "publishChatMessage", "userGroupIds", "Lde/justsoftware/chat/model/UserGroupId;", "publishControlMessage", "sendStanza", "stanza", "Lde/justsoftware/chat/business/model/xmpp/XmppStanza;", "sendMessage", "subject", "body", "sendPublishStanza", "payload", "getConnectedUsers", "sendToXmppRestApi", "T", "Lde/justsoftware/chat/business/model/xmpp/XmppPayload;", "(Lde/justsoftware/chat/business/model/xmpp/XmppPayload;)Ljava/lang/Object;", "chat-service"})
@SourceDebugExtension(value={"SMAP\nXmppRestApiService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmppRestApiService.kt\nde/justsoftware/chat/business/XmppRestApiService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n*L\n1#1,177:1\n160#1,14:187\n160#1,14:206\n160#1,14:223\n1#2:178\n1557#3:179\n1628#3,3:180\n1557#3:183\n1628#3,3:184\n1628#3,3:202\n1863#3:205\n1864#3:220\n1863#3,2:221\n7#4:201\n*S KotlinDebug\n*F\n+ 1 XmppRestApiService.kt\nde/justsoftware/chat/business/XmppRestApiService\n*L\n111#1:187,14\n135#1:206,14\n151#1:223,14\n70#1:179\n70#1:180,3\n85#1:183\n85#1:184,3\n127#1:202,3\n128#1:205\n128#1:220\n146#1:221,2\n127#1:201\n*E\n"})
public class XmppRestApiService {
    @NotNull
    private final String domain;
    @NotNull
    private final String xmppHost;
    @NotNull
    private final String xmppPort;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final HttpHeaders httpHeaders;
    @NotNull
    private final RestTemplate restTemplate;
    @NotNull
    private final String xmppRestApiUrl;
    @NotNull
    private final String pubSubRecipient;
    @NotNull
    private final String systemUserId;

    /*
     * WARNING - void declaration
     */
    public XmppRestApiService(@Value(value="${just.chat.domain}") @NotNull String domain, @Value(value="${server.xmpp.host}") @NotNull String xmppHost, @Value(value="${server.xmpp.rest-api-port}") @NotNull String xmppPort, @NotNull ObjectMapper objectMapper) {
        void $this$httpHeaders_u24lambda_u240;
        HttpHeaders httpHeaders;
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)xmppHost, (String)"xmppHost");
        Intrinsics.checkNotNullParameter((Object)xmppPort, (String)"xmppPort");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.domain = domain;
        this.xmppHost = xmppHost;
        this.xmppPort = xmppPort;
        this.objectMapper = objectMapper;
        HttpHeaders httpHeaders2 = httpHeaders = new HttpHeaders();
        XmppRestApiService xmppRestApiService = this;
        boolean bl = false;
        $this$httpHeaders_u24lambda_u240.add("Content-Type", "application/json");
        xmppRestApiService.httpHeaders = httpHeaders;
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory()));
        this.xmppRestApiUrl = "http://" + this.xmppHost + ":" + this.xmppPort + "/api/";
        this.pubSubRecipient = "pubsub." + this.domain;
        this.systemUserId = new JabberId("xmpp-system-user", this.domain, null, 4, null).toString();
    }

    public void sendControlMessage(@NotNull Set<ProfileId> recipients, @NotNull ControlMessageDto controlMessageDto) {
        Intrinsics.checkNotNullParameter(recipients, (String)"recipients");
        Intrinsics.checkNotNullParameter((Object)controlMessageDto, (String)"controlMessageDto");
        String string = this.objectMapper.writeValueAsString((Object)controlMessageDto);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        this.sendMessage(recipients, "Notification", string);
    }

    public void sendChatMessage(@NotNull Set<ProfileId> recipients, @NotNull ChatMessageDto chatMessageDto) {
        Intrinsics.checkNotNullParameter(recipients, (String)"recipients");
        Intrinsics.checkNotNullParameter((Object)chatMessageDto, (String)"chatMessageDto");
        String string = this.objectMapper.writeValueAsString((Object)chatMessageDto);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        this.sendMessage(recipients, "Message", string);
    }

    /*
     * WARNING - void declaration
     */
    public void sendSubscribeStanza(@NotNull String nodeName, @NotNull List<ProfileId> subscribers) {
        Collection<Subscription> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter(subscribers, (String)"subscribers");
        this.sendStanza((XmppStanza)new CreateNodeStanza(nodeName, null, 2, null));
        Iterable iterable = subscribers;
        String string = nodeName;
        XmppRestApiService xmppRestApiService = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void profileId;
            ProfileId profileId2 = (ProfileId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Subscription(JabberId.Companion.toJabberId((ProfileId)profileId, this.domain), nodeName, SubscriptionState.SUBSCRIBE));
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 4;
        UUID uUID = null;
        List list = collection;
        String string2 = string;
        xmppRestApiService.sendStanza((XmppStanza)new SubscriptionsStanza(string2, list, uUID, n, defaultConstructorMarker));
    }

    /*
     * WARNING - void declaration
     */
    public void sendUnsubscribeStanza(@NotNull String nodeName, @NotNull List<ProfileId> subscribers) {
        Collection<Subscription> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter(subscribers, (String)"subscribers");
        Iterable iterable = subscribers;
        String string = nodeName;
        XmppRestApiService xmppRestApiService = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void profileId;
            ProfileId profileId2 = (ProfileId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Subscription(JabberId.Companion.toJabberId((ProfileId)profileId, this.domain), nodeName, SubscriptionState.UNSUBSCRIBE));
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 4;
        UUID uUID = null;
        List list = collection;
        String string2 = string;
        xmppRestApiService.sendStanza((XmppStanza)new SubscriptionsStanza(string2, list, uUID, n, defaultConstructorMarker));
    }

    public void publishChatMessage(@NotNull String nodeName, @NotNull ChatMessageDto chatMessageDto, @NotNull Set<UserGroupId> userGroupIds) {
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter((Object)chatMessageDto, (String)"chatMessageDto");
        Intrinsics.checkNotNullParameter(userGroupIds, (String)"userGroupIds");
        String string = this.objectMapper.writeValueAsString((Object)chatMessageDto);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        this.sendPublishStanza(string, nodeName, userGroupIds);
    }

    public void publishControlMessage(@NotNull String nodeName, @NotNull ControlMessageDto controlMessageDto, @NotNull Set<UserGroupId> userGroupIds) {
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter((Object)controlMessageDto, (String)"controlMessageDto");
        Intrinsics.checkNotNullParameter(userGroupIds, (String)"userGroupIds");
        String string = this.objectMapper.writeValueAsString((Object)controlMessageDto);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        this.sendPublishStanza(string, nodeName, userGroupIds);
    }

    public void sendStanza(@NotNull XmppStanza stanza) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)stanza, (String)"stanza");
        XmppSendStanzaPayload payload = new XmppSendStanzaPayload(this.systemUserId, this.pubSubRecipient, stanza.toXMLString());
        XmppRestApiService this_$iv = this;
        boolean $i$f$sendToXmppRestApi = false;
        Pair pair = (XmppPayload)payload instanceof XmppSendMessagePayload ? TuplesKt.to((Object)"send_message", (Object)HttpMethod.POST) : TuplesKt.to((Object)"send_stanza", (Object)HttpMethod.POST);
        String command$iv = (String)pair.component1();
        HttpMethod httpMethod$iv = (HttpMethod)pair.component2();
        try {
            HttpEntity httpEntity$iv = new HttpEntity((Object)((XmppPayload)payload), (MultiValueMap)this_$iv.httpHeaders);
            ResponseEntity response$iv = this_$iv.restTemplate.exchange(this_$iv.xmppRestApiUrl + command$iv, httpMethod$iv, httpEntity$iv, Integer.class, new Object[0]);
            if (response$iv.getStatusCode() != HttpStatus.OK) {
                throw new XmppException("Sending command " + command$iv + " failed with http status: " + response$iv.getStatusCode().value(), null, 2, null);
            }
            if (response$iv.getBody() == null) {
                throw new XmppException("ejabberd returned nothing for command " + command$iv, null, 2, null);
            }
        }
        catch (RestClientException e$iv) {
            throw new XmppException("Could not access ejabberd at: " + this_$iv.xmppRestApiUrl + command$iv, (Throwable)e$iv);
        }
        int response = ((Number)object).intValue();
        if (response != 0) {
            throw new XmppException("Sending stanza payload " + payload + " resulted in error (" + response + ")", null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendMessage(Set<ProfileId> recipients, String subject, String body2) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$mapToSet$iv;
        if (recipients.isEmpty()) {
            return;
        }
        Set connectedUsers = this.getConnectedUsers();
        Iterable iterable = CollectionsKt.intersect((Iterable)recipients, (Iterable)connectedUsers);
        boolean $i$f$mapToSet = false;
        Iterator iterator = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void profileId;
            ProfileId profileId2 = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JabberId.Companion.toJabberId((ProfileId)profileId, this.domain));
        }
        $this$mapToSet$iv = (Set)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            JabberId recipientJabberId = (JabberId)element$iv;
            boolean bl = false;
            XmppSendMessagePayload payload = new XmppSendMessagePayload(this.systemUserId, recipientJabberId.toString(), subject, body2, null, 16, null);
            XmppRestApiService this_$iv = this;
            boolean $i$f$sendToXmppRestApi = false;
            XmppPayload cfr_ignored_0 = (XmppPayload)payload;
            Pair pair = TuplesKt.to((Object)"send_message", (Object)HttpMethod.POST);
            String command$iv = (String)pair.component1();
            HttpMethod httpMethod$iv = (HttpMethod)pair.component2();
            try {
                HttpEntity httpEntity$iv = new HttpEntity((Object)((XmppPayload)payload), (MultiValueMap)this_$iv.httpHeaders);
                ResponseEntity response$iv = this_$iv.restTemplate.exchange(this_$iv.xmppRestApiUrl + command$iv, httpMethod$iv, httpEntity$iv, Integer.class, new Object[0]);
                if (response$iv.getStatusCode() != HttpStatus.OK) {
                    throw new XmppException("Sending command " + command$iv + " failed with http status: " + response$iv.getStatusCode().value(), null, 2, null);
                }
                if (response$iv.getBody() == null) {
                    throw new XmppException("ejabberd returned nothing for command " + command$iv, null, 2, null);
                }
            }
            catch (RestClientException e$iv) {
                throw new XmppException("Could not access ejabberd at: " + this_$iv.xmppRestApiUrl + command$iv, (Throwable)e$iv);
            }
            int response = ((Number)object).intValue();
            if (response == 0) continue;
            throw new XmppException("Sending message payload " + payload + " resulted in error (" + response + ")", null, 2, null);
        }
    }

    private void sendPublishStanza(String payload, String nodeName, Set<UserGroupId> userGroupIds) {
        this.sendStanza((XmppStanza)new PublishItemStanza(nodeName, payload, null, 4, null));
        Iterable $this$forEach$iv = userGroupIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UserGroupId userGroupId = (UserGroupId)element$iv;
            boolean bl = false;
            this.sendStanza((XmppStanza)new PublishItemStanza(userGroupId.toCanonicalId(), payload, null, 4, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Set<ProfileId> getConnectedUsers() {
        Object object;
        void this_$iv;
        Pair pair;
        XmppRestApiService xmppRestApiService = this;
        XmppPayload payload$iv = (XmppPayload)XmppConnectedUsersPayload.INSTANCE;
        boolean $i$f$sendToXmppRestApi = false;
        XmppPayload xmppPayload = payload$iv;
        if (xmppPayload instanceof XmppSendMessagePayload) {
            pair = TuplesKt.to((Object)"send_message", (Object)HttpMethod.POST);
        } else if (xmppPayload instanceof XmppSendStanzaPayload) {
            pair = TuplesKt.to((Object)"send_stanza", (Object)HttpMethod.POST);
        } else if (xmppPayload instanceof XmppConnectedUsersPayload) {
            pair = TuplesKt.to((Object)"connected_users", (Object)HttpMethod.GET);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair pair2 = pair;
        String command$iv = (String)pair2.component1();
        HttpMethod httpMethod$iv = (HttpMethod)pair2.component2();
        try {
            HttpEntity httpEntity$iv = new HttpEntity((Object)payload$iv, (MultiValueMap)this_$iv.httpHeaders);
            ResponseEntity response$iv = this_$iv.restTemplate.exchange(this_$iv.xmppRestApiUrl + command$iv, httpMethod$iv, httpEntity$iv, List.class, new Object[0]);
            if (response$iv.getStatusCode() != HttpStatus.OK) {
                throw new XmppException("Sending command " + command$iv + " failed with http status: " + response$iv.getStatusCode().value(), null, 2, null);
            }
            if (response$iv.getBody() == null) {
                throw new XmppException("ejabberd returned nothing for command " + command$iv, null, 2, null);
            }
        }
        catch (RestClientException e$iv) {
            throw new XmppException("Could not access ejabberd at: " + this_$iv.xmppRestApiUrl + command$iv, (Throwable)e$iv);
        }
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)object)), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */)), arg_0 -> XmppRestApiService.getConnectedUsers$lambda$6(this, arg_0)), XmppRestApiService::getConnectedUsers$lambda$7), (Function1)((Function1)getConnectedUsers.4.INSTANCE)));
    }

    private /* synthetic */ <T> T sendToXmppRestApi(XmppPayload payload) {
        Pair pair;
        boolean $i$f$sendToXmppRestApi = false;
        XmppPayload xmppPayload = payload;
        if (xmppPayload instanceof XmppSendMessagePayload) {
            pair = TuplesKt.to((Object)"send_message", (Object)HttpMethod.POST);
        } else if (xmppPayload instanceof XmppSendStanzaPayload) {
            pair = TuplesKt.to((Object)"send_stanza", (Object)HttpMethod.POST);
        } else if (xmppPayload instanceof XmppConnectedUsersPayload) {
            pair = TuplesKt.to((Object)"connected_users", (Object)HttpMethod.GET);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair pair2 = pair;
        String command = (String)pair2.component1();
        HttpMethod httpMethod = (HttpMethod)pair2.component2();
        try {
            HttpEntity httpEntity = new HttpEntity((Object)payload, (MultiValueMap)this.httpHeaders);
            String string = this.xmppRestApiUrl + command;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            ResponseEntity response = this.restTemplate.exchange(string, httpMethod, httpEntity, Object.class, new Object[0]);
            if (response.getStatusCode() != HttpStatus.OK) {
                throw new XmppException("Sending command " + command + " failed with http status: " + response.getStatusCode().value(), null, 2, null);
            }
            Object object = response.getBody();
            if (object == null) {
                throw new XmppException("ejabberd returned nothing for command " + command, null, 2, null);
            }
            return (T)object;
        }
        catch (RestClientException e) {
            throw new XmppException("Could not access ejabberd at: " + this.xmppRestApiUrl + command, (Throwable)e);
        }
    }

    private static final boolean getConnectedUsers$lambda$6(XmppRestApiService this$0, JabberId it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getDomain(), (Object)this$0.domain);
    }

    private static final Long getConnectedUsers$lambda$7(JabberId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.toLongOrNull((String)it.getNode());
    }
}

