/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.totp;

import de.justsoftware.authorization.oauth2.JustUserDetailService;
import de.justsoftware.authorization.token.RememberMeTokenRepository;
import de.justsoftware.authorization.totp.TOTPAuthentication;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.rememberme.PersistentTokenBasedRememberMeServices;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0014"}, d2={"Lde/justsoftware/authorization/totp/TOTPAwareRememberMeService;", "Lorg/springframework/security/web/authentication/rememberme/PersistentTokenBasedRememberMeServices;", "key", "", "userDetailService", "Lde/justsoftware/authorization/oauth2/JustUserDetailService;", "rememberMeTokenRepository", "Lde/justsoftware/authorization/token/RememberMeTokenRepository;", "<init>", "(Ljava/lang/String;Lde/justsoftware/authorization/oauth2/JustUserDetailService;Lde/justsoftware/authorization/token/RememberMeTokenRepository;)V", "loginSuccess", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "successfulAuthentication", "Lorg/springframework/security/core/Authentication;", "rememberMeRequested", "", "just-authorization-server"})
public final class TOTPAwareRememberMeService
extends PersistentTokenBasedRememberMeServices {
    public TOTPAwareRememberMeService(@NotNull String key, @NotNull JustUserDetailService userDetailService, @NotNull RememberMeTokenRepository rememberMeTokenRepository) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)userDetailService, (String)"userDetailService");
        Intrinsics.checkNotNullParameter((Object)rememberMeTokenRepository, (String)"rememberMeTokenRepository");
        super(key, (UserDetailsService)userDetailService, (PersistentTokenRepository)rememberMeTokenRepository);
    }

    public void loginSuccess(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Authentication successfulAuthentication) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)successfulAuthentication, (String)"successfulAuthentication");
        if (successfulAuthentication instanceof TOTPAuthentication) {
            if (((TOTPAuthentication)successfulAuthentication).getRemember() && ((TOTPAuthentication)successfulAuthentication).getAuthenticated()) {
                super.onLoginSuccess(request, response, successfulAuthentication);
            }
        } else {
            super.loginSuccess(request, response, successfulAuthentication);
        }
    }

    public final boolean rememberMeRequested(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return super.rememberMeRequested(request, this.getParameter());
    }
}

