/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2;

import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.id.TenantId;
import de.justsoftware.authorization.oauth2.JustAuthenticationProviderKt;
import de.justsoftware.authorization.oauth2.JustToroUser;
import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.oauth2.LoginDto;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClient;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u001c\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/authorization/oauth2/JustAuthenticationProvider;", "Lorg/springframework/security/authentication/dao/AbstractUserDetailsAuthenticationProvider;", "toroInternalUrl", "", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/client/RestClient$Builder;)V", "getToroInternalUrl", "()Ljava/lang/String;", "restClient", "Lorg/springframework/web/client/RestClient;", "getRestClient", "()Lorg/springframework/web/client/RestClient;", "retrieveUser", "Lde/justsoftware/authorization/oauth2/JustUser;", "username", "authentication", "Lorg/springframework/security/authentication/UsernamePasswordAuthenticationToken;", "password", "additionalAuthenticationChecks", "", "userDetails", "Lorg/springframework/security/core/userdetails/UserDetails;", "just-authorization-server"})
@SourceDebugExtension(value={"SMAP\nJustAuthenticationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JustAuthenticationProvider.kt\nde/justsoftware/authorization/oauth2/JustAuthenticationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n295#2,2:83\n*S KotlinDebug\n*F\n+ 1 JustAuthenticationProvider.kt\nde/justsoftware/authorization/oauth2/JustAuthenticationProvider\n*L\n46#1:83,2\n*E\n"})
public class JustAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider {
    @NotNull
    private final String toroInternalUrl;
    @NotNull
    private final RestClient restClient;

    public JustAuthenticationProvider(@Value(value="${just.toro.internal}") @NotNull String toroInternalUrl, @NotNull RestClient.Builder restClientBuilder) {
        Intrinsics.checkNotNullParameter((Object)toroInternalUrl, (String)"toroInternalUrl");
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        this.toroInternalUrl = toroInternalUrl;
        RestClient restClient = restClientBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
        this.restClient = restClient;
    }

    @NotNull
    public String getToroInternalUrl() {
        return this.toroInternalUrl;
    }

    @NotNull
    public RestClient getRestClient() {
        return this.restClient;
    }

    @NotNull
    public JustUser retrieveUser(@NotNull String username, @NotNull UsernamePasswordAuthenticationToken authentication) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        return this.retrieveUser(username, authentication.getCredentials().toString());
    }

    @NotNull
    public JustUser retrieveUser(@NotNull String username, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String[] stringArray = new String[]{"trusted-device=" + JustAuthenticationProviderKt.access$getCurrentTrustedDeviceCookie()};
        RestClient.RequestBodySpec requestBodySpec = (RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.getRestClient().post().uri(this.getToroInternalUrl() + "/auth/login/", new Object[0])).header("Cookie", stringArray);
        stringArray = new MediaType[]{MediaType.APPLICATION_JSON};
        JustUser justUser = (JustUser)((RestClient.RequestBodySpec)requestBodySpec.accept((MediaType[])stringArray)).body((Object)new LoginDto(username, password)).exchange((arg_0, arg_1) -> JustAuthenticationProvider.retrieveUser$lambda$1(username, arg_0, arg_1));
        if (justUser == null) {
            throw new UsernameNotFoundException("null returned from toro when trying to load user " + username + ".");
        }
        return justUser;
    }

    protected void additionalAuthenticationChecks(@Nullable UserDetails userDetails, @Nullable UsernamePasswordAuthenticationToken authentication) {
    }

    private static final JustUser retrieveUser$lambda$1(String $username, HttpRequest httpRequest, RestClient.RequestHeadersSpec.ConvertibleClientHttpResponse clientResponse) {
        String string;
        List setCookieList;
        Intrinsics.checkNotNullParameter((Object)$username, (String)"$username");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)clientResponse, (String)"clientResponse");
        if (clientResponse.getStatusCode() != HttpStatus.OK) {
            return null;
        }
        JustToroUser justToroUser = (JustToroUser)clientResponse.bodyTo(JustToroUser.class);
        if (justToroUser == null) {
            throw new UsernameNotFoundException("null returned from toro when trying to load user " + $username + ".");
        }
        JustToroUser toroUser = justToroUser;
        List list = setCookieList = (List)clientResponse.getHeaders().get((Object)"Set-Cookie");
        if (list != null) {
            Object v2;
            block5: {
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!StringsKt.startsWith$default((String)it, (String)"trusted-device=", (boolean)false, (int)2, null)) continue;
                    v2 = element$iv;
                    break block5;
                }
                v2 = null;
            }
            string = v2;
        } else {
            string = null;
        }
        String retrievedTrustedDeviceCookieHeaderValue = string;
        String string2 = toroUser.getUsername();
        List list2 = toroUser.getAuthorities();
        ProfileId profileId = toroUser.getProfileId();
        TenantId tenantId = toroUser.getTenantId();
        boolean bl = toroUser.isAccountNonExpired();
        boolean bl2 = toroUser.isAccountNonLocked();
        boolean bl3 = toroUser.isCredentialsNonExpired();
        boolean bl4 = toroUser.isEnabled();
        return new JustUser(profileId, tenantId, string2, null, list2, bl, bl2, bl3, bl4, retrievedTrustedDeviceCookieHeaderValue);
    }
}

