/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.controller.internal;

import de.justsoftware.authorization.config.FeatureToggleService;
import de.justsoftware.authorization.config.JustAuthorizationContext;
import de.justsoftware.authorization.controller.TOTPDeviceDto;
import de.justsoftware.authorization.controller.TOTPSecretDto;
import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.totp.TOTPAuthenticationService;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal/totp"}, produces={"application/json"})
@ParametersAreNonnullByDefault
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017J \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0017J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/authorization/controller/internal/InternalTOTPDeviceController;", "", "totpAuthService", "Lde/justsoftware/authorization/totp/TOTPAuthenticationService;", "featureToggleService", "Lde/justsoftware/authorization/config/FeatureToggleService;", "<init>", "(Lde/justsoftware/authorization/totp/TOTPAuthenticationService;Lde/justsoftware/authorization/config/FeatureToggleService;)V", "deleteTOTPDevice", "", "profileId", "Lde/justsoftware/authorization/id/ProfileId;", "authContext", "Lde/justsoftware/authorization/config/JustAuthorizationContext;", "getTOTPDevice", "", "Lde/justsoftware/authorization/controller/TOTPDeviceDto;", "setupNewTOTPDevice", "Lde/justsoftware/authorization/controller/TOTPSecretDto;", "username", "", "setupAndGetNewTOTPDevice", "verifyNewTOTPDevice", "", "code", "just-authorization-server"})
@SourceDebugExtension(value={"SMAP\nInternalTOTPDeviceController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalTOTPDeviceController.kt\nde/justsoftware/authorization/controller/internal/InternalTOTPDeviceController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public class InternalTOTPDeviceController {
    @NotNull
    private final TOTPAuthenticationService totpAuthService;
    @NotNull
    private final FeatureToggleService featureToggleService;

    public InternalTOTPDeviceController(@NotNull TOTPAuthenticationService totpAuthService, @NotNull FeatureToggleService featureToggleService) {
        Intrinsics.checkNotNullParameter((Object)totpAuthService, (String)"totpAuthService");
        Intrinsics.checkNotNullParameter((Object)featureToggleService, (String)"featureToggleService");
        this.totpAuthService = totpAuthService;
        this.featureToggleService = featureToggleService;
    }

    @DeleteMapping(value={"/{profileId}"})
    public void deleteTOTPDevice(@PathVariable @NotNull ProfileId profileId, @NotNull JustAuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!this.featureToggleService.isMFAEnabled()) {
            boolean bl = false;
            String string = "MFA is not enabled";
            throw new IllegalArgumentException(string.toString());
        }
        this.totpAuthService.deleteTOTPDevice(profileId, authContext);
    }

    @GetMapping(value={"/{profileId}"})
    @NotNull
    public List<TOTPDeviceDto> getTOTPDevice(@PathVariable @NotNull ProfileId profileId, @NotNull JustAuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!this.featureToggleService.isMFAEnabled()) {
            boolean bl = false;
            String string = "MFA is not enabled";
            throw new IllegalArgumentException(string.toString());
        }
        return this.totpAuthService.findConfirmedTOTPDevice(profileId, authContext);
    }

    @GetMapping(value={"/setup/{username}"})
    @Deprecated(message="Will be replaced with fun getNewTOTPDevice(authContext: JustAuthorizationContext)", level=DeprecationLevel.WARNING)
    @Nullable
    public TOTPSecretDto setupNewTOTPDevice(@PathVariable @NotNull String username, @NotNull JustAuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!this.featureToggleService.isMFAEnabled()) {
            boolean bl = false;
            String string = "MFA is not enabled";
            throw new IllegalArgumentException(string.toString());
        }
        if (!this.totpAuthService.userHasConfirmedTOTPDevice(authContext.getProfileId())) {
            return TOTPAuthenticationService.getOrCreateNewDevice$default((TOTPAuthenticationService)this.totpAuthService, (String)username, (boolean)false, (int)2, null);
        }
        return null;
    }

    @GetMapping(value={"/setup"})
    @Nullable
    public TOTPSecretDto setupAndGetNewTOTPDevice(@NotNull JustAuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!this.featureToggleService.isMFAEnabled()) {
            boolean bl = false;
            String string = "MFA is not enabled";
            throw new IllegalArgumentException(string.toString());
        }
        if (!this.totpAuthService.userHasConfirmedTOTPDevice(authContext.getProfileId())) {
            return this.totpAuthService.createNewDevice();
        }
        return null;
    }

    @PutMapping(value={"/setup/{code}"})
    public boolean verifyNewTOTPDevice(@PathVariable @NotNull String code, @NotNull JustAuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!this.featureToggleService.isMFAEnabled()) {
            boolean bl = false;
            String string = "MFA is not enabled";
            throw new IllegalArgumentException(string.toString());
        }
        return this.totpAuthService.checkTOTPCodeAndConfirmDevice(code, authContext);
    }
}

